/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.utils.IconManager;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class WindowBox {
    private final String m_name;
    private final SplittedPanelContainer m_windowPanel;
    private final AbstractDataBox m_entryBox;

    public WindowBox(String name, SplittedPanelContainer windowPanel, AbstractDataBox entryBox, Image icon) {
        this.m_name = name;
        this.m_windowPanel = windowPanel;
        this.m_entryBox = entryBox;
        if (icon == null) {
            switch (entryBox.getStyle()) {
                case STYLE_RSET: {
                    icon = IconManager.getImage((IconManager.IconType)IconManager.IconType.DATASET_RSET);
                    break;
                }
                case STYLE_RSM: {
                    icon = IconManager.getImage((IconManager.IconType)IconManager.IconType.DATASET_RSM);
                    break;
                }
                case STYLE_XIC: {
                    icon = IconManager.getImage((IconManager.IconType)IconManager.IconType.QUANT_XIC);
                    break;
                }
                case STYLE_SC: {
                    icon = IconManager.getImage((IconManager.IconType)IconManager.IconType.QUANT_SC);
                }
            }
        }
        this.m_entryBox.setIcon(icon);
    }

    public String getName() {
        return this.m_name;
    }

    public Image getIcon() {
        return this.m_entryBox.getIcon();
    }

    public JPanel getPanel() {
        return this.m_windowPanel;
    }

    public AbstractDataBox getEntryBox() {
        return this.m_entryBox;
    }

    public void setEntryData(long projectId, Object data) {
        this.m_entryBox.setProjectId(projectId);
        this.m_entryBox.setEntryData(data);
    }

    public void selectDataWhenLoaded(HashSet data) {
        this.m_entryBox.selectDataWhenLoaded(data);
    }

    public void resetDefaultSize() {
        this.m_windowPanel.resetDefaultSize();
    }

    public void windowClosed() {
        this.m_entryBox.windowClosed();
    }

    public void windowOpened() {
        this.m_entryBox.windowOpened();
    }

    public void retrieveTableModels(ArrayList<TableInfo> list) {
        this.m_entryBox.retrieveTableModels(list);
        if (!list.isEmpty()) {
            list.get(0).setIcon(new ImageIcon(this.getIcon()));
        }
    }

    public void addDatabox(AbstractDataBox nextDatabox, SplittedPanelContainer.PanelLayout layout) {
        ArrayList<AbstractDataBox> nextArray;
        AbstractDataBox curBox = this.m_entryBox;
        while ((nextArray = curBox.getNextDataBoxArray()) != null && !nextArray.isEmpty()) {
            curBox = nextArray.get(0);
        }
        if (!curBox.equals(nextDatabox)) {
            curBox.addNextDataBox(nextDatabox);
        }
        nextDatabox.createPanel();
        if (layout == SplittedPanelContainer.PanelLayout.VERTICAL) {
            this.m_windowPanel.registerAddedPanel((JComponent)((JPanel)((Object)nextDatabox.getPanel())));
        } else if (layout == SplittedPanelContainer.PanelLayout.TABBED) {
            this.m_windowPanel.registerAddedPanelAsTab((JComponent)((JPanel)((Object)nextDatabox.getPanel())));
        } else {
            this.m_windowPanel.registerAddedPanelAsSplitted((JComponent)((JPanel)((Object)nextDatabox.getPanel())));
        }
        nextDatabox.dataChanged();
    }
}

