/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

public class ClearDatasetAction
extends AbstractRSMAction {
    boolean m_fullClear = false;

    public ClearDatasetAction(AbstractTree tree) {
        super("Clear Validation", tree);
    }

    public ClearDatasetAction(AbstractTree tree, boolean fullClear) {
        super(fullClear ? "Clear All" : "Clear Validation", tree);
        this.m_fullClear = fullClear;
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        StringBuilder sb = new StringBuilder("The Clear action will delete generated data (Identification Summary");
        if (this.m_fullClear) {
            sb.append(" and Merged DataSet)");
        } else {
            sb.append(")");
        }
        sb.append("\n(This can not be undone) Are you sure ?");
        String title = "Clear Dataset";
        int n = JOptionPane.showConfirmDialog((Component)WindowManager.getDefault().getMainWindow(), sb.toString(), title, 0, 2);
        if (n == 0) {
            IdentificationTree tree = IdentificationTree.getCurrentTree();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            int nbNodes = selectedNodes.length;
            for (int i = 0; i < nbNodes; ++i) {
                final DataSetNode node = (DataSetNode)selectedNodes[i];
                node.setIsChanging(true);
                treeModel.nodeChanged(node);
                AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                        if (success) {
                            DDataset dataset = node.getDataset();
                            dataset.setResultSummaryId(null);
                            dataset.setResultSummary(null);
                            if (ClearDatasetAction.this.m_fullClear && !node.isLeaf()) {
                                dataset.setResultSetId(null);
                                dataset.setResultSet(null);
                            }
                        }
                        node.setIsChanging(false);
                        treeModel.nodeChanged(node);
                    }
                };
                DDataset dataset = node.getDataset();
                DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                task.initClearDataset(dataset, this.m_fullClear && !node.isLeaf());
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
            }
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            DataSetNode parentDatasetNode;
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (datasetNode.isLeaf()) {
                DataSetNode parentDatasetNode2;
                if (!datasetNode.hasResultSummary()) {
                    this.setEnabled(false);
                    return;
                }
                AbstractNode parentNode = (AbstractNode)datasetNode.getParent();
                if (parentNode.getType() != AbstractNode.NodeTypes.DATA_SET || !(parentDatasetNode2 = (DataSetNode)parentNode).isChanging() && !parentDatasetNode2.hasResultSet() && !parentDatasetNode2.hasResultSummary()) continue;
                this.setEnabled(false);
                return;
            }
            if (!datasetNode.hasResultSummary() && !datasetNode.hasResultSet()) {
                this.setEnabled(false);
                return;
            }
            if (!datasetNode.hasResultSummary() && !this.m_fullClear) {
                this.setEnabled(false);
                return;
            }
            DDatasetType.AggregationInformation aggInfo = datasetNode.getDataset().getAggregationInformation();
            if ((aggInfo.equals((Object)DDatasetType.AggregationInformation.IDENTIFICATION_SUMMARY_AGG) || aggInfo.equals((Object)DDatasetType.AggregationInformation.IDENTIFICATION_SUMMARY_UNION)) && !this.m_fullClear) {
                this.setEnabled(false);
                return;
            }
            AbstractNode parentNode = (AbstractNode)datasetNode.getParent();
            if (parentNode.getType() != AbstractNode.NodeTypes.DATA_SET || !(parentDatasetNode = (DataSetNode)parentNode).isChanging() && !parentDatasetNode.hasResultSet() && !parentDatasetNode.hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

