/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.MergeTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

class ConfigurableMergeAction
extends AbstractRSMAction {
    private MergeTask.Config m_configuration;

    public ConfigurableMergeAction(AbstractTree tree, MergeTask.Config config) {
        super(config.getValue(), tree);
        this.m_configuration = config;
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        for (final AbstractNode node : selectedNodes) {
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    String error = null;
                    int nbChildren = node.getChildCount();
                    HashSet<Long> checkDifferentResultSetId = new HashSet<Long>();
                    ArrayList<Long> resultSetIdList = new ArrayList<Long>();
                    ArrayList<Long> resultSummaryIdList = new ArrayList<Long>();
                    for (int i = 0; i < nbChildren; ++i) {
                        DataSetNode childNode = (DataSetNode)node.getChildAt(i);
                        if (childNode.isChanging()) {
                            error = "Merge is not possible: child DataSet (" + childNode.getDataset().getName() + ") is being processed";
                            break;
                        }
                        if (!childNode.hasResultSet()) {
                            error = "Merge is not possible: " + childNode.getDataset().getName() + " has no Search Result";
                            break;
                        }
                        Long rsetId = childNode.getDataset().getResultSetId();
                        if (checkDifferentResultSetId.contains(rsetId)) {
                            error = "Merge is not possible: several Search Results are identical";
                            break;
                        }
                        checkDifferentResultSetId.add(rsetId);
                        resultSetIdList.add(rsetId);
                        if (!childNode.hasResultSummary()) continue;
                        resultSummaryIdList.add(childNode.getDataset().getResultSummaryId());
                    }
                    if (error != null) {
                        JOptionPane.showMessageDialog(IdentificationTree.getCurrentTree(), error, "Warning", 0);
                        return;
                    }
                    if (resultSummaryIdList.size() == nbChildren) {
                        ConfigurableMergeAction.this.askMergeService((DataSetNode)node, resultSummaryIdList, true);
                    } else if (resultSummaryIdList.size() > 0) {
                        error = "Merge is not possible: some Search Results are not validated ";
                        JOptionPane.showMessageDialog(IdentificationTree.getCurrentTree(), error, "Warning", 0);
                    } else {
                        ConfigurableMergeAction.this.askMergeService((DataSetNode)node, resultSetIdList, false);
                    }
                }
            };
            IdentificationTree.getCurrentTree().loadInBackground(node, callback);
        }
    }

    private void askMergeService(final DataSetNode node, List<Long> idList, boolean mergeOnRsm) {
        final DDataset dataset = node.getDataset();
        long projectId = dataset.getProject().getId();
        String datasetName = dataset.getName();
        node.setIsChanging(true);
        IdentificationTree tree = IdentificationTree.getCurrentTree();
        final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        treeModel.nodeChanged(node);
        final Long[] _resultSetId = new Long[1];
        final Long[] _resultSummaryId = new Long[1];
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                if (success) {
                    ConfigurableMergeAction.this.updateDataset(node, dataset, _resultSetId[0], _resultSummaryId[0], this.getTaskInfo());
                } else {
                    node.setIsChanging(false);
                    treeModel.nodeChanged(node);
                }
            }
        };
        MergeTask task = new MergeTask(callback, projectId, this.m_configuration);
        if (mergeOnRsm) {
            task.initMergeRsm(idList, datasetName, _resultSetId, _resultSummaryId);
        } else {
            _resultSummaryId[0] = null;
            task.initMergeRset(idList, datasetName, _resultSetId);
        }
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    private void updateDataset(final DataSetNode datasetNode, DDataset d, Long resultSetId, Long resultSummaryId, TaskInfo taskInfo) {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                datasetNode.setIsChanging(false);
                if (datasetNode.hasResultSummary()) {
                    if (MergeTask.Config.AGGREGATION.equals((Object)ConfigurableMergeAction.this.m_configuration)) {
                        datasetNode.getDataset().setAggregationInformation(DDatasetType.AggregationInformation.IDENTIFICATION_SUMMARY_AGG);
                    } else {
                        datasetNode.getDataset().setAggregationInformation(DDatasetType.AggregationInformation.IDENTIFICATION_SUMMARY_UNION);
                    }
                } else if (MergeTask.Config.AGGREGATION.equals((Object)ConfigurableMergeAction.this.m_configuration)) {
                    datasetNode.getDataset().setAggregationInformation(DDatasetType.AggregationInformation.SEARCH_RESULT_AGG);
                } else {
                    datasetNode.getDataset().setAggregationInformation(DDatasetType.AggregationInformation.SEARCH_RESULT_UNION);
                }
                IdentificationTree tree = IdentificationTree.getCurrentTree();
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                treeModel.nodeChanged(datasetNode);
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initModifyDatasetForMerge(d, resultSetId, resultSummaryId, taskInfo);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        AbstractNode node;
        int i;
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes < 0) {
            this.setEnabled(false);
            return;
        }
        HashSet<AbstractNode> allSelelectedNodeSet = new HashSet<AbstractNode>();
        for (i = 0; i < nbSelectedNodes; ++i) {
            node = selectedNodes[i];
            allSelelectedNodeSet.add(node);
        }
        for (i = 0; i < nbSelectedNodes; ++i) {
            node = selectedNodes[i];
            for (node = (AbstractNode)node.getParent(); node != null; node = (AbstractNode)node.getParent()) {
                if (!allSelelectedNodeSet.contains(node)) continue;
                this.setEnabled(false);
                return;
            }
        }
        for (i = 0; i < nbSelectedNodes; ++i) {
            node = selectedNodes[i];
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (datasetNode.isLeaf()) {
                this.setEnabled(false);
                return;
            }
            if (!((DataSetData)datasetNode.getData()).getDatasetType().isAggregation()) {
                this.setEnabled(false);
                return;
            }
            if (!datasetNode.hasResultSet()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

