/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.msi.Ptm;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.IdentifyPtmSitesTask;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.IdentifyPtmSitesDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifyPtmSitesJMSAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public IdentifyPtmSitesJMSAction(AbstractTree tree) {
        super("Identify Modification Sites", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        final DefaultTreeModel treeModel = (DefaultTreeModel)this.getTree().getModel();
        int nbNodes = selectedNodes.length;
        if (nbNodes > 0) {
            boolean isPTMDatasetLoaded = false;
            ArrayList<Ptm> ptms = new ArrayList<Ptm>();
            for (int i = 0; i < nbNodes; ++i) {
                ArrayList ptmSpecificities = new ArrayList();
                DataSetNode node = (DataSetNode)selectedNodes[i];
                if (DatabaseDataManager.getDatabaseDataManager().getPTMDatasetSetForDS(Long.valueOf(node.getDataset().getId())) != null || DatabaseDataManager.getDatabaseDataManager().getPTMDatasetSetForDS(Long.valueOf(node.getDataset().getId())) != null) {
                    isPTMDatasetLoaded = true;
                }
                DatabasePTMsTask ptmTask = new DatabasePTMsTask(null);
                ptmTask.initLoadUsedPTMs(Long.valueOf(node.getDataset().getProject().getId()), node.getDataset().getResultSummaryId(), ptmSpecificities);
                ptmTask.fetchData();
                ptms.addAll(ptmSpecificities.stream().map(s -> s.getPtm()).distinct().collect(Collectors.toList()));
            }
            TreeSet ptmsTreeSet = ptms.stream().collect(Collectors.toCollection(() -> new TreeSet<Ptm>(Comparator.comparing(p -> p.getId()))));
            ptms = new ArrayList(ptmsTreeSet);
            IdentifyPtmSitesDialog dialog = new IdentifyPtmSitesDialog((Window)WindowManager.getDefault().getMainWindow(), ptms);
            dialog.setLocation(x, y);
            dialog.setVisible(true);
            if (dialog.getButtonClicked() == 0) {
                StringBuilder msg = isPTMDatasetLoaded ? new StringBuilder("Be sure to close all previous Modification Site/Cluster view !\n\n") : new StringBuilder();
                msg.append("Warning: Previously saved Annotated Modification Dataset will be deleted ! \nAre you sure you want to continue ?");
                InfoDialog id = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Run Identify Modification Sites", msg.toString());
                id.setButtonName(0, "Yes");
                id.setButtonName(1, "No");
                id.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                id.setVisible(true);
                if (id.getButtonClicked() == 1) {
                    return;
                }
                for (int i = 0; i < nbNodes; ++i) {
                    final DataSetNode node = (DataSetNode)selectedNodes[i];
                    AbstractJMSCallback callback = new AbstractJMSCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success) {
                            node.setIsChanging(false);
                            treeModel.nodeChanged(node);
                            if (success) {
                                DatabaseDataManager.getDatabaseDataManager().removeAllPTMDatasetsForDS(Long.valueOf(node.getDataset().getId()));
                            }
                        }
                    };
                    DDataset dataset = node.getDataset();
                    node.setIsChanging(true);
                    treeModel.nodeChanged(node);
                    Long projectId = dataset.getProject().getId();
                    Long resultSummaryId = dataset.getResultSummaryId();
                    IdentifyPtmSitesTask task = new IdentifyPtmSitesTask(callback, dataset.getName(), projectId, resultSummaryId, null, "2.0", dialog.getPtms(), dialog.getClusteringMethodName());
                    AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                }
            }
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (dataSetNode.isFolder()) {
                this.setEnabled(false);
                return;
            }
            if (dataSetNode.hasResultSet() && dataSetNode.hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

