/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.CertifyIdentificationTask;
import fr.proline.studio.dpm.task.jms.ImportIdentificationTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.ImportIdentificationDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.identification.IdAllImportedNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;

public class ImportSearchResultAsRsetJMSAction
extends AbstractRSMAction {
    private static int m_beingImportedNumber = 0;
    private static HashMap<Long, ArrayList<ChangeListener>> m_listenerMap = new HashMap();

    public ImportSearchResultAsRsetJMSAction(AbstractTree tree) {
        super("Import Search Result...", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        final IdAllImportedNode allImportedNode = (IdAllImportedNode)selectedNodes[0];
        IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)allImportedNode.getParent();
        Project project = projectNode.getProject();
        ImportIdentificationDialog dialog = ImportIdentificationDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            final File[] filePaths = dialog.getFilePaths();
            final HashMap<String, String> parserArguments = dialog.getParserArguments();
            final String parserId = dialog.getParserId();
            final String decoyRegex = dialog.getDecoyRegex();
            final long instrumentId = dialog.getInstrumentId();
            final long peaklistSoftwareId = dialog.getPeaklistSoftwareId();
            final long fragRuleSetId = dialog.getFragmentationRuleSetId();
            IdentificationTree tree = IdentificationTree.getCurrentTree();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            allImportedNode.setIsChanging(true);
            treeModel.nodeChanged(allImportedNode);
            final Long projectId = project.getId();
            int nbFiles = filePaths.length;
            String[] pathArray = new String[nbFiles];
            for (int i = 0; i < nbFiles; ++i) {
                File f = filePaths[i];
                pathArray[i] = f.getPath();
            }
            String[] result = new String[1];
            AbstractJMSCallback callback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (success) {
                        ImportSearchResultAsRsetJMSAction.this.startImport(projectId, allImportedNode, filePaths, treeModel, parserId, parserArguments, decoyRegex, instrumentId, peaklistSoftwareId, fragRuleSetId);
                    } else {
                        allImportedNode.setIsChanging(false);
                        treeModel.nodeChanged(allImportedNode);
                    }
                }
            };
            CertifyIdentificationTask task = new CertifyIdentificationTask(callback, parserId, parserArguments, pathArray, projectId.longValue(), result);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    private void startImport(final Long projectId, final IdAllImportedNode allImportedNode, File[] filePaths, final DefaultTreeModel treeModel, String parserId, HashMap<String, String> parserArguments, String decoyRegex, long instrumentId, long peaklistSoftwareId, long fragmentationRuleSetId) {
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                ImportSearchResultAsRsetJMSAction.fireListener(projectId);
                m_beingImportedNumber--;
                if (m_beingImportedNumber == 0) {
                    allImportedNode.setIsChanging(false);
                    treeModel.nodeChanged(allImportedNode);
                }
            }
        };
        int nbFiles = filePaths.length;
        m_beingImportedNumber += nbFiles;
        for (int i = 0; i < nbFiles; ++i) {
            File f = filePaths[i];
            String path = f.getPath();
            Long[] resultSetId = new Long[1];
            ImportIdentificationTask task = new ImportIdentificationTask(callback, parserId, parserArguments, path, decoyRegex, instrumentId, peaklistSoftwareId, false, fragmentationRuleSetId, projectId.longValue(), resultSetId);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public static synchronized void addEventListener(Long key, ChangeListener l) {
        ArrayList<ChangeListener> listeners = m_listenerMap.get(key);
        if (listeners == null) {
            listeners = new ArrayList(1);
            m_listenerMap.put(key, listeners);
        }
        listeners.add(l);
    }

    public static synchronized void removeEventListener(Long key, ChangeListener l) {
        ArrayList<ChangeListener> listeners = m_listenerMap.get(key);
        if (listeners == null) {
            return;
        }
        listeners.remove(l);
        if (listeners.isEmpty()) {
            m_listenerMap.remove(key);
        }
    }

    public static synchronized void fireListener(Long key) {
        ArrayList<ChangeListener> listeners = m_listenerMap.get(key);
        if (listeners == null) {
            return;
        }
        int nb = listeners.size();
        for (int i = 0; i < nb; ++i) {
            listeners.get(i).stateChanged(null);
        }
    }
}

