/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.ComputeQuantPostProcessingTask;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.QuantPostProcessingDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import fr.proline.studio.utils.ResultCallback;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

public class ComputeQuantPostProcessingAction
extends AbstractRSMAction {
    private int m_nbLoadedQuanti;

    public ComputeQuantPostProcessingAction(AbstractTree tree) {
        super("Compute Post Processing on Abundances...", tree);
    }

    @Override
    public void actionPerformed(final AbstractNode[] selectedNodes, int x, int y) {
        if (ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject() == null) {
            JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), "A project should be selected !", "Warning", 0);
            return;
        }
        final Long pID = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId();
        final int posX = x;
        final int posY = y;
        final ArrayList computedList = new ArrayList();
        final ArrayList selectedDatasetNodeList = new ArrayList();
        this.m_nbLoadedQuanti = 0;
        for (AbstractNode n : selectedNodes) {
            final DataSetNode node = (DataSetNode)n;
            final DDataset dataSet = ((DataSetData)node.getData()).getDataset();
            AbstractDatabaseCallback masterQuantChannelCallback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        if (dataSet.getPostQuantProcessingConfig() != null) {
                            computedList.add(node);
                        } else {
                            selectedDatasetNodeList.add(node);
                        }
                        ComputeQuantPostProcessingAction.this.m_nbLoadedQuanti++;
                        if (ComputeQuantPostProcessingAction.this.m_nbLoadedQuanti == selectedNodes.length) {
                            if (!computedList.isEmpty()) {
                                String[] options = new String[]{"Compute All", "Skip already computed"};
                                String computedNodeName = computedList.stream().map(node -> node.getDataset().getName()).collect(Collectors.joining(","));
                                String message = "Dataset " + computedNodeName + ": Proteins Sets Abundances have already been post-processed \n(Compute Quant Post-Processing done).";
                                OptionDialog yesNoDialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Compute Post-Processing on Proteins Sets Abundances", message);
                                yesNoDialog.setButtonName(0, options[0]);
                                yesNoDialog.setButtonName(1, options[1]);
                                yesNoDialog.setLocation(posX, posY);
                                yesNoDialog.setVisible(true);
                                if (yesNoDialog.getButtonClicked() == 0) {
                                    for (AbstractNode an : computedList) {
                                        DataSetNode dn = (DataSetNode)an;
                                        selectedDatasetNodeList.add(dn);
                                    }
                                }
                            }
                            if (!selectedDatasetNodeList.isEmpty()) {
                                ComputeQuantPostProcessingAction.quantificationProfile(null, posX, posY, pID, selectedDatasetNodeList, null);
                            }
                        }
                    }
                }
            };
            DatabaseDataSetTask loadTask = new DatabaseDataSetTask(masterQuantChannelCallback);
            loadTask.initLoadQuantitation(ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject(), dataSet);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)loadTask);
        }
    }

    public static boolean quantificationProfile(final ResultCallback resultCallback, int posX, int posY, Long pID, ArrayList<DataSetNode> nodeList, DDataset paramsFromdataset) {
        ArrayList<PtmSpecificity> ptms = ComputeQuantPostProcessingAction.fetchPtmsFromDAM(nodeList);
        boolean isAggregation = ComputeQuantPostProcessingAction.isAllAggregation(nodeList, posX, posY);
        QuantPostProcessingDialog dialog = new QuantPostProcessingDialog((Window)WindowManager.getDefault().getMainWindow(), ptms, isAggregation, paramsFromdataset);
        dialog.setLocation(posX, posY);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            String errorMsg = null;
            Map<String, Object> quantParams = dialog.getQuantParams();
            if (quantParams == null) {
                errorMsg = "Null Quantitation parameters !";
            }
            if (errorMsg != null) {
                JOptionPane.showMessageDialog((Component)((Object)dialog), errorMsg, "Warning", 0);
                return false;
            }
            if (nodeList != null) {
                for (final DataSetNode node : nodeList) {
                    node.setIsChanging(true);
                    QuantitationTree tree = QuantitationTree.getCurrentTree();
                    DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                    treeModel.nodeChanged(node);
                }
            }
            for (final DataSetNode node : nodeList) {
                DDataset dataset = node.getDataset();
                String xicName = dataset.getName();
                List listMasterQuantChannels = dataset.getMasterQuantitationChannels();
                if (listMasterQuantChannels == null || listMasterQuantChannels.isEmpty()) continue;
                Long masterQuantChannelId = new Long(((DMasterQuantitationChannel)listMasterQuantChannels.get(0)).getId());
                AbstractJMSCallback xicCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (node != null) {
                            QuantitationTree tree = QuantitationTree.getCurrentTree();
                            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                            node.setIsChanging(false);
                            treeModel.nodeChanged(node);
                        }
                        if (resultCallback != null) {
                            resultCallback.run(success);
                        }
                    }
                };
                ComputeQuantPostProcessingTask task = new ComputeQuantPostProcessingTask(xicCallback, pID, masterQuantChannelId, quantParams, xicName);
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
            }
            return true;
        }
        return false;
    }

    public static boolean quantificationProfile(ResultCallback resultCallback, int posx, int posy, Long pID, DDataset paramsFromdataSet) {
        ArrayList<DataSetNode> nodeList = new ArrayList<DataSetNode>();
        nodeList.add(new DataSetNode((AbstractData)new DataSetData(paramsFromdataSet)));
        return ComputeQuantPostProcessingAction.quantificationProfile(resultCallback, posx, posy, pID, nodeList, paramsFromdataSet);
    }

    private static ArrayList<PtmSpecificity> fetchPtmsFromDAM(ArrayList<DataSetNode> nodeList) {
        ArrayList<PtmSpecificity> ptms = new ArrayList<PtmSpecificity>();
        DatabasePTMsTask task = new DatabasePTMsTask(null);
        ArrayList<Long> rsmIdList = new ArrayList<Long>();
        long projectId = nodeList.get(0).getDataset().getProject().getId();
        for (int i = 0; i < nodeList.size(); ++i) {
            DDataset dataset = nodeList.get(i).getDataset();
            rsmIdList.add(dataset.getResultSummaryId());
        }
        task.initLoadUsedPTMs(Long.valueOf(projectId), rsmIdList, ptms);
        task.fetchData();
        return ptms;
    }

    private static boolean isAllAggregation(ArrayList<DataSetNode> nodeList, int posX, int posY) {
        String quantitationList = "";
        String aggregationList = "";
        for (DataSetNode node : nodeList) {
            boolean test;
            DDataset dataset = node.getDataset();
            boolean bl = test = dataset.isQuantitation() && dataset.isAggregation();
            if (test) {
                aggregationList = aggregationList + dataset.getName() + " ";
                continue;
            }
            quantitationList = quantitationList + dataset.getName() + " ";
        }
        if (quantitationList.isEmpty()) {
            return true;
        }
        if (aggregationList.isEmpty()) {
            return false;
        }
        String errorMsg = "The selection has Aggregated Quatitation dataSets and Quatitation datasets.";
        errorMsg = errorMsg + "\n Quantitation: " + quantitationList;
        errorMsg = errorMsg + "\n Aggregation: " + aggregationList;
        errorMsg = errorMsg + "\n The option Discard_Peptides_Sharing_Peakels will not be available";
        JOptionPane pane = new JOptionPane(errorMsg, 1);
        JDialog d = pane.createDialog(null, "Warning");
        d.setLocation(posX, posY);
        d.setVisible(true);
        return true;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (datasetNode.isQuantXIC()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

