/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;

public class DisplayMapMoZAlignmentAction
extends AbstractRSMAction {
    public DisplayMapMoZAlignmentAction(AbstractTree tree) {
        super("MoZ Calibration", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        int nbNodes = selectedNodes.length;
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            this.actionImpl(dataSetNode);
        }
    }

    private void actionImpl(DataSetNode dataSetNode) {
        DDataset dataset = ((DataSetData)dataSetNode.getData()).getDataset();
        WindowBox wbox = WindowBoxFactory.getMapMozCalibrationWindowBox(dataset.getName(), dataset.getName() + " Moz calibration");
        wbox.setEntryData(dataset.getProject().getId(), dataset);
        DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
        WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        if (selectedNodes.length != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        if (node.isChanging()) {
            this.setEnabled(false);
            return;
        }
        if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
            this.setEnabled(false);
            return;
        }
        if (node.getType() == AbstractNode.NodeTypes.DATA_SET && ((DataSetNode)node).getDataset().isAggregation()) {
            this.setEnabled(false);
            return;
        }
        DataSetNode datasetNode = (DataSetNode)node;
        if (datasetNode.isFolder()) {
            this.setEnabled(false);
            return;
        }
        if (!datasetNode.isQuantXIC()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

