/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.rsmexplorer.gui.FlipButton;
import fr.proline.studio.rsmexplorer.gui.MSDiagOutput_AW;
import fr.proline.studio.rsmexplorer.gui.RsetMSDiagPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSDiag_Chromatogram
extends HourglassPanel {
    public static final String SERIES_NAME = "Chromatogram";
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final long serialVersionUID = 1L;
    private final DefaultTableXYDataset m_dataSet;
    private final JFreeChart m_chart;
    private JPanel m_chromatogramPanel;
    private final RsetMSDiagPanel m_msdiagPanel;

    public MSDiag_Chromatogram(RsetMSDiagPanel rsetMSDiagPanel) {
        this.m_msdiagPanel = rsetMSDiagPanel;
        this.m_dataSet = new DefaultTableXYDataset();
        NumberAxis numberaxis = new NumberAxis("X");
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis numberaxis1 = new NumberAxis("Y");
        StackedXYBarRenderer renderer = new StackedXYBarRenderer(0.0);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        renderer.setDrawBarOutline(false);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setSeriesPaint(0, (Paint)new Color(220, 220, 220));
        renderer.setSeriesPaint(1, (Paint)new Color(176, 190, 255));
        renderer.setSeriesPaint(2, (Paint)new Color(132, 153, 255));
        renderer.setSeriesPaint(3, (Paint)new Color(91, 120, 255));
        renderer.setSeriesPaint(4, (Paint)new Color(64, 98, 255));
        renderer.setSeriesPaint(5, (Paint)new Color(32, 71, 255));
        renderer.setSeriesPaint(6, (Paint)new Color(1, 191, 220));
        renderer.setSeriesPaint(7, (Paint)new Color(126, 84, 214));
        XYPlot plot = new XYPlot((XYDataset)this.m_dataSet, (ValueAxis)numberaxis, (ValueAxis)numberaxis1, (XYItemRenderer)renderer);
        this.m_chart = new JFreeChart("Combined Chart title", new Font("SansSerif", 1, 12), (Plot)plot, true);
        TextTitle textTitle = this.m_chart.getTitle();
        textTitle.setFont(textTitle.getFont().deriveFont(0, 10.0f));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ChartPanel cp = new ChartPanel(this.m_chart, true);
        cp.setMinimumDrawWidth(0);
        cp.setMinimumDrawHeight(0);
        cp.setMaximumDrawWidth(Integer.MAX_VALUE);
        cp.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.m_chromatogramPanel = cp;
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
        this.add(this.m_chromatogramPanel, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FlipButton flipModeButton = new FlipButton("flip button text", this.m_msdiagPanel);
        toolbar.add(flipModeButton);
        ExportButton exportImageButton = new ExportButton("chart", this.m_chromatogramPanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(MSDiagOutput_AW msdo) {
        this.constructChromatogram(msdo);
    }

    private void constructChromatogram(MSDiagOutput_AW msdo) {
        this.m_dataSet.removeAllSeries();
        if (msdo == null) {
            return;
        }
        String title = msdo.description;
        this.m_chart.setTitle(title);
        this.m_chart.getXYPlot().getDomainAxis().setLabel(msdo.x_axis_description);
        this.m_chart.getXYPlot().getRangeAxis().setLabel(msdo.y_axis_description);
        int nbSeries = msdo.matrix[0].length;
        int nbCategories = msdo.matrix.length - 1;
        for (int serie = 1; serie < nbSeries; ++serie) {
            XYSeries xyseries = new XYSeries((Comparable)((Object)msdo.column_names[serie]), true, false);
            for (int cat = 0; cat < nbCategories; ++cat) {
                double y = (Double)msdo.matrix[cat][serie];
                if (!(y > 0.0)) continue;
                double x = (Double)msdo.matrix[cat][0];
                xyseries.add(x, y);
            }
            this.m_dataSet.addSeries(xyseries);
        }
    }
}

