/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.SequenceMatchPK;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.DatabaseBioSequenceTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.RsmProteinAndPeptideOverviewPlotPanel;
import fr.proline.studio.utils.DataFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsmProteinAndPeptideSequencePanel
extends HourglassPanel
implements DataBoxPanelInterface {
    private static final Logger m_logger = LoggerFactory.getLogger(RsmProteinAndPeptideSequencePanel.class);
    private AbstractDataBox m_dataBox;
    private JEditorPane m_editorPane;
    private JScrollPane m_sequenceScrollPane;
    private RsmProteinAndPeptideOverviewPlotPanel m_sequencePoltPane;
    private JPanel m_sequencePanel;
    private final int HIGHLIGHT_NONE = 0;
    private final int HIGHLIGHT_PEPTIDE_SELECTED = 1;
    private final int HIGHLIGHT_PEPTIDE_NOT_SELECTED = 2;
    private final int HIGHLIGHT_MULTI_PEPTIDE_NOT_SELECTED = 4;
    private final int HIGHLIGHT_NTER_OR_CTER_MODIFICATION = 8;
    private final int HIGHLIGHT_OTHER_MODIFICATION = 16;

    public RsmProteinAndPeptideSequencePanel() {
        this.setLayout(new BorderLayout());
        this.m_sequencePoltPane = new RsmProteinAndPeptideOverviewPlotPanel(this);
        this.m_sequencePanel = this.createSequencePanel();
        this.add(this.m_sequencePanel, "Center");
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
    }

    private JPanel createSequencePanel() {
        JPanel sequencePanel = new JPanel(new BorderLayout());
        this.m_sequenceScrollPane = new JScrollPane();
        this.m_editorPane = new JEditorPane();
        this.m_sequenceScrollPane.setViewportView(this.m_editorPane);
        this.m_editorPane.setEditable(false);
        this.m_editorPane.setContentType("text/html");
        HTMLEditorKit kit = new HTMLEditorKit();
        this.m_editorPane.setEditorKit(kit);
        StyleSheet styleSheet = kit.getStyleSheet();
        Color selectionColor = UIManager.getColor("Table.selectionBackground");
        styleSheet.addRule("p.body {color:black; font: bold 10px monospace; margin: 4px; }");
        styleSheet.addRule("span.peptidesel {background-color:#" + Integer.toHexString(selectionColor.getRGB() & 0xFFFFFF) + "; color:white;}");
        styleSheet.addRule("span.onepeptide {background-color: #DDDDDD;}");
        styleSheet.addRule("span.multipeptides {background-color: #C0C0C0;}");
        styleSheet.addRule("span.modif_nter_cter {background-color: #ce85fd;}");
        styleSheet.addRule("span.modif {background-color: #fdb800;}");
        styleSheet.addRule("span.nter_cter {background-color: #6eb86a;}");
        Document doc = kit.createDefaultDocument();
        this.m_editorPane.setDocument(doc);
        this.m_sequencePoltPane.setPreferredSize(new Dimension(this.getWidth(), 50));
        this.m_sequenceScrollPane.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - 50));
        sequencePanel.add((Component)this.m_sequenceScrollPane, "Center");
        sequencePanel.add((Component)this.m_sequencePoltPane, "South");
        return sequencePanel;
    }

    public final JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("Protein Sequence", this.m_sequencePanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(Long projectId, DProteinMatch pm, DPeptideInstance selectedPeptide, DPeptideInstance[] peptideInstances) {
        if (pm == null) {
            this.m_editorPane.setText("");
            return;
        }
        if (peptideInstances == null) {
            this.m_editorPane.setText("");
            return;
        }
        if (!DatabaseDataManager.getDatabaseDataManager().isSeqDatabaseExists()) {
            this.m_editorPane.setText("There is no Protein Sequence Database available. Please contact your IT Administrator to install it.");
            return;
        }
        if (!pm.isDBiosequenceSet() && projectId != null) {
            m_logger.info("BioSequence is absent from the protein match, trying to load it ...");
            DatabaseBioSequenceTask.fetchData(Collections.singletonList(pm), (Long)projectId);
        }
        if (pm.isDBiosequenceSet()) {
            String sequence = pm.getDBioSequence().getSequence();
            int sequenceLength = sequence.length();
            int[] highlights = new int[sequenceLength];
            for (int i = 0; i < sequenceLength; ++i) {
                highlights[i] = 0;
            }
            int nbPeptides = peptideInstances.length;
            for (int i = 0; i < nbPeptides; ++i) {
                if (peptideInstances[i].equals(selectedPeptide)) continue;
                DPeptideMatch peptideMatch = peptideInstances[i].getBestPeptideMatch();
                this.hightlight(peptideMatch, false, highlights);
            }
            if (selectedPeptide != null) {
                this.hightlight(selectedPeptide.getBestPeptideMatch(), true, highlights);
            }
            int noCoverageNumber = 0;
            for (int i = 0; i < sequenceLength; ++i) {
                if (highlights[i] != 0) continue;
                ++noCoverageNumber;
            }
            double coverage = (double)(sequenceLength - noCoverageNumber) / (double)sequenceLength * 100.0;
            String coverageFormatted = DataFormat.format((double)coverage, (int)2);
            this.m_editorPane.setText(this.constructDisplayedSequence(pm, sequence, highlights, coverageFormatted));
            this.m_editorPane.setCaretPosition(0);
            this.m_sequencePoltPane.setData(pm.getAccession(), sequence, selectedPeptide, peptideInstances);
        } else {
            this.m_editorPane.setText("Protein Sequence not available in database");
            this.m_sequencePoltPane.setData(pm.getAccession(), null, selectedPeptide, peptideInstances);
        }
        this.repaint();
    }

    private void hightlight(DPeptideMatch p, boolean selectedPeptide, int[] highlights) {
        HashMap ptmMap;
        int j;
        SequenceMatchPK smpk = p.getSequenceMatch().getId();
        int start = smpk.getStart();
        int stop = smpk.getStop();
        if (selectedPeptide) {
            for (j = start; j <= stop; ++j) {
                highlights[j - 1] = 1;
            }
        } else {
            for (j = start; j <= stop; ++j) {
                if ((highlights[j - 1] & 2) == 2) {
                    int n = j - 1;
                    highlights[n] = highlights[n] | 4;
                    continue;
                }
                int n = j - 1;
                highlights[n] = highlights[n] | 2;
            }
        }
        if ((ptmMap = p.getPeptide().getTransientData().getDPeptidePtmMap()) != null) {
            Collection peptidePtms = ptmMap.values();
            for (DPeptidePTM ptm : peptidePtms) {
                int pos = (int)ptm.getSeqPosition();
                if (pos == 0) {
                    int n = start - 1;
                    highlights[n] = highlights[n] | 8;
                    continue;
                }
                if (pos == -1) {
                    int n = stop - 1;
                    highlights[n] = highlights[n] | 8;
                    continue;
                }
                int n = start - 1 + pos - 1;
                highlights[n] = highlights[n] | 0x10;
            }
        }
    }

    private String constructDisplayedSequence(DProteinMatch pm, String sequence, int[] highlights, String coverageFormatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><p class='body'>");
        int previousState = 0;
        int nb = sequence.length();
        for (int i = 0; i < nb; ++i) {
            char c = sequence.charAt(i);
            int state = highlights[i];
            if (state != previousState) {
                if (previousState != 0) {
                    sb.append("</span>");
                }
                if (i % 10 == 0) {
                    sb.append(' ');
                }
                if ((state & 0x10) == 16) {
                    if ((state & 8) == 8) {
                        sb.append("<span class='modif_nter_cter'>");
                    } else {
                        sb.append("<span class='modif'>");
                    }
                } else if ((state & 8) == 8) {
                    sb.append("<span class='nter_cter'>");
                } else if ((state & 1) == 1) {
                    sb.append("<span class='peptidesel'>");
                } else if ((state & 4) == 4) {
                    sb.append("<span class='multipeptides'>");
                } else if ((state & 2) == 2) {
                    sb.append("<span class='onepeptide'>");
                }
            } else if (i % 10 == 0) {
                sb.append(' ');
            }
            sb.append(c);
            previousState = state;
        }
        if (previousState != 0) {
            sb.append("</span>");
        }
        sb.append("<br><br>");
        sb.append("<span class='nter_cter'>&nbsp;&nbsp;</span>&nbsp;N/C-ter PTM&nbsp;&nbsp;&nbsp;&nbsp;");
        sb.append("<span class='modif'>&nbsp;&nbsp;</span>&nbsp;AA PTM&nbsp;&nbsp;&nbsp;&nbsp;");
        sb.append("<span class='modif_nter_cter'>&nbsp;&nbsp;</span>&nbsp;N/C-ter and AA PTM");
        sb.append("<br><br>");
        sb.append("Coverage : ").append(coverageFormatted).append('%');
        sb.append("<br><br>");
        sb.append(pm.getAccession()).append(" : ").append(pm.getDescription());
        sb.append("</p></body></html>");
        return sb.toString();
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }
}

