/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SelectLevelRadioButtonGroup {
    private final JRadioButton m_radioButton;
    private final JLabel m_validationLabel;
    private final JLabel m_automaticLabel;

    public SelectLevelRadioButtonGroup(JPanel containerPanel, GridBagConstraints c, String text, ImageIcon icon) {
        this.m_radioButton = new JRadioButton(text);
        this.m_validationLabel = new JLabel(icon){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(16, 16);
            }
        };
        this.m_validationLabel.setHorizontalTextPosition(2);
        this.m_validationLabel.setVerticalTextPosition(3);
        this.m_validationLabel.setToolTipText(text);
        this.m_automaticLabel = new JLabel(""){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(16, 16);
            }
        };
        containerPanel.add((Component)this.m_radioButton, c);
        ++c.gridx;
        containerPanel.add((Component)this.m_validationLabel, c);
        ++c.gridx;
        containerPanel.add((Component)this.m_automaticLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        containerPanel.add(Box.createHorizontalGlue(), c);
        c.weightx = 0.0;
    }

    public JRadioButton getRadioButton() {
        return this.m_radioButton;
    }

    public void addIcon(int selectLevel) {
        String tooltips;
        boolean isManual = false;
        switch (selectLevel) {
            case 0: 
            case 3: {
                isManual = true;
                break;
            }
            case 1: 
            case 2: {
                isManual = false;
            }
        }
        ImageIcon icon = null;
        if (isManual) {
            icon = new ImageIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HAND_OPEN).getImage().getScaledInstance(16, 16, 1));
            tooltips = "Manual";
        } else {
            icon = new ImageIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.GEAR).getImage().getScaledInstance(16, 16, 1));
            tooltips = "Automatic";
        }
        this.m_automaticLabel.setIcon(icon);
        this.m_automaticLabel.setToolTipText(tooltips);
    }

    public void removeOptionIcon() {
        this.m_automaticLabel.setIcon(null);
    }
}

