/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.Exceptions;
import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import fr.proline.studio.msfiles.MzdbUploadBatch;
import fr.proline.studio.msfiles.MzdbUploadSettings;
import fr.proline.studio.rsmexplorer.gui.DropZoneInterface;
import fr.proline.studio.rsmexplorer.gui.FilesTransferable;
import fr.proline.studio.rsmexplorer.gui.IconData;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooser;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserPanel;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserTableModelInterface;
import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeFileChooserTransferHandler
extends TransferHandler {
    private HashMap<JComponent, JComponent> m_components = new HashMap();

    public void addComponent(JComponent component) {
        this.m_components.put(component, component);
    }

    public void clearHighlights() {
        for (JComponent key : this.m_components.keySet()) {
            key.setBackground(null);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof TreeFileChooser) {
            TreeFileChooser tree = (TreeFileChooser)c;
            ArrayList<File> selectedFiles = tree.getSelectedFiles();
            if (selectedFiles.isEmpty()) {
                return null;
            }
            return new FilesTransferable(selectedFiles, FilesTransferable.SourceFileSystem.SOURCE_SERVE_FILE_SYSTEM);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        this.clearHighlights();
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        support.setShowDropLocation(true);
        if (support.isDataFlavorSupported(FilesTransferable.Files_FLAVOR)) {
            TransferHandler.DropLocation dropLocation = support.getDropLocation();
            if (dropLocation instanceof JTable.DropLocation) {
                return true;
            }
            if (this.m_components.containsKey((JComponent)support.getComponent())) {
                this.m_components.get((JComponent)support.getComponent()).setBackground(Color.WHITE);
                return true;
            }
            if (dropLocation instanceof JTree.DropLocation) {
                try {
                    FilesTransferable transferable = (FilesTransferable)support.getTransferable().getTransferData(FilesTransferable.Files_FLAVOR);
                    if (transferable.getSource() == FilesTransferable.SourceFileSystem.SOURCE_LOCAL_FILE_SYSTEM) {
                        JTree.DropLocation treeDropLocation = (JTree.DropLocation)support.getDropLocation();
                        TreePath treePath = treeDropLocation.getPath();
                        DropInfo dropInfo = this.checkServer(treePath);
                        if (dropInfo == null) {
                            return false;
                        }
                        ArrayList<File> transferredFiles = transferable.getFiles();
                        ArrayList<File> compatibleTransferredFiles = dropInfo.filterCompatibleFiles(transferredFiles);
                        return !compatibleTransferredFiles.isEmpty();
                    }
                    return false;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    return false;
                }
            }
        }
        this.clearHighlights();
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (support.getComponent() instanceof JTable) {
            try {
                int reply;
                JTable table = (JTable)support.getComponent();
                JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
                int index = table.convertRowIndexToModel(dl.getRow());
                int max = table.getModel().getRowCount();
                if (index < 0 || index > max) {
                    return false;
                }
                FilesTransferable transferable = (FilesTransferable)support.getTransferable().getTransferData(FilesTransferable.Files_FLAVOR);
                ArrayList<File> transferredFiles = transferable.getFiles();
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < transferredFiles.size(); ++i) {
                    indices.add(index + i);
                }
                TreeFileChooserTableModelInterface model = (TreeFileChooserTableModelInterface)((Object)table.getModel());
                if (!model.canSetFiles(indices)) {
                    JOptionPane.showMessageDialog(null, "An mzDB file is already linked to this dataset. Operation is cancelled.", "Warning", 2);
                    return false;
                }
                if (model.shouldConfirmCorruptFiles(indices) && (reply = JOptionPane.showConfirmDialog(null, "Previous quantitation has been run with existing mzDB file.\n Are you sure you want to overwrite this link.", "Warning", 0)) == 1) {
                    return false;
                }
                model.setFiles(transferredFiles, index);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (support.getComponent() instanceof DropZoneInterface) {
            try {
                DropZoneInterface dropZone = (DropZoneInterface)((Object)support.getComponent());
                FilesTransferable transferable = (FilesTransferable)support.getTransferable().getTransferData(FilesTransferable.Files_FLAVOR);
                ArrayList<File> transferredFiles = transferable.getFiles();
                ArrayList<File> samples = new ArrayList<File>();
                for (int i = 0; i < transferredFiles.size(); ++i) {
                    File[] listOfFiles;
                    if (transferredFiles.get(i).isFile()) {
                        samples.add(transferredFiles.get(i));
                        continue;
                    }
                    for (File file : listOfFiles = transferredFiles.get(i).listFiles()) {
                        if (!file.isFile()) continue;
                        samples.add(file);
                    }
                }
                dropZone.addSamples(samples);
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
        if (support.getComponent() instanceof TreeFileChooser) {
            try {
                FilesTransferable transferable = (FilesTransferable)support.getTransferable().getTransferData(FilesTransferable.Files_FLAVOR);
                ArrayList<File> transferredFiles = transferable.getFiles();
                JTree.DropLocation treeDropLocation = (JTree.DropLocation)support.getDropLocation();
                TreePath dropPath = treeDropLocation.getPath();
                return this.treeTransfer(transferredFiles, dropPath);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return true;
    }

    public boolean treeTransfer(ArrayList<File> transferredFiles, TreePath dropPath) {
        DropInfo dropInfo = this.checkServer(dropPath);
        if (dropInfo == null) {
            return false;
        }
        ArrayList<File> compatibleTransferredFiles = dropInfo.filterCompatibleFiles(transferredFiles);
        if (compatibleTransferredFiles.isEmpty()) {
            return false;
        }
        String parentLabel = dropInfo.getParentLabel();
        String destination = dropInfo.getDestination();
        MzdbUploadSettings uploadSettings = new MzdbUploadSettings(false, parentLabel, destination);
        HashMap<File, MzdbUploadSettings> uploadSamples = new HashMap<File, MzdbUploadSettings>();
        for (int i = 0; i < transferredFiles.size(); ++i) {
            File[] listOfFiles;
            if (compatibleTransferredFiles.get(i).isFile()) {
                uploadSamples.put(compatibleTransferredFiles.get(i), uploadSettings);
                continue;
            }
            for (File file : listOfFiles = compatibleTransferredFiles.get(i).listFiles()) {
                if (!file.isFile()) continue;
                uploadSamples.put(file, uploadSettings);
            }
        }
        MzdbUploadBatch uploadBatch = new MzdbUploadBatch(uploadSamples, dropPath);
        Thread thread = new Thread(uploadBatch);
        thread.start();
        return true;
    }

    private DropInfo checkServer(TreePath treePath) {
        File f;
        Object extraData;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object data = node.getUserObject();
        if (data instanceof IconData && (extraData = ((IconData)data).getObject()) instanceof TreeFileChooserPanel.FileNode && !(f = ((TreeFileChooserPanel.FileNode)extraData).getFile()).isDirectory()) {
            return this.checkServer(treePath.getParentPath());
        }
        String textTreePath = treePath.toString();
        textTreePath = textTreePath.replaceAll("\\[", "").replaceAll("\\]", "");
        String[] pathNodes = textTreePath.split(",");
        for (int i = 0; i < pathNodes.length; ++i) {
            pathNodes[i] = pathNodes[i].trim();
        }
        DropInfo dropInfo = this.lookForLabels(pathNodes, "mzdb_files");
        if (dropInfo != null) {
            return dropInfo;
        }
        dropInfo = this.lookForLabels(pathNodes, "raw_files");
        if (dropInfo != null) {
            return dropInfo;
        }
        dropInfo = this.lookForLabels(pathNodes, "result_files");
        return dropInfo;
    }

    private DropInfo lookForLabels(String[] pathNodes, String rootInfoType) {
        ArrayList labels = ServerFileSystemView.getServerFileSystemView().getLabels(rootInfoType);
        String parentLabel = null;
        int parentIndex = -1;
        block0: for (int i = 0; i < pathNodes.length; ++i) {
            for (int j = 0; j < labels.size(); ++j) {
                String node = pathNodes[i];
                String label = (String)labels.get(j);
                if (node.compareToIgnoreCase(label) != 0) continue;
                parentLabel = pathNodes[i];
                parentIndex = i;
                continue block0;
            }
        }
        if (parentLabel == null || parentIndex == -1) {
            return null;
        }
        StringBuilder destinationBuilder = new StringBuilder();
        for (int i = parentIndex + 1; i < pathNodes.length; ++i) {
            destinationBuilder.append(File.separator).append(pathNodes[i]);
        }
        destinationBuilder.append(File.separator);
        String destination = destinationBuilder.toString();
        return new DropInfo(parentLabel, parentIndex, destination, rootInfoType);
    }

    private class DropInfo {
        private String m_parentLabel;
        private int m_parentIndex;
        private String m_destination;
        private String m_rootInfoType;

        public DropInfo(String parentLabel, int parentIndex, String destination, String rootInfoType) {
            this.m_parentLabel = parentLabel;
            this.m_parentIndex = parentIndex;
            this.m_destination = destination;
            this.m_rootInfoType = rootInfoType;
        }

        public String getParentLabel() {
            return this.m_parentLabel;
        }

        public int getParentIndex() {
            return this.m_parentIndex;
        }

        public String getDestination() {
            return this.m_destination;
        }

        public ArrayList<File> filterCompatibleFiles(ArrayList<File> files) {
            String allowedExtension = null;
            if (this.m_rootInfoType.equals("mzdb_files")) {
                allowedExtension = ".mzdb";
            } else if (this.m_rootInfoType.equals("raw_files")) {
                allowedExtension = ".raw";
            } else if (this.m_rootInfoType.equals("result_files")) {
                allowedExtension = ".dat";
            }
            ArrayList<File> compatibleFiles = new ArrayList<File>(files.size());
            for (File f : files) {
                if (!f.getAbsolutePath().toLowerCase().endsWith(allowedExtension)) continue;
                compatibleFiles.add(f);
            }
            return compatibleFiles;
        }
    }
}

