/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc;

import fr.proline.studio.gui.ClosableTabPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessEngineInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DataAnalyzerResultsPanel
extends JPanel
implements DataBoxPanelInterface {
    private AbstractDataBox m_dataBox;
    private final JTabbedPane m_tabbedPane = new JTabbedPane();
    private final HashMap<Integer, WindowBox> m_processKeyToWindowBoxMap = new HashMap();

    public DataAnalyzerResultsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabbedPane, "Center");
    }

    public void displayGraphNode(ProcessEngineInfo processEngineInfo) {
        ArrayList<WindowBox> windowBoxList = processEngineInfo.getGraphNode().getDisplayWindowBox(processEngineInfo.getIndex());
        Integer processEngineKey = processEngineInfo.getProcessKey();
        ArrayList<SplittedPanelContainer.PanelLayout> layoutList = processEngineInfo.getLayout();
        for (int i = 0; i < windowBoxList.size(); ++i) {
            WindowBox windowBox = windowBoxList.get(i);
            WindowBox existingWindowBox = this.m_processKeyToWindowBoxMap.get(processEngineKey);
            if (existingWindowBox != null) {
                AbstractDataBox databox = windowBox.getEntryBox();
                SplittedPanelContainer.PanelLayout layout = layoutList.get(i);
                while (databox != null) {
                    existingWindowBox.addDatabox(databox, layout);
                    ArrayList<AbstractDataBox> list = databox.getNextDataBoxArray();
                    if (list != null && !list.isEmpty()) {
                        databox = list.get(0);
                        layout = databox.getLayout();
                        continue;
                    }
                    databox = null;
                }
                continue;
            }
            this.m_processKeyToWindowBoxMap.put(processEngineKey, windowBox);
            String processName = processEngineInfo.getProcessName();
            this.m_tabbedPane.addTab(null, windowBox.getPanel());
            ClosableTabPanel closableTabPanel = new ClosableTabPanel(this.m_tabbedPane, processEngineKey + ": " + processName, processEngineKey.toString());
            this.m_tabbedPane.setTabComponentAt(this.m_tabbedPane.getTabCount() - 1, (Component)closableTabPanel);
            this.m_tabbedPane.setSelectedIndex(this.m_tabbedPane.getTabCount() - 1);
        }
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void setLoading(int id) {
    }

    @Override
    public void setLoading(int id, boolean calculating) {
    }

    @Override
    public void setLoaded(int id) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }
}

