/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc;

import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AdjustPFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.ColumnFilterFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.ComputeFDRFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.DiffAnalysisFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.DiffFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.ExpressionFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.FilterFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.ImportTSVFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.JoinFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.LogFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.MissingValuesImputationFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.NormalizationFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.PValueFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.QuantiFilterFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.SCDiffAnalysisFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.TtdFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphGroup;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphicGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.BoxPlotGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.CalibrationPlotGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.DensityPlotGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.ParallelCoordinatesGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.ScatterOrHistogramGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.VarianceDistPlotGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.VennDiagramGraphic;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UserMacroParser {
    private static UserMacroParser m_singleton = null;
    public GraphPanel m_graphPanel = null;

    public static UserMacroParser getGraphFileManager() {
        if (m_singleton == null) {
            m_singleton = new UserMacroParser();
        }
        return m_singleton;
    }

    private UserMacroParser() {
    }

    public void setGraphPanel(GraphPanel graphPanel) {
        this.m_graphPanel = graphPanel;
    }

    public FunctionGraphNode createFunctionGraphNode(int subtype) {
        AbstractFunction function = null;
        AbstractFunction.FUNCTION_TYPE functionType = AbstractFunction.FUNCTION_TYPE.values()[subtype];
        switch (functionType) {
            case AdjustPFunction: {
                function = new AdjustPFunction(this.m_graphPanel);
                break;
            }
            case ColumnFilterFunction: {
                function = new ColumnFilterFunction(this.m_graphPanel);
                break;
            }
            case ComputeFDRFunction: {
                function = new ComputeFDRFunction(this.m_graphPanel);
                break;
            }
            case DiffAnalysisFunction: {
                function = new DiffAnalysisFunction(this.m_graphPanel);
                break;
            }
            case DiffFunction: {
                function = new DiffFunction(this.m_graphPanel);
                break;
            }
            case ExpressionFunction: {
                function = new ExpressionFunction(this.m_graphPanel);
                break;
            }
            case FilterFunction: {
                function = new FilterFunction(this.m_graphPanel);
                break;
            }
            case ImportTSVFunction: {
                function = new ImportTSVFunction(this.m_graphPanel);
                break;
            }
            case JoinFunction: {
                function = new JoinFunction(this.m_graphPanel);
                break;
            }
            case Log2Function: {
                function = new LogFunction(this.m_graphPanel, false);
                break;
            }
            case Log10Function: {
                function = new LogFunction(this.m_graphPanel, true);
                break;
            }
            case MissingValuesImputationFunction: {
                function = new MissingValuesImputationFunction(this.m_graphPanel);
                break;
            }
            case NormalizationFunction: {
                function = new NormalizationFunction(this.m_graphPanel);
                break;
            }
            case PValueFunction: {
                function = new PValueFunction(this.m_graphPanel);
                break;
            }
            case QuantiFilterFunction: {
                function = new QuantiFilterFunction(this.m_graphPanel);
                break;
            }
            case SCDiffAnalysisFunction: {
                function = new SCDiffAnalysisFunction(this.m_graphPanel);
                break;
            }
            case TtdFunction: {
                function = new TtdFunction(this.m_graphPanel);
            }
        }
        return new FunctionGraphNode(function, this.m_graphPanel);
    }

    public GraphicGraphNode createGraphicGraphNode(int subtype) {
        AbstractGraphic graphic = null;
        AbstractGraphic.GRAPHIC_TYPE functionType = AbstractGraphic.GRAPHIC_TYPE.values()[subtype];
        switch (functionType) {
            case CalibrationPlotGraphic: {
                graphic = new CalibrationPlotGraphic(this.m_graphPanel);
                break;
            }
            case ParallelCoordinatesGraphic: {
                graphic = new ParallelCoordinatesGraphic(this.m_graphPanel);
                break;
            }
            case ScatterGraphic: {
                graphic = new ScatterOrHistogramGraphic(this.m_graphPanel, PlotType.SCATTER_PLOT);
                break;
            }
            case HistogramGraphic: {
                graphic = new ScatterOrHistogramGraphic(this.m_graphPanel, PlotType.HISTOGRAM_PLOT);
                break;
            }
            case VennDiagramGraphic: {
                graphic = new VennDiagramGraphic(this.m_graphPanel);
                break;
            }
            case BoxPlotGraphic: {
                graphic = new BoxPlotGraphic(this.m_graphPanel);
                break;
            }
            case DensityPlotGraphic: {
                graphic = new DensityPlotGraphic(this.m_graphPanel);
                break;
            }
            case VarianceDistPlotGraphic: {
                graphic = new VarianceDistPlotGraphic(this.m_graphPanel);
            }
        }
        return new GraphicGraphNode(this.m_graphPanel, graphic);
    }

    public void parseFile(String xml, GraphPanel graphPanel) throws Exception {
        Point position = graphPanel.getNextGraphNodePosition(null);
        this.parseFile(xml, graphPanel, position.x, position.y);
    }

    public void parseFile(String xml, GraphPanel graphPanel, int x, int y) throws Exception {
        if ((double)x < 84.0) {
            x = 84;
        }
        if ((double)y < 84.0) {
            y = 84;
        }
        this.m_graphPanel = graphPanel;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        GraphXMLHandler handler = new GraphXMLHandler(this.m_graphPanel, x, y);
        parser.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))), (DefaultHandler)handler);
        handler.doConnections();
        this.m_graphPanel.repaint();
        this.m_graphPanel = null;
    }

    public class GraphXMLHandler
    extends DefaultHandler {
        private GraphPanel m_graphPanel;
        private HashMap<Integer, GraphNode> m_graphNodeMap = new HashMap();
        private ArrayList<int[]> m_connections = new ArrayList();
        private Point m_firstPosition = null;
        private Point m_deltaPosition = null;
        private GraphGroup m_group = null;

        public GraphXMLHandler(GraphPanel p, int x, int y) {
            this.m_graphPanel = p;
            this.m_firstPosition = new Point(x, y);
        }

        @Override
        public void startElement(String namespaceURI, String lname, String qname, Attributes attrs) throws SAXException {
            int nbAttributes = attrs.getLength();
            if (qname.compareTo("dataanalyzer") == 0) {
                for (int i = 0; i < nbAttributes; ++i) {
                    String attributeName = attrs.getQName(i);
                    String attributevalue = attrs.getValue(i);
                    if (attributeName.compareTo("name") != 0) continue;
                    this.m_group = new GraphGroup(attributevalue);
                }
            } else if (qname.compareTo("graphnode") == 0) {
                int id = -1;
                int x = 0;
                int y = 0;
                String type = null;
                int subtype = -1;
                for (int i = 0; i < nbAttributes; ++i) {
                    String attributeName = attrs.getQName(i);
                    String attributevalue = attrs.getValue(i);
                    if (attributeName.compareTo("id") == 0) {
                        id = Integer.parseInt(attributevalue);
                        continue;
                    }
                    if (attributeName.compareTo("x") == 0) {
                        x = Integer.parseInt(attributevalue);
                        continue;
                    }
                    if (attributeName.compareTo("y") == 0) {
                        y = Integer.parseInt(attributevalue);
                        continue;
                    }
                    if (attributeName.compareTo("type") == 0) {
                        type = attributevalue;
                        continue;
                    }
                    if (attributeName.compareTo("subtype") != 0) continue;
                    subtype = Integer.parseInt(attributevalue);
                }
                if (this.m_firstPosition != null) {
                    this.m_deltaPosition = new Point(x - this.m_firstPosition.x, y - this.m_firstPosition.y);
                    x = this.m_firstPosition.x;
                    y = this.m_firstPosition.y;
                    this.m_firstPosition = null;
                } else {
                    x -= this.m_deltaPosition.x;
                    y -= this.m_deltaPosition.y;
                }
                if (type.compareTo("Function") == 0) {
                    FunctionGraphNode graphNode = UserMacroParser.this.createFunctionGraphNode(subtype);
                    this.m_graphPanel.addGraphNode(graphNode, x, y);
                    if (this.m_group != null) {
                        this.m_group.addObject(graphNode);
                    }
                    this.m_graphNodeMap.put(id, graphNode);
                } else if (type.compareTo("Graphic") == 0) {
                    GraphicGraphNode graphNode = UserMacroParser.this.createGraphicGraphNode(subtype);
                    this.m_graphPanel.addGraphNode(graphNode, x, y);
                    if (this.m_group != null) {
                        this.m_group.addObject(graphNode);
                    }
                    this.m_graphNodeMap.put(id, graphNode);
                }
            } else if (qname.compareTo("connector") == 0) {
                int id1 = -1;
                int id2 = -1;
                int index = -1;
                for (int i = 0; i < nbAttributes; ++i) {
                    String attributeName = attrs.getQName(i);
                    String attributevalue = attrs.getValue(i);
                    if (attributeName.compareTo("id1") == 0) {
                        id1 = Integer.parseInt(attributevalue);
                        continue;
                    }
                    if (attributeName.compareTo("id2") == 0) {
                        id2 = Integer.parseInt(attributevalue);
                        continue;
                    }
                    if (attributeName.compareTo("index") != 0) continue;
                    index = Integer.parseInt(attributevalue);
                }
                if (id1 != -1 && id2 != -1 && index != -1) {
                    int[] connection = new int[]{id1, id2, index};
                    this.m_connections.add(connection);
                }
            }
        }

        public void doConnections() {
            for (int[] connection : this.m_connections) {
                int id1 = connection[0];
                int id2 = connection[1];
                int outConnectorIndex = connection[2];
                GraphNode nodeOut = this.m_graphNodeMap.get(id1);
                GraphNode nodeIn = this.m_graphNodeMap.get(id2);
                if (nodeOut == null || nodeIn == null) continue;
                nodeOut.connectTo(nodeIn, outConnectorIndex);
                if (nodeIn.getFirstFreeConnector() != null || !nodeIn.canAddConnector()) continue;
                nodeIn.addFreeConnector();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] data, int start, int end) {
        }
    }
}

