/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.AdvancedSelectionPanel;
import fr.proline.studio.parameter.MultiObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.model.FilterColumnTableModel;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import java.util.ArrayList;

public class ColumnFilterFunction
extends AbstractFunction {
    private static final String COLUMNS_VISIBILITY_KEY = "COLUMNS_VISIBILITY_KEY";
    private MultiObjectParameter<ColumnIdentifier> m_columnsVisibilityParameter = null;

    public ColumnFilterFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.ColumnFilterFunction);
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_columnsVisibilityParameter = null;
    }

    @Override
    public String getName(int index) {
        return "Columns Filter";
    }

    @Override
    public int getNumberOfInParameters() {
        return 1;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 1;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameters == null) {
            return false;
        }
        return this.m_columnsVisibilityParameter != null;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        ColumnFilterFunction clone = new ColumnFilterFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public void process(GraphConnector[] graphObjects, FunctionGraphNode functionGraphNode, ProcessCallbackInterface callback) {
        this.setInError(false, null);
        if (this.m_globalTableModelInterface != null) {
            callback.finished(functionGraphNode);
            return;
        }
        if (this.m_parameters == null) {
            callback.finished(functionGraphNode);
            return;
        }
        this.m_columnsVisibilityParameter.getAssociatedValues(true);
        ArrayList colList = (ArrayList)this.m_columnsVisibilityParameter.getAssociatedValues(true);
        if (colList == null) {
            callback.finished(functionGraphNode);
            return;
        }
        int size = colList.size();
        int[] colListArray = new int[size];
        for (int i = 0; i < size; ++i) {
            colListArray[i] = (Integer)colList.get(i);
        }
        this.setCalculating(true);
        try {
            this.addModel((GlobalTableModelInterface)new FilterColumnTableModel(graphObjects[0].getGlobalTableModelInterface(), colListArray));
            this.setCalculating(false);
            callback.finished(functionGraphNode);
        }
        catch (Exception e) {
            this.setInError(new CalcError((Throwable)e, null, -1));
            this.setCalculating(false);
            callback.finished(functionGraphNode);
        }
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        ParameterList parameterTableList = new ParameterList("Table Parameters");
        GlobalTableModelInterface model = graphObjects[0].getGlobalTableModelInterface();
        int colCount = model.getColumnCount();
        Object[] columnNamesArray = new ColumnIdentifier[colCount];
        Object[] columnNamesIndexArray = new Integer[colCount];
        boolean[] selection = new boolean[colCount];
        for (int i = 0; i < colCount; ++i) {
            String columnFullName = model.getColumnName(i);
            columnNamesArray[i] = new ColumnIdentifier(columnFullName.replaceAll("<br/>", " "));
            columnNamesIndexArray[i] = i;
            selection[i] = true;
        }
        this.m_columnsVisibilityParameter = new MultiObjectParameter(COLUMNS_VISIBILITY_KEY, "Columns Visibility", "Visible Columns", "Hidden Columns", AdvancedSelectionPanel.class, columnNamesArray, columnNamesIndexArray, selection, null);
        parameterTableList.add(this.m_columnsVisibilityParameter);
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = parameterTableList;
        parameterTableList.getPanel();
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }

    public class ColumnIdentifier {
        private String m_name;

        public ColumnIdentifier(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }

    public class ColumnGroup
    implements Comparable<ColumnGroup> {
        public String m_groupName;
        public boolean m_selected;

        public ColumnGroup(String groupName, boolean selected) {
            this.m_groupName = groupName;
            this.m_selected = selected;
        }

        @Override
        public int compareTo(ColumnGroup o) {
            return this.m_groupName.compareTo(o.m_groupName);
        }
    }
}

