/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.WindowManager;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterDialog;
import fr.proline.studio.filter.FilterMirroredTableModel;
import fr.proline.studio.filter.FilterTableModel;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import java.awt.Window;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JPanel;

public class FilterFunction
extends AbstractFunction {
    private Filter[] m_filters = null;
    private boolean m_settingsDone = false;
    private boolean m_calculationDone = false;
    public static final int OUT_DATA_FILTER = 0;
    public static final int OUT_DATA_REVERSE_FILTER = 1;
    public static final int OUT_VALUES_NUMBER = 2;

    public FilterFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.FilterFunction);
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_filters = null;
        this.m_settingsDone = false;
        this.m_calculationDone = false;
    }

    @Override
    public String getName(int index) {
        if (index >= 0) {
            return "Rows Filter / " + this.getOutTooltip(index);
        }
        return "Rows Filter";
    }

    @Override
    public int getNumberOfInParameters() {
        return 1;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 2;
    }

    @Override
    public String getOutTooltip(int index) {
        switch (index) {
            case 0: {
                return "Values Kept";
            }
            case 1: {
                return "Values Filtered";
            }
        }
        return null;
    }

    @Override
    public boolean settingsDone() {
        return this.m_settingsDone;
    }

    @Override
    public boolean calculationDone() {
        return this.m_calculationDone;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        FilterFunction clone = new FilterFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(GraphConnector[] graphObjects, FunctionGraphNode functionGraphNode, ProcessCallbackInterface callback) {
        if (this.m_calculationDone) {
            callback.finished(functionGraphNode);
            return;
        }
        try {
            this.setCalculating(true);
            this.setInError(false, null);
            ((FilterTableModelInterface)this.m_globalTableModelInterface.get(0)).filter();
            ((FilterTableModelInterface)this.m_globalTableModelInterface.get(1)).filter();
            this.setCalculating(false);
        }
        finally {
            this.m_calculationDone = true;
            callback.finished(functionGraphNode);
        }
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        FilterTableModel filterTableModel = new FilterTableModel(graphObjects[0].getGlobalTableModelInterface());
        this.addModel((GlobalTableModelInterface)filterTableModel);
        this.addModel((GlobalTableModelInterface)new FilterMirroredTableModel(filterTableModel));
        LinkedHashMap filtersMap = ((FilterTableModelInterface)this.m_globalTableModelInterface.get(0)).getFilters();
        this.m_filters = new Filter[filtersMap.size()];
        int index = 0;
        for (Map.Entry entry : filtersMap.entrySet()) {
            this.m_filters[index++] = (Filter)entry.getValue();
        }
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean settings(GraphConnector[] graphObjects, GraphNode node) {
        if (this.m_filters == null) {
            this.generateDefaultParameters(graphObjects);
        }
        FilterDialog dialog = FilterDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setImageInfo((JPanel)this.m_panel, node.getX() - 90, node.getY() - 50, node.getXEnd() - node.getX() + 180, node.getYEnd() - node.getY() + 100);
        dialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
        dialog.setFilters(this.m_filters);
        this.m_settingsBeingDone = true;
        try {
            dialog.setVisible(true);
            if (dialog.getButtonClicked() == 0) {
                this.userParametersChanged();
                this.m_settingsDone = true;
                ((FilterTableModel)this.m_globalTableModelInterface.get(0)).fireTableDataChanged();
                ((FilterTableModel)this.m_globalTableModelInterface.get(1)).fireTableDataChanged();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_settingsBeingDone = false;
        }
    }

    @Override
    public void userParametersChanged() {
        this.m_calculationDone = false;
    }
}

