/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.extendedtablemodel.ImportedDataTableModel;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.LongFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.DisplayStubParameter;
import fr.proline.studio.parameter.FileParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ImportTSVFunction
extends AbstractFunction {
    private static final String KEY_FILE_PARAMETER = "FILE_KEY";
    private static final String SEPARATOR_PARAMETER = "SEPARATOR_KEY";
    private ParameterList m_parameterList;
    private FileParameter m_fileParameter;
    private StringParameter m_separatorParameter;
    private DisplayStubParameter m_displayTableParameter;
    private ImportedDataTableModel m_displayModel = new ImportedDataTableModel();
    private String m_modelName = null;
    private HashMap<String, String[]> m_prioritySeparatorMap = new HashMap();
    private static final Color FRAME_COLOR = new Color(51, 128, 200);

    public ImportTSVFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.ImportTSVFunction);
    }

    @Override
    public Color getFrameColor() {
        return FRAME_COLOR;
    }

    @Override
    public String getDataName() {
        if (this.m_fileParameter != null) {
            String path = this.m_fileParameter.getStringValue();
            File f = new File(path);
            return f.getName();
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE_IMPORT);
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_parameterList = null;
        this.m_fileParameter = null;
    }

    @Override
    public String getName(int index) {
        return "CSV/TSV Import";
    }

    @Override
    public int getNumberOfInParameters() {
        return 0;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 1;
    }

    @Override
    public boolean settingsDone() {
        return this.m_fileParameter != null;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        ImportTSVFunction clone = new ImportTSVFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(GraphConnector[] graphObjects, FunctionGraphNode functionGraphNode, ProcessCallbackInterface callback) {
        try {
            if (this.m_globalTableModelInterface != null) {
                return;
            }
            this.setCalculating(true);
            this.setInError(false, null);
            String filePath = ((String)this.m_fileParameter.getObjectValue()).trim();
            char separator = this.getSeparator();
            ImportedDataTableModel loadedModel = new ImportedDataTableModel();
            Exception e = ImportedDataTableModel.loadFile((ImportedDataTableModel)loadedModel, (String)filePath, (char)separator, (boolean)true, (boolean)false);
            if (e != null) {
                this.setInError(new CalcError((Throwable)e, null, -1));
            } else {
                this.addModel((GlobalTableModelInterface)loadedModel);
            }
            this.setCalculating(false);
        }
        finally {
            callback.finished(functionGraphNode);
        }
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(this.m_fileParameter.getStringValue(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        String[] separatorsCSV = new String[]{",", ";", "\\t", " "};
        this.m_prioritySeparatorMap.put("csv", separatorsCSV);
        String[] separatorsTSV = new String[]{"\\t", ",", ";", " "};
        this.m_prioritySeparatorMap.put("tsv", separatorsTSV);
        String[] fileFilterNames = new String[]{"TSV File", "CSV File"};
        String[] fileFilterExtensions = new String[]{"tsv", "csv"};
        this.m_fileParameter = new FileParameter(null, KEY_FILE_PARAMETER, "CSV/TSV File", JTextField.class, "", fileFilterNames, fileFilterExtensions);
        String[] possibilitiesName = new String[]{"Tab", "Comma", "Semicolon", "Space"};
        String[] possibilities = new String[]{"\\t", ",", ";", " "};
        this.m_separatorParameter = new StringParameter(SEPARATOR_PARAMETER, "Separator", ";", Integer.valueOf(1), Integer.valueOf(2), possibilitiesName, possibilities);
        this.m_separatorParameter.forceShowLabel(AbstractParameter.LabelVisibility.AS_BORDER_TITLE);
        PreviewTable previewTable = new PreviewTable();
        previewTable.setModel((TableModel)this.m_displayModel);
        JScrollPane scrollPane = new JScrollPane(){
            private final Dimension preferredSize = new Dimension(360, 140);

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        scrollPane.setViewportView((Component)((Object)previewTable));
        previewTable.setFillsViewportHeight(true);
        this.m_displayTableParameter = new DisplayStubParameter("Preview", (JComponent)scrollPane);
        this.m_parameterList = new ParameterList("ImportTSV");
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = this.m_parameterList;
        this.m_parameterList.add((Object)this.m_fileParameter);
        this.m_parameterList.add((Object)this.m_separatorParameter);
        this.m_parameterList.add((Object)this.m_displayTableParameter);
        AbstractLinkedParameters fileLinkedParameter = new AbstractLinkedParameters(this.m_parameterList){

            public void valueChanged(String value, Object associatedValue) {
                String filePath = ImportTSVFunction.this.m_fileParameter.getStringValue();
                String[] separators = (String[])ImportTSVFunction.this.m_prioritySeparatorMap.get("csv");
                if (filePath.endsWith("tsv")) {
                    separators = (String[])ImportTSVFunction.this.m_prioritySeparatorMap.get("tsv");
                }
                boolean found = false;
                for (int i = 0; i < separators.length; ++i) {
                    Exception e = ImportedDataTableModel.loadFile((ImportedDataTableModel)ImportTSVFunction.this.m_displayModel, (String)ImportTSVFunction.this.m_fileParameter.getStringValue(), (char)ImportTSVFunction.this.separatorToChar(separators[i]), (boolean)true, (boolean)true);
                    if (e != null || ImportTSVFunction.this.m_displayModel.getColumnCount() <= 1) continue;
                    ImportTSVFunction.this.m_separatorParameter.setValue(separators[i]);
                    found = true;
                    break;
                }
                if (!found) {
                    ImportedDataTableModel.loadFile((ImportedDataTableModel)ImportTSVFunction.this.m_displayModel, (String)ImportTSVFunction.this.m_fileParameter.getStringValue(), (char)ImportTSVFunction.this.separatorToChar(separators[0]), (boolean)true, (boolean)true);
                    ImportTSVFunction.this.m_separatorParameter.setValue(separators[0]);
                }
            }
        };
        AbstractLinkedParameters separatorLinkedParameter = new AbstractLinkedParameters(this.m_parameterList){

            public void valueChanged(String value, Object associatedValue) {
                ImportedDataTableModel.loadFile((ImportedDataTableModel)ImportTSVFunction.this.m_displayModel, (String)ImportTSVFunction.this.m_fileParameter.getStringValue(), (char)ImportTSVFunction.this.getSeparator(), (boolean)true, (boolean)true);
            }
        };
        this.m_parameterList.getPanel();
        this.m_fileParameter.addLinkedParameters(fileLinkedParameter);
        this.m_separatorParameter.addLinkedParameters(separatorLinkedParameter);
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        ParameterError error = this.m_fileParameter.checkParameter();
        return error;
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }

    private char getSeparator() {
        String separatorString = this.m_separatorParameter.getStringValue();
        int separator = separatorString.length() == 1 ? separatorString.charAt(0) : (separatorString.compareTo("\\t") == 0 ? 9 : 9);
        return (char)separator;
    }

    private char separatorToChar(String separatorString) {
        char separator = separatorString.compareTo("\\t") == 0 ? (char)'\t' : (char)separatorString.charAt(0);
        return separator;
    }

    public class PreviewTable
    extends DecoratedTable {
        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }

    public class LoadedDataModel
    extends DecoratedTableModel
    implements GlobalTableModelInterface {
        private String[] m_columnNames = new String[]{"No Data"};
        private Class[] m_columTypes = new Class[]{String.class};
        private Object[][] m_data = null;

        public LoadedDataModel() {
            this.m_data = new Object[1][1];
            this.m_data[0][0] = "";
        }

        public LoadedDataModel(String[] columnNames, Class[] columTypes, Object[][] data) {
            this.setData(columnNames, columTypes, data);
        }

        public final void setData(String[] columnNames, Class[] columTypes, Object[][] data) {
            this.m_columnNames = columnNames;
            this.m_columTypes = columTypes;
            this.m_data = data;
            this.fireTableStructureChanged();
        }

        public int getRowCount() {
            if (this.m_data == null) {
                return 0;
            }
            return this.m_data.length;
        }

        public int getColumnCount() {
            if (this.m_columnNames == null) {
                return 0;
            }
            return this.m_columnNames.length;
        }

        public Class getColumnClass(int column) {
            return this.m_columTypes[column];
        }

        public String getColumnName(int column) {
            return this.m_columnNames[column];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.m_data[rowIndex][columnIndex];
        }

        public String getToolTipForHeader(int col) {
            return null;
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            if (this.m_columTypes[col] == String.class) {
                return new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
            }
            if (this.m_columTypes[col] == Long.class) {
                return TableDefaultRendererManager.getDefaultRenderer(Long.class);
            }
            if (this.m_columTypes[col] == Double.class) {
                return new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4, true, true);
            }
            return null;
        }

        public GlobalTableModelInterface getFrozzenModel() {
            return this;
        }

        public Long getTaskId() {
            return -1L;
        }

        public LazyData getLazyData(int row, int col) {
            return null;
        }

        public void givePriorityTo(Long taskId, int row, int col) {
        }

        public void sortingChanged(int col) {
        }

        public int getSubTaskId(int col) {
            return -1;
        }

        public String getDataColumnIdentifier(int columnIndex) {
            return this.m_columnNames[columnIndex];
        }

        public Class getDataColumnClass(int columnIndex) {
            return this.m_columTypes[columnIndex];
        }

        public Object getDataValueAt(int rowIndex, int columnIndex) {
            return this.getValueAt(rowIndex, columnIndex);
        }

        public int[] getKeysColumn() {
            return null;
        }

        public void setName(String name) {
            ImportTSVFunction.this.m_modelName = name;
        }

        public String getName() {
            return ImportTSVFunction.this.m_modelName;
        }

        public Map<String, Object> getExternalData() {
            return null;
        }

        public PlotInformation getPlotInformation() {
            return null;
        }

        public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
            int nbCols = this.getColumnCount();
            for (int i = 0; i < nbCols; ++i) {
                Class c = this.getColumnClass(i);
                if (c.equals(Double.class)) {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                    continue;
                }
                if (c.equals(Long.class)) {
                    filtersMap.put(i, (Filter)new LongFilter(this.getColumnName(i), null, i));
                    continue;
                }
                if (!c.equals(String.class)) continue;
                filtersMap.put(i, (Filter)new StringDiffFilter(this.getColumnName(i), null, i));
            }
        }

        public boolean isLoaded() {
            return true;
        }

        public int getLoadingPercentage() {
            return 100;
        }

        public PlotType getBestPlotType() {
            return PlotType.SCATTER_PLOT;
        }

        public int[] getBestColIndex(PlotType plotType) {
            return null;
        }

        public String getExportRowCell(int row, int col) {
            return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return null;
        }

        public String getExportColumnName(int col) {
            return this.m_columnNames[col];
        }

        public int getInfoColumn() {
            return 0;
        }

        public ArrayList<ExtraDataType> getExtraDataTypes() {
            return null;
        }

        public Object getValue(Class c) {
            return this.getSingleValue(c);
        }

        public Object getRowValue(Class c, int row) {
            return null;
        }

        public Object getColValue(Class c, int col) {
            return null;
        }
    }
}

