/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graph;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.id.ProjectId;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class DataGraphNode
extends GraphNode {
    private static final Color FRAME_COLOR = new Color(51, 128, 200);
    private TableInfo m_tableInfo = null;

    public DataGraphNode(TableInfo tableInfo, GraphPanel panel) {
        super(panel);
        this.m_tableInfo = tableInfo;
        this.m_outConnector = new LinkedList();
        this.m_outConnector.add(new GraphConnector(this, true, 0, panel));
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void propagateSourceChanged() {
    }

    @Override
    public boolean isConnected(boolean recursive) {
        return true;
    }

    @Override
    public boolean canSetSettings() {
        return false;
    }

    @Override
    public boolean settingsDone() {
        return true;
    }

    @Override
    public boolean calculationDone() {
        return true;
    }

    @Override
    public String getFullName() {
        return this.m_tableInfo.getFullName();
    }

    @Override
    public String getDataName() {
        return this.m_tableInfo.getDataName();
    }

    @Override
    public String getTypeName() {
        return this.m_tableInfo.getTypeName();
    }

    @Override
    public Color getFrameColor() {
        return FRAME_COLOR;
    }

    @Override
    public ImageIcon getIcon() {
        return this.m_tableInfo.getIcon();
    }

    @Override
    public ImageIcon getStatusIcon() {
        return null;
    }

    @Override
    public ImageIcon getDisplayIcon() {
        return IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE);
    }

    @Override
    public GraphNode.NodeAction possibleAction() {
        return GraphNode.NodeAction.RESULT_ACTION;
    }

    @Override
    public void doAction(int x, int y) {
        if (this.m_graphNodeAction.isHighlighted()) {
            this.m_graphNodeAction.setHighlighted(false);
            this.m_graphNodeAction.setHighlighted(false);
            this.askDisplay(0);
        } else if (this.m_menuAction.isHighlighted()) {
            this.m_menuAction.setHighlighted(false);
            JPopupMenu popup = this.createPopup(this.m_graphPanel);
            if (popup != null) {
                popup.show(this.m_graphPanel, x, y);
            }
        }
    }

    @Override
    public void askDisplay(int index) {
        WindowBox windowBox = WindowBoxFactory.getGenericWindowBox(this.m_tableInfo.getDataName(), this.m_tableInfo.getTypeName(), IconManager.IconType.CHALKBOARD, false);
        GlobalTableModelInterface model = this.m_tableInfo.getModel();
        ProjectId projectId = (ProjectId)model.getSingleValue(ProjectId.class);
        long id = projectId != null ? projectId.getId() : -1L;
        windowBox.setEntryData(id, model);
        DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(windowBox);
        WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(int index) {
        WindowBox windowBox = WindowBoxFactory.getGenericWindowBox(this.m_tableInfo.getDataName(), this.m_tableInfo.getTypeName(), IconManager.IconType.CHALKBOARD, false);
        GlobalTableModelInterface model = this.m_tableInfo.getModel();
        ProjectId projectId = (ProjectId)model.getSingleValue(ProjectId.class);
        long id = projectId != null ? projectId.getId() : -1L;
        windowBox.setEntryData(id, model);
        ArrayList<WindowBox> windowBoxList = new ArrayList<WindowBox>(1);
        windowBoxList.add(windowBox);
        return windowBoxList;
    }

    @Override
    public boolean settings() {
        return true;
    }

    @Override
    public void process(ProcessCallbackInterface callback) {
        callback.finished(this);
    }

    @Override
    public GlobalTableModelInterface getGlobalTableModelInterface(int index) {
        return this.m_tableInfo.getModel();
    }

    @Override
    public boolean canBeProcessed() {
        return true;
    }

    @Override
    public ArrayList<SplittedPanelContainer.PanelLayout> getAutoDisplayLayoutDuringProcess() {
        return null;
    }

    @Override
    public String getTooltip(int x, int y) {
        return null;
    }

    @Override
    public String getOutTooltip(int index) {
        return null;
    }

    @Override
    public void saveGraph(StringBuilder sb) {
    }
}

