/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.macros;

import fr.proline.studio.rsmexplorer.gui.calc.DataTree;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractMacro {
    private final ArrayList<DataTree.DataNode> m_macroNodes = new ArrayList();
    private final HashMap<String, DataTree.DataNode> m_macroNodesReferenceMap = new HashMap();
    private final HashMap<DataTree.DataNode, ArrayList<DataTree.DataNode>> m_linksMap = new HashMap();
    private final HashMap<DataTree.DataNode, Integer> m_levelXMap = new HashMap();
    private final HashMap<DataTree.DataNode, Integer> m_levelYMap = new HashMap();

    public abstract String getName();

    private String generateKey(int levelX, int levelY) {
        return levelX + ":" + levelY;
    }

    public void addNode(DataTree.DataNode node, int levelX, int levelY) {
        this.m_macroNodes.add(node);
        this.m_macroNodesReferenceMap.put(this.generateKey(levelX, levelY), node);
        this.m_levelXMap.put(node, levelX);
        this.m_levelYMap.put(node, levelY);
    }

    public final void addLink(int levelX1, int levelY1, int levelX2, int levelY2) {
        String key1 = this.generateKey(levelX1, levelY1);
        String key2 = this.generateKey(levelX2, levelY2);
        DataTree.DataNode node1 = this.m_macroNodesReferenceMap.get(key1);
        DataTree.DataNode node2 = this.m_macroNodesReferenceMap.get(key2);
        ArrayList<DataTree.DataNode> outNodes = this.m_linksMap.get(node1);
        if (outNodes == null) {
            outNodes = new ArrayList();
            this.m_linksMap.put(node1, outNodes);
        }
        outNodes.add(node2);
    }

    public ArrayList<DataTree.DataNode> getNodes() {
        return this.m_macroNodes;
    }

    public Integer getLevelX(DataTree.DataNode node) {
        return this.m_levelXMap.get(node);
    }

    public Integer getLevelY(DataTree.DataNode node) {
        return this.m_levelYMap.get(node);
    }

    public ArrayList<DataTree.DataNode> getLinks(DataTree.DataNode node) {
        return this.m_linksMap.get(node);
    }
}

