/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.dpm.ServerConnectionManager;
import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class ChangePasswordDialog
extends DefaultDialog {
    protected JPasswordField m_oldPasswordField;
    protected JPasswordField m_passwordField;
    protected JPasswordField m_passwordRepeatField;

    public ChangePasswordDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Change Password");
        this.setButtonVisible(5, false);
        JPanel internalPanel = this.createInternalPanel();
        this.setInternalComponent(internalPanel);
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JLabel oldPasswordLabel = new JLabel("Old password :");
        this.m_oldPasswordField = new JPasswordField(20);
        JLabel passwordLabel = new JLabel("New password :");
        this.m_passwordField = new JPasswordField(20);
        JLabel passwordRepeatLabel = new JLabel("Confirm new password :");
        this.m_passwordRepeatField = new JPasswordField(20);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        internalPanel.add((Component)oldPasswordLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        internalPanel.add((Component)this.m_oldPasswordField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        internalPanel.add((Component)passwordLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        internalPanel.add((Component)this.m_passwordField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        internalPanel.add((Component)passwordRepeatLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        internalPanel.add((Component)this.m_passwordRepeatField, c);
        return internalPanel;
    }

    public String getUser() {
        return ServerConnectionManager.getServerConnectionManager().getProjectUser();
    }

    public String getPassword() {
        return new String(this.m_passwordField.getPassword());
    }

    public String getOldPassword() {
        return new String(this.m_oldPasswordField.getPassword());
    }

    protected boolean okCalled() {
        char[] oldPswd = this.m_oldPasswordField.getPassword();
        char[] psw1 = this.m_passwordField.getPassword();
        char[] psw2 = this.m_passwordRepeatField.getPassword();
        if (psw1.length == 0) {
            this.setStatus(true, "Password must be specified");
            this.highlight(this.m_passwordField);
            return false;
        }
        if (psw2.length == 0) {
            this.setStatus(true, "Repeat password ");
            this.highlight(this.m_passwordRepeatField);
            return false;
        }
        if (oldPswd.length == 0) {
            this.setStatus(true, "Old password must be specified");
            this.highlight(this.m_oldPasswordField);
            return false;
        }
        if (psw1.length != psw2.length) {
            this.setStatus(true, "Password mismatch");
            this.highlight(this.m_passwordField);
            return false;
        }
        boolean equalsPsw = true;
        for (int i = 0; i < psw1.length; ++i) {
            if (psw1[i] == psw2[i]) continue;
            equalsPsw = false;
            break;
        }
        if (!equalsPsw) {
            this.setStatus(true, "Password mismatch");
            this.highlight(this.m_passwordField);
            return false;
        }
        return true;
    }
}

