/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.dam.data.SelectLevelEnum;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.rsmexplorer.gui.SelectLevelRadioButtonGroup;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ModifyClusterStatusPanel
extends JPanel {
    protected static final String CMD_VALIDATED = "Validated";
    protected static final String CMD_INVALIDATED = "Invalidated";
    private SelectLevelRadioButtonGroup m_validRButton;
    private SelectLevelRadioButtonGroup m_invalidRButton;
    private ButtonGroup m_statusButtonGroup;
    private JFormattedTextField m_statusConfidenceLevelTF;
    private JTextArea m_statusConfidenceInfoTA;
    private PTMCluster m_editedCluster;

    public ModifyClusterStatusPanel() {
        this.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        this.add((Component)internalPanel, "Center");
    }

    private JPanel createInternalPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        JLabel statusTextLabel = new JLabel("Modification Cluster Status:");
        p.add((Component)statusTextLabel, c);
        ++c.gridx;
        this.m_validRButton = new SelectLevelRadioButtonGroup(p, c, CMD_VALIDATED, IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED));
        this.m_validRButton.getRadioButton().setActionCommand(CMD_VALIDATED);
        ++c.gridy;
        c.gridx = 1;
        this.m_invalidRButton = new SelectLevelRadioButtonGroup(p, c, CMD_INVALIDATED, IconManager.getIcon((IconManager.IconType)IconManager.IconType.INVALIDATED));
        this.m_invalidRButton.getRadioButton().setActionCommand(CMD_INVALIDATED);
        this.m_statusButtonGroup = new ButtonGroup();
        this.m_statusButtonGroup.add(this.m_validRButton.getRadioButton());
        this.m_statusButtonGroup.add(this.m_invalidRButton.getRadioButton());
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        JLabel statConfidenceLabel = new JLabel("Status Confidence level:");
        p.add((Component)statConfidenceLabel, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.m_statusConfidenceLevelTF = new JFormattedTextField();
        this.m_statusConfidenceLevelTF.setFormatterFactory(new DefaultFormatterFactory(new NumberAndNullFormatter()));
        this.m_statusConfidenceLevelTF.setColumns(10);
        p.add((Component)this.m_statusConfidenceLevelTF, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        JLabel statConfidenceInfo = new JLabel("Status Confidence description:");
        p.add((Component)statConfidenceInfo, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane();
        this.m_statusConfidenceInfoTA = new JTextArea(5, 20);
        scrollPane.setViewportView(this.m_statusConfidenceInfoTA);
        p.add((Component)scrollPane, c);
        return p;
    }

    public boolean applyModifiedStatus() {
        Integer confidenceNotation;
        String command = this.m_statusButtonGroup.getSelection().getActionCommand();
        boolean changedDone = false;
        if (command.equals(CMD_VALIDATED) && this.m_editedCluster.getSelectionLevel() < 2) {
            this.m_editedCluster.setSelectionLevel(3);
            changedDone = true;
        }
        if (command.equals(CMD_INVALIDATED) && this.m_editedCluster.getSelectionLevel() >= 2) {
            this.m_editedCluster.setSelectionLevel(0);
            changedDone = true;
        }
        String confidenceDesc = this.m_statusConfidenceInfoTA.getText();
        Integer n = confidenceNotation = this.m_statusConfidenceLevelTF.getValue() == null || this.m_statusConfidenceLevelTF.getValue().toString().isEmpty() ? null : new Integer(this.m_statusConfidenceLevelTF.getValue().toString());
        if (confidenceDesc != null && !confidenceDesc.equals(this.m_editedCluster.getSelectionInfo()) || confidenceDesc == null && this.m_editedCluster.getSelectionInfo() != null) {
            this.m_editedCluster.setSelectionInfo(confidenceDesc);
            changedDone = true;
        }
        if (confidenceNotation != null && !confidenceNotation.equals(this.m_editedCluster.getSelectionNotation()) || confidenceNotation == null && this.m_editedCluster.getSelectionNotation() != null) {
            this.m_editedCluster.setSelectionNotation(confidenceNotation);
            changedDone = true;
        }
        return changedDone;
    }

    public void setData(PTMCluster clusterToModify) {
        this.m_editedCluster = clusterToModify;
        int clusterSelectionLevel = clusterToModify.getSelectionLevel();
        Integer clusterNotation = clusterToModify.getSelectionNotation();
        String clusterDescription = clusterToModify.getSelectionInfo();
        SelectLevelEnum val = SelectLevelEnum.valueOf((int)clusterSelectionLevel);
        switch (val) {
            case RESET_AUTO: 
            case UNKNOWN: {
                break;
            }
            case DESELECTED_AUTO: 
            case DESELECTED_MANUAL: {
                this.m_invalidRButton.getRadioButton().setSelected(true);
                break;
            }
            case SELECTED_AUTO: 
            case SELECTED_MANUAL: {
                this.m_validRButton.getRadioButton().setSelected(true);
            }
        }
        this.m_statusConfidenceInfoTA.setText(clusterDescription);
        this.m_statusConfidenceLevelTF.setValue(clusterNotation);
    }

    private static class NumberAndNullFormatter
    extends NumberFormatter {
        private NumberAndNullFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            if (text.length() == 0) {
                return null;
            }
            return super.stringToValue(text);
        }
    }
}

