/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.uds.UserAccount;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dpm.ServerConnectionManager;
import fr.proline.studio.gui.ConnectionDialog;
import fr.proline.studio.pattern.DataboxDataAnalyzer;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.MzdbFilesTopPanel;
import fr.proline.studio.rsmexplorer.TaskLogTopPanel;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.TreeUtils;
import fr.proline.studio.rsmexplorer.gui.calc.DataAnalyzerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.HelpDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.SeqDBInfoDialog;
import java.awt.Component;
import java.awt.Window;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ServerConnectionDialog
extends ConnectionDialog {
    private boolean m_changingUser = false;
    private static ServerConnectionDialog m_singletonDialog = null;

    public static ServerConnectionDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new ServerConnectionDialog(parent);
        }
        return m_singletonDialog;
    }

    private ServerConnectionDialog(Window parent) {
        super(parent, "Server Connection", " Server Parameter ", "Server Host :");
        this.setDocumentationSuffix("id.2szc72q");
        this.setButtonVisible(2, true);
        this.initDefaults();
    }

    private void initDefaults() {
        ServerConnectionManager serverConnectionManager = ServerConnectionManager.getServerConnectionManager();
        this.m_serverURLTextField.setText(serverConnectionManager.getServerURL());
        this.m_userTextField.setText(serverConnectionManager.getProjectUser());
        String password = serverConnectionManager.getUserPassword();
        this.m_passwordField.setText(password);
        this.m_rememberPasswordCheckBox.setSelected(!password.isEmpty());
    }

    protected boolean okCalled() {
        if (!this.checkParameters()) {
            return false;
        }
        if (this.m_changingUser) {
            HashSet tcs = WindowManager.getDefault().getMainWindow().getTopPanels();
            for (AbstractTopPanel topComponent : tcs) {
                DataboxDataAnalyzer analyzer;
                DataBoxViewerTopPanel databoxComponent;
                WindowBox winBox;
                if (!(topComponent instanceof DataBoxViewerTopPanel) || topComponent instanceof TaskLogTopPanel) continue;
                if (topComponent instanceof DataBoxViewerTopPanel && (winBox = (databoxComponent = (DataBoxViewerTopPanel)topComponent).getWindowBox()).getEntryBox() instanceof DataboxDataAnalyzer && (analyzer = (DataboxDataAnalyzer)winBox.getEntryBox()).getPanel() instanceof DataAnalyzerPanel) {
                    DataAnalyzerPanel panel = (DataAnalyzerPanel)analyzer.getPanel();
                    panel.clearDataAnalyzerPanel();
                }
                WindowManager.getDefault().getMainWindow().closeWindow(topComponent);
            }
            ProjectExplorerPanel.getProjectExplorerPanel().clearAll();
        }
        this.connect(this.m_changingUser);
        return false;
    }

    protected boolean defaultCalled() {
        this.initDefaults();
        return false;
    }

    public void setChangeUser() {
        this.m_serverURLTextField.setEnabled(false);
        this.m_changingUser = true;
    }

    private void connect(final boolean changingUser) {
        this.setBusy(true);
        String serverURL = this.m_serverURLTextField.getText().trim();
        if (serverURL.startsWith("http") && !serverURL.endsWith("/")) {
            serverURL = serverURL + "/";
            this.m_serverURLTextField.setText(serverURL);
        }
        final String projectUser = this.m_userTextField.getText();
        String password = new String(this.m_passwordField.getPassword());
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                ServerConnectionDialog.this.setBusy(false);
                ServerConnectionManager serverManager = ServerConnectionManager.getServerConnectionManager();
                if (serverManager.isConnectionFailed()) {
                    TaskError connectionError = serverManager.getConnectionError();
                    ServerConnectionDialog.this.setStatus(true, connectionError.getErrorTitle());
                    JOptionPane.showMessageDialog((Component)((Object)m_singletonDialog), connectionError.getErrorTitle(), "Database Connection Error", 0);
                } else if (serverManager.isConnectionDone()) {
                    ServerConnectionDialog.this.m_serverURLTextField.setText(serverManager.getServerURL());
                    ServerConnectionDialog.this.storeDefaults();
                    ServerConnectionDialog.this.setVisible(false);
                    if (HelpDialog.showAtStart()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HelpDialog helpDialog = HelpDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
                                helpDialog.centerToScreen();
                                helpDialog.setVisible(true);
                            }
                        });
                    }
                    if (SeqDBInfoDialog.showAtStart() && !DatabaseDataManager.getDatabaseDataManager().isSeqDatabaseExists()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SeqDBInfoDialog seqDBInfoDialog = new SeqDBInfoDialog((Window)WindowManager.getDefault().getMainWindow());
                                seqDBInfoDialog.centerToScreen();
                                seqDBInfoDialog.setVisible(true);
                            }
                        });
                    }
                    if (changingUser) {
                        DatabaseDataManager udsMgr = DatabaseDataManager.getDatabaseDataManager();
                        for (UserAccount account : udsMgr.getProjectUsersArray()) {
                            if (projectUser.compareToIgnoreCase(account.getLogin()) != 0) continue;
                            udsMgr.setLoggedUser(account);
                            break;
                        }
                        ProjectExplorerPanel.getProjectExplorerPanel().startLoadingProjects();
                    }
                    if (ServerConnectionDialog.this.m_serverURLTextField != null && ServerConnectionDialog.this.m_serverURLTextField.isEnabled() && MzdbFilesTopPanel.getExplorer() != null) {
                        MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().initTree();
                        MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().restoreTree(TreeUtils.TreeType.SERVER);
                    }
                }
            }
        };
        ServerConnectionManager serverManager = ServerConnectionManager.getServerConnectionManager();
        serverManager.tryServerConnection(callback, serverURL, projectUser, password, changingUser);
    }

    private void storeDefaults() {
        ServerConnectionManager serverManager = ServerConnectionManager.getServerConnectionManager();
        serverManager.setServerURL(this.m_serverURLTextField.getText());
        serverManager.setProjectUser(this.m_userTextField.getText());
        if (this.m_rememberPasswordCheckBox.isSelected()) {
            serverManager.setUserPassword(new String(this.m_passwordField.getPassword()));
        } else {
            serverManager.setUserPassword("");
        }
        serverManager.saveParameters();
    }
}

