/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.SystemInfoTask;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.HourglassPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.StringTokenizer;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SystemInfoDialog
extends DefaultDialog {
    private static SystemInfoDialog m_singletonDialog = null;
    private JTextArea m_txtArea;
    private HourglassPanel m_internalPanel = null;

    protected SystemInfoDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("System Information ");
        this.m_internalPanel = this.createPanel();
        this.setButtonVisible(5, false);
        this.setInternalComponent((Component)this.m_internalPanel);
        this.setResizable(true);
    }

    private HourglassPanel createPanel() {
        HourglassPanel internalPanel = new HourglassPanel();
        internalPanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JScrollPane scrollPane = new JScrollPane();
        this.m_txtArea = new JTextArea();
        this.m_txtArea.setEditable(false);
        this.m_txtArea.setRows(20);
        this.m_txtArea.setColumns(50);
        scrollPane.setViewportView(this.m_txtArea);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)scrollPane, (Object)c);
        return internalPanel;
    }

    public static SystemInfoDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new SystemInfoDialog(parent);
        }
        return m_singletonDialog;
    }

    public void updateInfo(String s) {
        this.m_txtArea.setText(s);
        this.m_txtArea.setCaretPosition(0);
        this.revalidate();
        this.repack();
    }

    public void updateInfo() {
        final String[] sysInfoResult = new String[1];
        this.m_internalPanel.setLoading(1);
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                SystemInfoDialog.this.m_internalPanel.setLoaded(1);
                String sysInfoText = sysInfoResult[0];
                StringBuilder sb = new StringBuilder();
                String serverURL = null;
                String queueName = null;
                StringTokenizer st = new StringTokenizer(sysInfoText, "\n");
                while (st.hasMoreTokens()) {
                    int index;
                    String line = st.nextToken();
                    if (serverURL == null && line.indexOf("\"em1\"") != -1 && (index = line.lastIndexOf(44)) != -1) {
                        serverURL = line.substring(index + 1, line.length());
                        sb.append("Server: ").append(serverURL).append("\n");
                    }
                    if (queueName == null && line.indexOf("\"JMSDestination\"") != -1) {
                        String queueLabel = "HornetQQueue[";
                        int index1 = line.lastIndexOf(queueLabel);
                        int index2 = line.lastIndexOf(93);
                        if (index1 != -1 && index2 != -1) {
                            queueName = line.substring(index1 + queueLabel.length(), index2);
                            sb.append("JMS Proline Queue: ").append(queueName).append("\n\n\n");
                        }
                    }
                    if (serverURL == null || queueName == null) continue;
                    break;
                }
                sb.append(sysInfoText);
                SystemInfoDialog.this.m_txtArea.setText(sb.toString());
                SystemInfoDialog.this.m_txtArea.setCaretPosition(0);
                SystemInfoDialog.this.revalidate();
                SystemInfoDialog.this.repack();
            }
        };
        SystemInfoTask task = new SystemInfoTask(callback, sysInfoResult);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    public void setVisible(boolean v) {
        this.centerToScreen();
        super.setVisible(v);
    }
}

