/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.uds.PeaklistSoftware;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.gui.DefaultDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class UpdatePeaklistSoftDialog
extends DefaultDialog {
    private JComboBox m_peaklistSoftwaresComboBox = null;
    private static UpdatePeaklistSoftDialog m_singletonDialog = null;
    private HashMap<String, PeaklistSoftware> m_peaklistByIdent = null;

    public static UpdatePeaklistSoftDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new UpdatePeaklistSoftDialog(parent);
        }
        return m_singletonDialog;
    }

    private UpdatePeaklistSoftDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Update Spectrum Parameters");
        this.setDocumentationSuffix("id.47hxl2r");
        this.setResizable(true);
        this.setInternalComponent(this.createInternalPanel());
        this.pack();
    }

    private JPanel createInternalPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Peaklist Softwares"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        JTextArea helpTxt = new JTextArea("Choose Peaklist Software to use to generate (new) spectrum parameters.");
        helpTxt.setRows(1);
        helpTxt.setForeground(Color.gray);
        panel.add((Component)helpTxt, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.gridy = 0;
        JLabel peaklistSoftwareLabel = new JLabel("Peaklist Software :");
        peaklistSoftwareLabel.setHorizontalAlignment(4);
        panel.add((Component)peaklistSoftwareLabel, c);
        ++c.gridy;
        PeaklistSoftware[] peaksofts = DatabaseDataManager.getDatabaseDataManager().getPeaklistSoftwaresWithNullArray();
        this.m_peaklistSoftwaresComboBox = new JComboBox();
        this.m_peaklistByIdent = new HashMap();
        for (PeaklistSoftware nextPLS : peaksofts) {
            if (nextPLS == null) {
                this.m_peaklistSoftwaresComboBox.addItem(null);
                continue;
            }
            String nextPLSIdent = this.getPeakListSoftwareString(nextPLS);
            this.m_peaklistByIdent.put(nextPLSIdent, nextPLS);
            this.m_peaklistSoftwaresComboBox.addItem(nextPLSIdent);
        }
        panel.add((Component)this.m_peaklistSoftwaresComboBox, c);
        panel.revalidate();
        return panel;
    }

    public String getPeakListSoftwareString(PeaklistSoftware o) {
        String version = o.getVersion();
        if (version == null) {
            return o.getName();
        }
        return o.getName() + " " + version;
    }

    public Long getSelectedPeaklistSoftwareId() {
        if (this.m_peaklistSoftwaresComboBox.getSelectedItem() != null) {
            return this.m_peaklistByIdent.get(this.m_peaklistSoftwaresComboBox.getSelectedItem().toString()).getId();
        }
        return null;
    }

    protected boolean okCalled() {
        return this.checkParameters();
    }

    private boolean checkParameters() {
        if (this.m_peaklistSoftwaresComboBox.getSelectedItem() == null) {
            this.setStatus(true, "Specify Peaklist software to use");
            this.highlight(this.m_peaklistSoftwaresComboBox);
            return false;
        }
        return true;
    }
}

