/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.msfiles.MzdbUploadBatch;
import fr.proline.studio.msfiles.MzdbUploadSettings;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.dialog.FileDialogInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class UploadMzdbDialog
extends DefaultDialog
implements FileDialogInterface {
    private static UploadMzdbDialog m_singletonDialog = null;
    private static JList m_fileList;
    private JScrollPane m_fileListScrollPane;
    private JButton m_addFileButton;
    private JButton m_removeFileButton;
    private static ParameterList m_parameterList;
    private BooleanParameter m_deleteMzdbParameter;
    private BooleanParameter m_createParentDirectoryParameter;
    private static ObjectParameter m_uploadLabelParameter;
    private String m_lastParentDirectory;

    public static UploadMzdbDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new UploadMzdbDialog(parent);
        } else {
            ArrayList labels = ServerFileSystemView.getServerFileSystemView().getLabels("mzdb_files");
            Object[] associatedTable = labels.toArray(new String[labels.size()]);
            Object[] objectTable = labels.toArray(new String[labels.size()]);
            m_uploadLabelParameter.updateAssociatedObjects(associatedTable);
            m_uploadLabelParameter.updateObjects(objectTable);
            m_parameterList.loadParameters(NbPreferences.root());
            if (m_fileList != null) {
                DefaultListModel model = (DefaultListModel)m_fileList.getModel();
                model.clear();
            }
        }
        return m_singletonDialog;
    }

    public UploadMzdbDialog(Window parent) {
        super(parent, Dialog.ModalityType.MODELESS);
        this.setTitle("Upload mzDB file(s)");
        this.setSize(new Dimension(360, 480));
        this.setResizable(true);
        this.setDocumentationSuffix("h.x6aqgbmas2le");
        this.setButtonVisible(1, true);
        this.setButtonName(0, "OK");
        this.setStatusVisible(true);
        this.setInternalComponent(this.createInternalComponent());
    }

    @Override
    public void setFiles(ArrayList<File> files) {
        ((DefaultListModel)m_fileList.getModel()).clear();
        if (files.size() > 0) {
            for (File f : files) {
                ((DefaultListModel)m_fileList.getModel()).addElement(f);
            }
            if (files.get(0).getParentFile() != null) {
                this.m_lastParentDirectory = files.get(0).getParentFile().getAbsolutePath();
            }
        }
    }

    private Component createInternalComponent() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BorderLayout());
        internalPanel.add((Component)this.createFileSelectionPanel(), "Center");
        internalPanel.add((Component)this.createParameterPanel(), "South");
        return internalPanel;
    }

    private JPanel createParameterPanel() {
        m_parameterList = new ParameterList("mzDB Settings");
        JCheckBox deleteCheckbox = new JCheckBox("Delete mzdb file after a successful upload");
        this.m_deleteMzdbParameter = new BooleanParameter("DELETE_MZDB", "Delete mzdb file after a successful upload", (JComponent)deleteCheckbox, Boolean.valueOf(false));
        m_parameterList.add((Object)this.m_deleteMzdbParameter);
        JCheckBox parentDirectoryCheckbox = new JCheckBox("Create Parent Directory in Destination");
        this.m_createParentDirectoryParameter = new BooleanParameter("CREATE_PARENT_DIRECTORY", "Create Parent Directory in Destination", (JComponent)parentDirectoryCheckbox, Boolean.valueOf(false));
        m_parameterList.add((Object)this.m_createParentDirectoryParameter);
        ArrayList labels = ServerFileSystemView.getServerFileSystemView().getLabels("mzdb_files");
        Object[] associatedTable = labels.toArray(new String[labels.size()]);
        JComboBox<String> namingComboBox = new JComboBox<String>(associatedTable);
        Object[] objectTable = labels.toArray(new String[labels.size()]);
        m_uploadLabelParameter = new ObjectParameter("MZDB_MOUNT_LABEL", "Server's mounting point", namingComboBox, associatedTable, objectTable, 0, null);
        m_parameterList.add((Object)m_uploadLabelParameter);
        m_parameterList.loadParameters(NbPreferences.root());
        ParameterList.ParametersPanel parameterPanel = m_parameterList.getPanel();
        parameterPanel.setBorder(BorderFactory.createTitledBorder(" Upload Options "));
        return parameterPanel;
    }

    private JPanel createFileSelectionPanel() {
        JPanel fileSelectionPanel = new JPanel(new GridBagLayout());
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Files Selection "));
        m_fileList = new JList(new DefaultListModel());
        this.m_fileListScrollPane = new JScrollPane(m_fileList){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        this.m_addFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        fileSelectionPanel.add((Component)this.m_fileListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        fileSelectionPanel.add((Component)this.m_addFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add(Box.createVerticalStrut(30), c);
        m_fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = m_fileList.getSelectedIndex() != -1;
                UploadMzdbDialog.this.m_removeFileButton.setEnabled(sometingSelected);
            }
        });
        this.m_addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences preferences = NbPreferences.root();
                String initializationDirectory = preferences.get("mzDB_Settings.LAST_MZDB_PATH", System.getProperty("user.home"));
                File f = new File(initializationDirectory);
                if (!f.exists() || !f.isDirectory()) {
                    initializationDirectory = System.getProperty("user.home");
                }
                JFileChooser fchooser = new JFileChooser(initializationDirectory);
                fchooser.setMultiSelectionEnabled(true);
                fchooser.addChoosableFileFilter(new FileNameExtensionFilter(".mzdb", "mzDB"));
                fchooser.setAcceptAllFileFilterUsed(false);
                int result = fchooser.showOpenDialog((Component)((Object)m_singletonDialog));
                if (result == 0) {
                    File[] files = fchooser.getSelectedFiles();
                    int nbFiles = files.length;
                    for (int i = 0; i < nbFiles; ++i) {
                        ((DefaultListModel)m_fileList.getModel()).addElement(files[i]);
                    }
                    if (files.length > 0 && files[0].getParentFile() != null) {
                        UploadMzdbDialog.this.m_lastParentDirectory = files[0].getParentFile().getAbsolutePath();
                    }
                }
            }
        });
        this.m_removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = m_fileList.getSelectedValuesList();
                Iterator it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)m_fileList.getModel()).removeElement(it.next());
                }
                UploadMzdbDialog.this.m_removeFileButton.setEnabled(false);
            }
        });
        return fileSelectionPanel;
    }

    protected boolean okCalled() {
        if (m_fileList.getModel().getSize() == 0) {
            this.setStatus(true, "No files are selected.");
            this.highlight(m_fileList);
            return false;
        }
        ParameterError error = m_parameterList.checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        m_parameterList.saveParameters(NbPreferences.root());
        if (this.m_lastParentDirectory != null) {
            Preferences preferences = NbPreferences.root();
            preferences.put("mzDB_Settings.LAST_MZDB_PATH", this.m_lastParentDirectory);
        }
        HashMap<File, MzdbUploadSettings> mzdbFiles = new HashMap<File, MzdbUploadSettings>();
        for (int i = 0; i < m_fileList.getModel().getSize(); ++i) {
            File file = (File)m_fileList.getModel().getElementAt(i);
            MzdbUploadSettings uploadSettings = new MzdbUploadSettings((Boolean)this.m_deleteMzdbParameter.getObjectValue(), m_uploadLabelParameter.getStringValue(), (Boolean)this.m_createParentDirectoryParameter.getObjectValue() != false ? File.separator + file.getParentFile().getName() : "");
            mzdbFiles.put((File)m_fileList.getModel().getElementAt(i), uploadSettings);
        }
        MzdbUploadBatch uploadBatch = new MzdbUploadBatch(mzdbFiles);
        Thread thread = new Thread(uploadBatch);
        thread.start();
        DefaultListModel listModel = (DefaultListModel)m_fileList.getModel();
        listModel.removeAllElements();
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }
}

