/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.exporter;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.DefaultStorableDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.Export2MzIdentMLFilePanel;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.Export2MzIdentMLParamPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.Dialog;
import java.awt.Window;
import java.util.HashMap;
import java.util.prefs.Preferences;

public class Export2MzIdentMLDialog
extends DefaultStorableDialog {
    protected static final String MZIDENT_SETTINGS_KEY = "Export2MzIdentML";
    private static final int STEP_PANEL_EXPORT_PARAM_DEF = 0;
    private static final int STEP_PANEL_FILE_CHOOSER = 1;
    private int m_step = 0;
    private DefaultDialog.ProgressTask m_task = null;
    private Export2MzIdentMLParamPanel m_paramPanel;
    private Export2MzIdentMLFilePanel m_filePanel;

    public Export2MzIdentMLDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Export to MzIdentML format");
        this.setResizable(true);
        this.setButtonName(0, "Next");
        this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW));
        this.setDocumentationSuffix("id.338fx5o");
        this.m_paramPanel = new Export2MzIdentMLParamPanel((DefaultDialog)this);
        this.setHelpHeader(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INFORMATION), "MzIdentML parameters", "Spectrum Matches should have been generated before exporting to MzidentML format.<br> It is also recommended to jave run 'Retrieve proteins sequences'.");
        this.setInternalComponent(this.m_paramPanel);
    }

    public void setTask(DefaultDialog.ProgressTask task) {
        this.m_task = task;
    }

    protected String getSettingsKey() {
        return MZIDENT_SETTINGS_KEY;
    }

    protected void saveParameters(Preferences filePreferences) {
        this.m_paramPanel.saveParameters(filePreferences);
    }

    protected boolean checkParameters() {
        return true;
    }

    protected void resetParameters() {
        this.m_paramPanel.resetParameters();
    }

    protected void loadParameters(Preferences preferences) throws Exception {
        this.m_paramPanel.loadParameters(preferences);
    }

    protected boolean okCalled() {
        if (this.m_step == 0) {
            if (!this.m_paramPanel.checkParameters()) {
                return false;
            }
            this.m_paramPanel.saveParameters(null);
            this.setButtonName(0, "OK");
            this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.OK));
            this.setButtonVisible(3, false);
            this.setButtonVisible(4, false);
            this.m_filePanel = new Export2MzIdentMLFilePanel((DefaultDialog)this);
            this.setHelpHeader(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INFORMATION), "MzIdentML output file", "Spectrum Matches should have been generated before exporting to MzidentML format.<br> It is also recommended to jave run 'Retrieve proteins sequences'.");
            this.replaceInternalComponent(this.m_filePanel);
            this.revalidate();
            this.repaint();
            this.m_step = 1;
            return false;
        }
        if (!this.m_filePanel.checkParameters()) {
            return false;
        }
        this.startTask(this.m_task);
        return false;
    }

    protected boolean loadCalled() {
        if (this.m_step == 0) {
            super.loadCalled();
        }
        return false;
    }

    protected boolean saveCalled() {
        if (this.m_step == 0) {
            if (!this.m_paramPanel.checkParameters()) {
                return false;
            }
            return super.saveCalled();
        }
        return false;
    }

    public HashMap<String, Object> getExportParams() {
        if (this.m_paramPanel != null) {
            return this.m_paramPanel.getExportParams();
        }
        return null;
    }

    public String getFileName() {
        if (this.m_filePanel != null) {
            return this.m_filePanel.getFileName();
        }
        return null;
    }
}

