/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.exporter;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.PrideExpDescPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.PrideFileSelectionPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.PrideProtocolDescPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.PrideSampleDescPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.PrideWizardPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.HashMap;

public class ExportPrideDialog
extends DefaultDialog {
    private static final int STEP_PANEL_EXPERIMENT_DEF = 0;
    private static final int STEP_PANEL_PROTOCOL_DEF = 1;
    private static final int STEP_PANEL_SAMPLE_DEF = 2;
    private static final int STEP_PANEL_FILE_CHOOSER = 3;
    private int m_step = 0;
    private DefaultDialog.ProgressTask m_task = null;

    public ExportPrideDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Export to PRIDE format Wizard");
        this.setResizable(true);
        this.setDocumentationSuffix("id.37m2jsg");
        this.setButtonName(0, "Next");
        this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW));
        PrideExpDescPanel.getPrideExpDescPanel().resetPanel();
        PrideProtocolDescPanel.getPrideProtocolDescPanel().resetPanel();
        PrideSampleDescPanel.getPrideSampleDescPanel().resetPanel();
        this.setInternalComponent(PrideExpDescPanel.getPrideExpDescPanel());
    }

    public void setTask(DefaultDialog.ProgressTask task) {
        this.m_task = task;
    }

    protected boolean okCalled() {
        if (this.m_step == 0) {
            if (!this.checkWizardParams(PrideExpDescPanel.getPrideExpDescPanel())) {
                return false;
            }
            this.replaceInternalComponent(PrideProtocolDescPanel.getPrideProtocolDescPanel());
            this.setButtonVisible(6, true);
            this.revalidate();
            this.repaint();
            this.m_step = 1;
            return false;
        }
        if (this.m_step == 1) {
            if (!this.checkWizardParams(PrideProtocolDescPanel.getPrideProtocolDescPanel())) {
                return false;
            }
            this.replaceInternalComponent(PrideSampleDescPanel.getPrideSampleDescPanel());
            this.revalidate();
            this.repaint();
            this.m_step = 2;
            return false;
        }
        if (this.m_step == 2) {
            if (!this.checkWizardParams(PrideSampleDescPanel.getPrideSampleDescPanel())) {
                return false;
            }
            this.setButtonName(0, "OK");
            this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.OK));
            this.replaceInternalComponent(PrideFileSelectionPanel.getPrideFileSelectionPanel());
            this.revalidate();
            this.repaint();
            this.m_step = 3;
            return false;
        }
        if (!this.checkWizardParams(PrideFileSelectionPanel.getPrideFileSelectionPanel())) {
            return false;
        }
        this.startTask(this.m_task);
        return false;
    }

    protected boolean backCalled() {
        if (this.m_step == 1) {
            this.replaceInternalComponent(PrideExpDescPanel.getPrideExpDescPanel());
            this.setButtonVisible(6, false);
            this.revalidate();
            this.repaint();
            this.m_step = 0;
            return true;
        }
        if (this.m_step == 2) {
            this.replaceInternalComponent(PrideProtocolDescPanel.getPrideProtocolDescPanel());
            this.revalidate();
            this.repaint();
            this.m_step = 1;
            return true;
        }
        this.setButtonName(0, "Next");
        this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW));
        this.replaceInternalComponent(PrideSampleDescPanel.getPrideSampleDescPanel());
        this.revalidate();
        this.repaint();
        this.m_step = 2;
        return true;
    }

    private boolean checkWizardParams(PrideWizardPanel panel) {
        Component c = panel.checkExportPrideParams();
        if (c != null) {
            this.setStatus(true, panel.getErrorMessage());
            this.highlight(c);
            return false;
        }
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }

    public String getFileName() {
        return PrideFileSelectionPanel.getPrideFileSelectionPanel().getFileName();
    }

    public HashMap<String, Object> getExportParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(PrideProtocolDescPanel.getPrideProtocolDescPanel().getExportPrideParams());
        params.putAll(PrideExpDescPanel.getPrideExpDescPanel().getExportPrideParams());
        params.putAll(PrideSampleDescPanel.getPrideSampleDescPanel().getExportPrideParams());
        return params;
    }
}

