/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.exporter;

import fr.proline.studio.rsmexplorer.gui.dialog.exporter.PrideWizardPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;

public class PrideFileSelectionPanel
extends PrideWizardPanel {
    private static PrideFileSelectionPanel m_panel = null;
    private JTextField m_fileTextField;
    private JFileChooser m_fchooser;
    protected String errorMsg;

    public static PrideFileSelectionPanel getPrideFileSelectionPanel() {
        if (m_panel == null) {
            m_panel = new PrideFileSelectionPanel();
        }
        return m_panel;
    }

    private PrideFileSelectionPanel() {
        super.initWizardPanels("<html><b>Step 4:</b> Export to file:</html>");
    }

    @Override
    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        mainPanel.add((Component)this.createFileSelectionPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        mainPanel.add(Box.createVerticalGlue(), c);
        return mainPanel;
    }

    private JPanel createFileSelectionPanel() {
        JPanel exportPanel = new JPanel(new GridBagLayout());
        exportPanel.setBorder(BorderFactory.createTitledBorder(" File Selection "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.m_fileTextField = new JTextField(30);
        exportPanel.add((Component)this.m_fileTextField, c);
        final JButton addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        addFileButton.setMargin(new Insets(2, 2, 2, 2));
        addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrideFileSelectionPanel.this.m_fchooser = new JFileChooser();
                PrideFileSelectionPanel.this.m_fchooser.setFileFilter(new FileNameExtensionFilter("XML file", "xml", "XML"));
                int result = PrideFileSelectionPanel.this.m_fchooser.showOpenDialog(addFileButton);
                if (result == 0) {
                    File file = PrideFileSelectionPanel.this.m_fchooser.getSelectedFile();
                    String absolutePath = file.getAbsolutePath();
                    String fileName = file.getName();
                    if (fileName.indexOf(46) == -1) {
                        absolutePath = absolutePath + ".xml";
                    }
                    PrideFileSelectionPanel.this.m_fileTextField.setText(absolutePath);
                }
            }
        });
        c.gridx += 2;
        exportPanel.add((Component)addFileButton, c);
        return exportPanel;
    }

    @Override
    public HashMap<String, Object> getExportPrideParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return params;
    }

    @Override
    protected Component checkExportPrideParams() {
        this.errorMsg = null;
        if (StringUtils.isEmpty((CharSequence)this.m_fileTextField.getText().trim())) {
            this.errorMsg = "An export filename should be specified";
            return this.m_fileTextField;
        }
        return null;
    }

    @Override
    protected String getErrorMessage() {
        return this.errorMsg;
    }

    public String getFileName() {
        return this.m_fileTextField.getText().trim();
    }
}

