/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.exporter;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dpm.data.CVParam;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.PrideWizardPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSInputable;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Term;

public class PrideProtocolDescPanel
extends PrideWizardPanel
implements OLSInputable {
    private static PrideProtocolDescPanel m_panel = null;
    private JTextField m_protocolNameTextField;
    private JTable m_stepsDescriptionTable;
    public static String STEPS_FIELD = "steps";
    private String errorMsg;

    private PrideProtocolDescPanel() {
        super.initWizardPanels("<html><b>Step 2:</b> Protocol Description</html>");
    }

    public static PrideProtocolDescPanel getPrideProtocolDescPanel() {
        if (m_panel == null) {
            m_panel = new PrideProtocolDescPanel();
        }
        return m_panel;
    }

    protected void resetPanel() {
        this.m_protocolNameTextField.setText(null);
        ((StepDescriptionTableModel)this.m_stepsDescriptionTable.getModel()).clearCVParams();
    }

    @Override
    public HashMap<String, Object> getExportPrideParams() {
        List<CVParam> steps;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.m_protocolNameTextField.getText() != null && !StringUtils.isEmpty((CharSequence)this.m_protocolNameTextField.getText().trim())) {
            params.put("protocol_name", this.m_protocolNameTextField.getText().trim());
        }
        if (!(steps = ((StepDescriptionTableModel)this.m_stepsDescriptionTable.getModel()).getStepsCVParams()).isEmpty()) {
            params.put("protocol_steps", steps);
        }
        return params;
    }

    @Override
    protected Component checkExportPrideParams() {
        this.errorMsg = null;
        String name = this.m_protocolNameTextField.getText();
        if (name == null || name.trim().isEmpty()) {
            this.errorMsg = "A Protocol name should be specified.";
            return this.m_protocolNameTextField;
        }
        List<CVParam> steps = ((StepDescriptionTableModel)this.m_stepsDescriptionTable.getModel()).getStepsCVParams();
        if (steps.isEmpty()) {
            this.errorMsg = "At least one Protocol Step should be specified.";
            return this.m_stepsDescriptionTable;
        }
        return null;
    }

    @Override
    protected String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createTitledBorder("Full Protocol description"));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        JLabel protocolLabel = new JLabel("Protocol Name* :");
        mainPanel.add((Component)protocolLabel, c);
        this.m_protocolNameTextField = new JTextField(30);
        ++c.gridx;
        c.weightx = 1.0;
        mainPanel.add((Component)this.m_protocolNameTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        mainPanel.add((Component)this.createStepsPanel(), c);
        return mainPanel;
    }

    protected JPanel createStepsPanel() {
        JPanel stepPanel = new JPanel(new GridBagLayout());
        stepPanel.setBorder(BorderFactory.createTitledBorder(" Steps Description* "));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 18;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        stepPanel.add(Box.createHorizontalGlue(), c);
        ++c.gridx;
        c.anchor = 12;
        c.fill = 0;
        JButton m_addStepDescButton = new JButton("Add Step", IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS));
        m_addStepDescButton.setMargin(new Insets(2, 2, 2, 2));
        stepPanel.add((Component)m_addStepDescButton, c);
        m_addStepDescButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OLSDialog((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, PrideProtocolDescPanel.getPrideProtocolDescPanel()), (OLSInputable)PrideProtocolDescPanel.getPrideProtocolDescPanel(), true, STEPS_FIELD, "", null, false);
            }
        });
        ++c.gridx;
        c.anchor = 12;
        c.fill = 0;
        JButton m_clearStepDescButton = new JButton("Clear Steps", IconManager.getIcon((IconManager.IconType)IconManager.IconType.CLEAR_ALL));
        m_clearStepDescButton.setMargin(new Insets(2, 2, 2, 2));
        stepPanel.add((Component)m_clearStepDescButton, c);
        m_clearStepDescButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((StepDescriptionTableModel)PrideProtocolDescPanel.this.m_stepsDescriptionTable.getModel()).clearCVParams();
            }
        });
        c.anchor = 18;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_stepsDescriptionTable = new JTable();
        this.m_stepsDescriptionTable.setModel(new StepDescriptionTableModel());
        JScrollPane m_stepsDescriptionJScrollPane = new JScrollPane();
        m_stepsDescriptionJScrollPane.setViewportView(this.m_stepsDescriptionTable);
        stepPanel.add((Component)m_stepsDescriptionJScrollPane, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        stepPanel.add(Box.createVerticalGlue(), c);
        return stepPanel;
    }

    public void insertOLSResult(String field, Term selectedValue, Term accession, String ontologyShort, String ontologyLong, int modifiedRow, String mappedTerm, List<String> metadata) {
        LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").debug("field : {}, selectedValue : {}  , accession : {} , ontologyShort : {} ontologyLong: {},  modifiedRow : {} mappedTerm: {} , nbr other : {}", new Object[]{field, selectedValue, accession, ontologyShort, ontologyLong, modifiedRow, mappedTerm, metadata});
        if (field == null) {
            return;
        }
        if (field.equals(STEPS_FIELD)) {
            CVParam newParam = new CVParam(ontologyShort, accession.getLabel(), selectedValue.getLabel(), "");
            if (modifiedRow == -1) {
                ((StepDescriptionTableModel)this.m_stepsDescriptionTable.getModel()).addCVParam(newParam);
            } else {
                ((StepDescriptionTableModel)this.m_stepsDescriptionTable.getModel()).replaceCVParam(newParam, modifiedRow);
            }
        }
    }

    public Window getWindow() {
        return WindowManager.getDefault().getMainWindow();
    }

    class StepDescriptionTableModel
    extends AbstractTableModel {
        public static final int STEP_DESCR_INDEX_COLINDEX = 0;
        public static final int STEP_DESCR_CVPARAM_COLINDEX = 1;
        public static final int STEP_DESCR_VALUE_COLINDEX = 2;
        private CVParam EMPTY_PARAM = new CVParam("NONE", "NONE", "NONE", null);
        private final Class[] colClasses = new Class[]{Integer.class, String.class, String.class};
        private final Boolean[] colEditable = new Boolean[]{false, false, true};
        private final String[] columnNames = new String[]{"Index", "CV Param", "Value"};
        private List<CVParam> cvParams = new ArrayList<CVParam>();

        public StepDescriptionTableModel() {
            this.cvParams.add(this.EMPTY_PARAM);
        }

        public void addCVParam(CVParam newParam) {
            if (this.cvParams.get(0).equals((Object)this.EMPTY_PARAM)) {
                this.cvParams.set(0, newParam);
                this.fireTableRowsUpdated(0, 0);
            } else {
                this.cvParams.add(newParam);
                this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
            }
        }

        public void clearCVParams() {
            int end = this.getRowCount() - 1;
            this.cvParams.clear();
            this.cvParams.add(this.EMPTY_PARAM);
            this.fireTableRowsDeleted(0, end);
        }

        public void replaceCVParam(CVParam newParam, int index) {
            this.cvParams.set(index, newParam);
            this.fireTableRowsUpdated(index, index);
        }

        public List<CVParam> getStepsCVParams() {
            ArrayList<CVParam> definedParams = new ArrayList<CVParam>(this.cvParams.size());
            for (CVParam definedStep : this.cvParams) {
                if (definedStep.equals((Object)this.EMPTY_PARAM)) continue;
                definedParams.add(definedStep);
            }
            return definedParams;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.cvParams.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return rowIndex;
                }
                case 1: {
                    return this.cvParams.get(rowIndex).toString();
                }
                case 2: {
                    return this.cvParams.get(rowIndex).getValue();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                this.cvParams.get(rowIndex).setValue(aValue.toString());
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        public Class getColumnClass(int columnIndex) {
            return this.colClasses[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.colEditable[columnIndex];
        }
    }
}

