/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractParamsPanel;
import fr.proline.studio.settings.FilePreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLabelFreeMSParamsPanel
extends AbstractParamsPanel {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    protected static final String[] CROSSASSIGN_STRATEGY_VALUES = new String[]{"Between all runs", "Within groups only"};
    protected static final String[] CROSSASSIGN_STRATEGY_KEYS = new String[]{"BETWEEN_ALL_RUNS", "WITHIN_GROUPS_ONLY"};
    protected static final String[] ALIGNMENT_METHOD_VALUES = new String[]{"Exhaustive", "Iterative"};
    protected static final String[] ALIGNMENT_METHOD_KEYS = new String[]{"EXHAUSTIVE", "ITERATIVE"};
    protected static final String[] FEATURE_MAPPING_METHOD_VALUES = new String[]{"Peptide Identity", "Feature Coordinates"};
    protected static final String[] FEATURE_MAPPING_METHOD_KEYS = new String[]{"PEPTIDE_IDENTITY", "FEATURE_COORDINATES"};
    protected static final String[] ALIGNMENT_SMOOTHING_METHOD_VALUES = new String[]{"Loess", "Landmark Range", "Time Window"};
    protected static final String[] ALIGNMENT_SMOOTHING_METHOD_KEYS = new String[]{"LOESS", "LANDMARK_RANGE", "TIME_WINDOW"};
    protected static final String[] CLUSTERING_TIME_COMPUTATION_VALUES = new String[]{"Most Intense", "Median"};
    protected static final String[] CLUSTERING_TIME_COMPUTATION_KEYS = new String[]{"MOST_INTENSE", "MEDIAN"};
    protected static final String[] CLUSTERING_INTENSITY_COMPUTATION_VALUES = new String[]{"Most Intense", "Sum"};
    protected static final String[] CLUSTERING_INTENSITY_COMPUTATION_KEYS = new String[]{"MOST_INTENSE", "SUM"};
    protected static final String[] FEATURE_FILTER_NAME_VALUES = new String[]{"Intensity", "Relative Intensity"};
    protected static final String[] FEATURE_FILTER_NAME_KEYS = new String[]{"INTENSITY", "RELATIVE_INTENSITY"};
    protected static final String[] FEATURE_FILTER_OPERATOR_VALUES = new String[]{">", "<"};
    protected static final String[] FEATURE_FILTER_OPERATOR_KEYS = new String[]{"GT", "LT"};
    protected static final String[] FEATURE_NORMALIZATION_VALUES = new String[]{"Median Ratio", "Intensity Sum", "Median Intensity"};
    protected static final String[] FEATURE_NORMALIZATION_KEYS = new String[]{"MEDIAN_RATIO", "INTENSITY_SUM", "MEDIAN_INTENSITY"};
    protected static final String[] DETECTION_METHOD_VALUES = new String[]{"Detect Peakels", "Detect Features", "Extract ions"};
    protected static final String[] DETECTION_METHOD_KEYS = new String[]{"DETECT_PEAKELS", "DETECT_FEATURES", "EXTRACT_IONS"};
    protected static final Double DEFAULT_EXTRACTION_MOZTOL_VALUE = 5.0;
    protected static final String DEFAULT_MOZTOL_UNIT = "PPM";
    protected static final Double DEFAULT_CLUSTER_MOZTOL_VALUE = 5.0;
    protected static final Double DEFAULT_CLUSTER_TIMETOL_VALUE = 15.0;
    protected static final String DEFAULT_CLUSTER_TIMECOMPUT_VALUE = "MOST_INTENSE";
    protected static final String DEFAULT_CLUSTER_INTENSITYCOMPUT_VALUE = "MOST_INTENSE";
    protected static final Boolean DEFAULT_ALIGN_VALUE = Boolean.TRUE;
    public static final Double DEFAULT_ALIGN_FEATMAP_TIMETOL_VALUE = 600.0;
    protected static final Double DEFAULT_ALIGN_FEATMAP_MOZTOL_VALUE = 5.0;
    protected static final Integer DEFAULT_ALIGN_MAXITE_VALUE = 3;
    protected static final Integer DEFAULT_ALIGN_MASSINTERVAL_VALUE = 20000;
    protected static final Integer DEFAULT_SMOOTH_WINSIZE_VALUE = 200;
    protected static final Integer DEFAULT_SMOOTH_WINOVERLAP_VALUE = 20;
    protected static final Integer DEFAULT_SMOOTH_WINOVERLAP_MAX_VALUE = 100;
    protected static final Integer DEFAULT_SMOOTH_NBRLM_VALUE = 50;
    protected static final Boolean DEFAULT_CROSS_ASSIGN_VALUE = Boolean.TRUE;
    protected static final Double DEFAULT_CA_FEATMAP_MOZTOL_VALUE = 5.0;
    protected static final Boolean DEFAULT_CA_USE_RELIABLE_FEAT = Boolean.TRUE;
    public static final Double DEFAULT_CA_FEATMAP_RTTOL_VALUE = 60.0;
    protected static final String DEFAULT_CA_FILTER_NAME_VALUE = "INTENSITY";
    protected static final String DEFAULT_CA_FILTER_OPERATOR_VALUE = "GT";
    protected static final Double DEFAULT_CA_FILTER_VALUE = 0.0;
    protected static final Boolean DEFAULT_NORMALIZATION_VALUE = Boolean.FALSE;
    public static final String XIC_PARAMS_PREFIX = "XicParameters";
    public static final String XIC_SIMPLIFIED_PARAMS = "XicParameters.isSimplifiedParameters";
    public static final String XIC_PARAMS_VERSION_KEY = "XicParameters.parametersVersion";
    public static final String ALIGNMENT_CONFIG = "alignment_config";
    public static final String ALIGNMENT_METHOD_NAME = "method_name";
    public static final String ALIGNMENT_SMOOTHING_METHOD_NAME = "smoothing_method_name";
    protected final boolean m_readOnly;
    protected JScrollPane m_scrollPane;

    public AbstractLabelFreeMSParamsPanel(boolean readOnly) {
        this.m_readOnly = readOnly;
        this.m_parameterList = new ParameterList(XIC_PARAMS_PREFIX);
        this.setBorder(AbstractLabelFreeMSParamsPanel.createTitledBorder(" Quantitation Parameters ", 0));
    }

    public abstract boolean isSimplifiedPanel();

    public void resetScrollbar() {
        this.m_scrollPane.getVerticalScrollBar().setValue(0);
    }

    public void loadParameters(FilePreferences filePreferences) throws BackingStoreException {
        String[] keys;
        Preferences preferences = NbPreferences.root();
        for (String key : keys = filePreferences.keys()) {
            String value = filePreferences.get(key, null);
            preferences.put(key, value);
        }
        this.getParameterList().loadParameters((Preferences)filePreferences);
    }

    public static TitledBorder createTitledBorder(String title, int level) {
        switch (level) {
            case 0: {
                return BorderFactory.createTitledBorder("<html> <b>" + title + "</b></html>");
            }
            case 1: {
                return BorderFactory.createTitledBorder("<html><font color='#0000FF'>&nbsp;&#x25A0;&nbsp;</font> <b>" + title + "</b></html>");
            }
        }
        return BorderFactory.createTitledBorder("<html><font color='#009999'>&nbsp;&#x25A0;&nbsp;</font> <b>" + title + "</b></html>");
    }
}

