/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.WindowManager;
import fr.proline.studio.gui.CheckBoxTitledBorder;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractLabelFreeMSParamsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class LabelFreeMSParamsCompletePanel
extends AbstractLabelFreeMSParamsPanel {
    private ObjectParameter<String> m_clusteringTimeComputationParameter;
    private ObjectParameter<String> m_clusteringIntensityComputationParameter;
    private ObjectParameter<String> m_featureFilterNameParameter;
    private ObjectParameter<String> m_featureFilterOperatorParameter;
    private ObjectParameter<String> m_normalizationParameter;
    private ObjectParameter<String> m_alignmentMethodParameter;
    private ObjectParameter<String> m_alignmentSmoothingMethodParameter;
    private ObjectParameter<String> m_alignmentFeatureMappMethodParameter;
    private ObjectParameter<String> m_crossAssignStrategyParameter;
    private BooleanParameter m_useLastPeakelDetectionParam = new BooleanParameter("useLastPeakelDetection", "Use last peakel detection", JCheckBox.class, Boolean.FALSE);
    private BooleanParameter m_alnIgnoreErrorsParameter = new BooleanParameter("ignoreErrors", "Ignore Alignment Errors", JCheckBox.class, Boolean.FALSE);
    private JTextField m_extractionMoZTolTF;
    private JTextField m_psmMatchingMoZTolTF;
    private JPanel m_alignmentSettingsPanel;
    private CheckBoxTitledBorder m_alignmentSettingsCBoxTitle;
    private JComboBox m_alignmentMethodCB;
    private JLabel m_alignmentMaxIteLabel;
    private JLabel m_alignmentFeatureMoZTolLabel;
    private JTextField m_alignmentMaxIterationTF;
    private JTextField m_alignmentFeatureMapMoZTolTF;
    private JTextField m_alignmentFeatureMapTimeToleranceTF;
    private JComboBox m_alignmentSmoothingMethodCB;
    private JLabel m_alignmentSmoothTimeIntervalLabel;
    private JLabel m_alignmentSmoothWinOverlapLabel;
    private JLabel m_alignmentSmoothNbrLMLabel;
    private JTextField m_alignmentSmoothWinSizeTF;
    private JTextField m_alignmentSmoothMinWinLMTF;
    private JTextField m_alignmentSmoothWinOverlapTF;
    private JComboBox m_alignmentFeatureMapMethodCB;
    private JPanel m_crossAssignSettingsPanel;
    private JTextField m_crossAssignFeatureMappMoZTolTF;
    private JTextField m_crossAssignFeatureMappRTTolTF;
    private CheckBoxTitledBorder m_crossAssignCBoxTitle;
    private JComboBox m_crossAssignStrategyCB;
    private JLabel m_featureFilterNameLabel;
    private JLabel m_featureFilterOperatorLabel;
    private JLabel m_featureFilterValueLabel;
    private CheckBoxTitledBorder m_featureFilterCBTitle;
    private JComboBox m_featureFilterNameCB;
    private JComboBox m_featureFilterOperatorCB;
    private JTextField m_featureFilterValueTF;
    private JCheckBox m_retainOnlyReliableFeaturesCB;
    private JTextField m_clusteringMoZTolTF;
    private JTextField m_clusteringTimeTolTF;
    private JComboBox m_clusteringTimeComputationCB;
    private JComboBox m_clusteringIntensityComputationCB;
    private JPanel m_normalizationSettingsPanel;
    private CheckBoxTitledBorder m_normalizationSettingsCBTitle;
    private JComboBox m_normalizationCB;
    private JLabel m_normalizationLabel;

    public LabelFreeMSParamsCompletePanel(boolean readOnly, boolean readValues) {
        super(readOnly);
        this.createParameters();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel mainPanel = this.createMainPanel();
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView(mainPanel);
        this.m_scrollPane.createVerticalScrollBar();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.m_scrollPane, c);
        if (readValues) {
            this.m_parameterList.updateValues(NbPreferences.root());
        } else {
            this.m_parameterList.setDefaultValues();
        }
        for (AbstractParameter param : this.m_parameterList) {
            param.setUsed(true);
        }
    }

    @Override
    public boolean isSimplifiedPanel() {
        return false;
    }

    private void createParameters() {
        this.m_extractionMoZTolTF = new JTextField();
        DoubleParameter extractionMoZTolParameter = new DoubleParameter("extractionMoZTol", "Extraction moz tolerance", (JComponent)this.m_extractionMoZTolTF, DEFAULT_EXTRACTION_MOZTOL_VALUE, new Double(0.0), null);
        this.m_parameterList.add((Object)extractionMoZTolParameter);
        this.m_psmMatchingMoZTolTF = new JTextField();
        DoubleParameter psmMatchingMoZTolTFParameter = new DoubleParameter("psmMatchingMoZTolTF", "PSM Matching moz tolerance", (JComponent)this.m_psmMatchingMoZTolTF, DEFAULT_EXTRACTION_MOZTOL_VALUE, new Double(0.0), null);
        this.m_parameterList.add((Object)psmMatchingMoZTolTFParameter);
        this.m_parameterList.add((Object)this.m_useLastPeakelDetectionParam);
        ((JCheckBox)this.m_useLastPeakelDetectionParam.getComponent(null)).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), "Warning, if last peakel detection used only post peakel extraction parameters will be used !", "Xic Parameters Warning", 2);
                }
            }
        });
        this.m_parameterList.add((Object)this.m_alnIgnoreErrorsParameter);
        this.m_crossAssignCBoxTitle = new CheckBoxTitledBorder("Cross Assignment", DEFAULT_CROSS_ASSIGN_VALUE.booleanValue());
        this.m_crossAssignCBoxTitle.setEnabled(!this.m_readOnly);
        this.m_crossAssignCBoxTitle.addChangeListener(e -> this.updateCrossAssignment());
        BooleanParameter crossAssignParameter = new BooleanParameter("crossAssignment", "Cross Assignment", (JComponent)this.m_crossAssignCBoxTitle.getInternalCheckBox(), DEFAULT_CROSS_ASSIGN_VALUE);
        this.m_parameterList.add((Object)crossAssignParameter);
        this.m_crossAssignStrategyCB = new JComboBox<String>(CROSSASSIGN_STRATEGY_VALUES);
        this.m_crossAssignStrategyParameter = new ObjectParameter("crossAssignStrategy", "Cross Assignment Strategy", this.m_crossAssignStrategyCB, (Object[])CROSSASSIGN_STRATEGY_VALUES, (Object[])CROSSASSIGN_STRATEGY_KEYS, 0, null);
        this.m_parameterList.add(this.m_crossAssignStrategyParameter);
        this.m_clusteringMoZTolTF = new JTextField();
        DoubleParameter m_clusteringMoZTolParameter = new DoubleParameter("clusteringMoZTol", "Clustering moz tolerance", (JComponent)this.m_clusteringMoZTolTF, DEFAULT_CLUSTER_MOZTOL_VALUE, new Double(0.0), null);
        this.m_parameterList.add((Object)m_clusteringMoZTolParameter);
        this.m_clusteringTimeTolTF = new JTextField();
        DoubleParameter m_clusteringTimeTolParameter = new DoubleParameter("clusteringTimeTol", "Clustering time tolerance", (JComponent)this.m_clusteringTimeTolTF, DEFAULT_CLUSTER_TIMETOL_VALUE, new Double(0.0), null);
        this.m_parameterList.add((Object)m_clusteringTimeTolParameter);
        this.m_clusteringTimeComputationCB = new JComboBox<String>(CLUSTERING_TIME_COMPUTATION_VALUES);
        this.m_clusteringTimeComputationParameter = new ObjectParameter("clusteringTimeComputation", "Clustering time computation", this.m_clusteringTimeComputationCB, (Object[])CLUSTERING_TIME_COMPUTATION_VALUES, (Object[])CLUSTERING_TIME_COMPUTATION_KEYS, 0, null);
        this.m_parameterList.add(this.m_clusteringTimeComputationParameter);
        this.m_clusteringIntensityComputationCB = new JComboBox<String>(CLUSTERING_INTENSITY_COMPUTATION_VALUES);
        this.m_clusteringIntensityComputationParameter = new ObjectParameter("clusteringIntensityComputation", "Clustering intensity computation", this.m_clusteringIntensityComputationCB, (Object[])CLUSTERING_INTENSITY_COMPUTATION_VALUES, (Object[])CLUSTERING_INTENSITY_COMPUTATION_KEYS, 0, null);
        this.m_parameterList.add(this.m_clusteringIntensityComputationParameter);
        this.m_alignmentSettingsCBoxTitle = new CheckBoxTitledBorder("Map Alignment", true);
        this.m_alignmentSettingsCBoxTitle.setEnabled(!this.m_readOnly);
        this.m_alignmentSettingsCBoxTitle.addChangeListener(e -> this.updateAlignment());
        BooleanParameter alignRTParameter = new BooleanParameter("alignRT", "Align RT", (JComponent)this.m_alignmentSettingsCBoxTitle.getInternalCheckBox(), DEFAULT_ALIGN_VALUE);
        this.m_parameterList.add((Object)alignRTParameter);
        this.m_alignmentMethodCB = new JComboBox<String>(ALIGNMENT_METHOD_VALUES);
        this.m_alignmentMethodParameter = new ObjectParameter("alignmentMethod", "Alignment Method", this.m_alignmentMethodCB, (Object[])ALIGNMENT_METHOD_VALUES, (Object[])ALIGNMENT_METHOD_KEYS, 0, null);
        this.m_parameterList.add(this.m_alignmentMethodParameter);
        this.m_alignmentMaxIterationTF = new JTextField();
        IntegerParameter alignmentMaxIterationParameter = new IntegerParameter("alignmentMaxIteration", "Alignment max iteration", (JComponent)this.m_alignmentMaxIterationTF, DEFAULT_ALIGN_MAXITE_VALUE, new Integer(1), null);
        this.m_parameterList.add((Object)alignmentMaxIterationParameter);
        this.m_alignmentSmoothingMethodCB = new JComboBox<String>(ALIGNMENT_SMOOTHING_METHOD_VALUES);
        this.m_alignmentSmoothingMethodParameter = new ObjectParameter("alignmentSmoothingMethod", "Alignment Smoothing Method", this.m_alignmentSmoothingMethodCB, (Object[])ALIGNMENT_SMOOTHING_METHOD_VALUES, (Object[])ALIGNMENT_SMOOTHING_METHOD_KEYS, 0, null);
        this.m_parameterList.add(this.m_alignmentSmoothingMethodParameter);
        this.m_alignmentSmoothWinSizeTF = new JTextField();
        IntegerParameter alignmentSmoothingWinSizeParameter = new IntegerParameter("alignmentTimeInterval", "Alignment time interval", (JComponent)this.m_alignmentSmoothWinSizeTF, DEFAULT_SMOOTH_WINSIZE_VALUE, new Integer(1), null);
        this.m_parameterList.add((Object)alignmentSmoothingWinSizeParameter);
        this.m_alignmentSmoothWinOverlapTF = new JTextField();
        IntegerParameter alignmentSmoothingWinOverlapParameter = new IntegerParameter("smoothingSlidingWindowOverlap", "Smoothing sliding window overlap", (JComponent)this.m_alignmentSmoothWinOverlapTF, DEFAULT_SMOOTH_WINOVERLAP_VALUE, new Integer(1), DEFAULT_SMOOTH_WINOVERLAP_MAX_VALUE);
        this.m_parameterList.add((Object)alignmentSmoothingWinOverlapParameter);
        this.m_alignmentSmoothMinWinLMTF = new JTextField();
        IntegerParameter alignmentSmoothingMinWinlandmarksParameter = new IntegerParameter("smoothingMinimumNumberOfLandmarks", "Smoothing minimum number of landmarks", (JComponent)this.m_alignmentSmoothMinWinLMTF, DEFAULT_SMOOTH_NBRLM_VALUE, new Integer(1), null);
        this.m_parameterList.add((Object)alignmentSmoothingMinWinlandmarksParameter);
        this.m_alignmentFeatureMapMoZTolTF = new JTextField();
        DoubleParameter alignmentFeatureMappingMoZTolParameter = new DoubleParameter("featureMappingMozTolerance", "Feature Mapping Moz Tolerance", (JComponent)this.m_alignmentFeatureMapMoZTolTF, DEFAULT_ALIGN_FEATMAP_MOZTOL_VALUE, new Double(0.0), null);
        this.m_parameterList.add((Object)alignmentFeatureMappingMoZTolParameter);
        this.m_alignmentFeatureMapMethodCB = new JComboBox<String>(FEATURE_MAPPING_METHOD_VALUES);
        this.m_alignmentFeatureMappMethodParameter = new ObjectParameter("featureMappingMethod", "Feature Mapping Method", this.m_alignmentFeatureMapMethodCB, (Object[])FEATURE_MAPPING_METHOD_VALUES, (Object[])FEATURE_MAPPING_METHOD_KEYS, 0, null);
        this.m_parameterList.add(this.m_alignmentFeatureMappMethodParameter);
        this.m_alignmentFeatureMapTimeToleranceTF = new JTextField();
        DoubleParameter alignmentFeatureMappingTimeToleranceParameter = new DoubleParameter("featureMappingTimeTolerance", "Feature Mapping Time Tolerance", (JComponent)this.m_alignmentFeatureMapTimeToleranceTF, DEFAULT_ALIGN_FEATMAP_TIMETOL_VALUE, new Double(1.0), null);
        this.m_parameterList.add((Object)alignmentFeatureMappingTimeToleranceParameter);
        this.m_featureFilterCBTitle = new CheckBoxTitledBorder("Intensity Filtering", false);
        this.m_featureFilterCBTitle.setEnabled(!this.m_readOnly);
        this.m_featureFilterCBTitle.addChangeListener(e -> this.updateCrossAssignmentSettings());
        BooleanParameter featureFilteringParameter = new BooleanParameter("intensityFiltering", "Intensity Filtering", (JComponent)this.m_featureFilterCBTitle.getInternalCheckBox(), Boolean.FALSE);
        this.m_parameterList.add((Object)featureFilteringParameter);
        this.m_featureFilterNameCB = new JComboBox<String>(FEATURE_FILTER_NAME_VALUES);
        this.m_featureFilterNameParameter = new ObjectParameter("featureFilterNameParameter ", "Feature Name Parameter", this.m_featureFilterNameCB, (Object[])FEATURE_FILTER_NAME_VALUES, (Object[])FEATURE_FILTER_NAME_KEYS, 0, null);
        this.m_parameterList.add(this.m_featureFilterNameParameter);
        this.m_featureFilterOperatorCB = new JComboBox<String>(FEATURE_FILTER_OPERATOR_VALUES);
        this.m_featureFilterOperatorParameter = new ObjectParameter("featureFilterOperator ", "Feature Filter Operator", this.m_featureFilterOperatorCB, (Object[])FEATURE_FILTER_OPERATOR_VALUES, (Object[])FEATURE_FILTER_OPERATOR_KEYS, 0, null);
        this.m_parameterList.add(this.m_featureFilterOperatorParameter);
        this.m_featureFilterValueTF = new JTextField();
        DoubleParameter m_featureFilterValueParameter = new DoubleParameter("featureFilterValue", "Feature Filter Value", (JComponent)this.m_featureFilterValueTF, DEFAULT_CA_FILTER_VALUE, null, null);
        this.m_parameterList.add((Object)m_featureFilterValueParameter);
        this.m_crossAssignFeatureMappMoZTolTF = new JTextField();
        DoubleParameter featureMappingMoZTolParameter = new DoubleParameter("featureMoZTol", "moz tolerance ", (JComponent)this.m_crossAssignFeatureMappMoZTolTF, DEFAULT_CA_FEATMAP_MOZTOL_VALUE, new Double(0.0), null);
        this.m_parameterList.add((Object)featureMappingMoZTolParameter);
        this.m_crossAssignFeatureMappRTTolTF = new JTextField();
        DoubleParameter featureMappingTimeTolParameter = new DoubleParameter("featureTimeTol", "RT tolerance", (JComponent)this.m_crossAssignFeatureMappRTTolTF, DEFAULT_CA_FEATMAP_RTTOL_VALUE, new Double(0.0), null);
        this.m_parameterList.add((Object)featureMappingTimeTolParameter);
        this.m_normalizationSettingsCBTitle = new CheckBoxTitledBorder("Map Normalization", DEFAULT_NORMALIZATION_VALUE.booleanValue());
        this.m_normalizationSettingsCBTitle.setEnabled(!this.m_readOnly);
        this.m_normalizationSettingsCBTitle.addChangeListener(e -> LabelFreeMSParamsCompletePanel.setEnabled(this.m_normalizationSettingsPanel, this.m_normalizationSettingsCBTitle.isSelected()));
        BooleanParameter normalizationParameter = new BooleanParameter("mapNormalization", "Map Normalization", (JComponent)this.m_normalizationSettingsCBTitle.getInternalCheckBox(), DEFAULT_NORMALIZATION_VALUE);
        this.m_parameterList.add((Object)normalizationParameter);
        this.m_normalizationCB = new JComboBox<String>(FEATURE_NORMALIZATION_VALUES);
        this.m_normalizationParameter = new ObjectParameter("normalization", "Normalization", this.m_normalizationCB, (Object[])FEATURE_NORMALIZATION_VALUES, (Object[])FEATURE_NORMALIZATION_KEYS, 0, null);
        this.m_parameterList.add(this.m_normalizationParameter);
        this.m_retainOnlyReliableFeaturesCB = new JCheckBox("Use only confident features");
        BooleanParameter retainOnlyReliableFeaturesParameter = new BooleanParameter("restrainCrossAssignmentToReliableFeatures", "Use only confident features", (JComponent)this.m_retainOnlyReliableFeaturesCB, Boolean.TRUE);
        this.m_parameterList.add((Object)retainOnlyReliableFeaturesParameter);
    }

    @Override
    public void setQuantParams(Map<String, Object> quantParams) {
        Map detectionParams;
        Map extRactParams = (Map)quantParams.get("extraction_params");
        this.m_extractionMoZTolTF.setText("" + Double.parseDouble(extRactParams.get("moz_tol").toString()));
        if (quantParams.containsKey("detection_params") && (detectionParams = (Map)quantParams.get("detection_params")).containsKey("psm_matching_params")) {
            this.m_psmMatchingMoZTolTF.setText("" + Double.parseDouble(((Map)detectionParams.get("psm_matching_params")).get("moz_tol").toString()));
        }
        if (quantParams.containsKey("alignment_config")) {
            Map alignmentConfig = (Map)quantParams.get("alignment_config");
            this.m_alignmentMethodParameter.setValue(alignmentConfig.getOrDefault("method_name", ALIGNMENT_METHOD_VALUES[0]));
            Map alnParams = alignmentConfig.getOrDefault("aln_params", new HashMap());
            if (alnParams.containsKey("max_iterations")) {
                try {
                    this.m_alignmentMaxIterationTF.setText("" + Integer.parseInt(((Object)alnParams.getOrDefault("max_iterations", DEFAULT_ALIGN_MAXITE_VALUE)).toString()));
                }
                catch (NumberFormatException ex) {
                    m_logger.error("error while settings max_iterations quanti params " + ex);
                    this.m_alignmentMaxIterationTF.setText(DEFAULT_ALIGN_MAXITE_VALUE.toString());
                }
            }
            this.m_alnIgnoreErrorsParameter.setValue(((Object)alignmentConfig.getOrDefault("ignore_errors", false)).toString());
            this.m_alignmentSmoothingMethodParameter.setValue(alignmentConfig.getOrDefault("smoothing_method_name", ALIGNMENT_SMOOTHING_METHOD_VALUES[0]));
            if (alignmentConfig.containsKey("smoothing_method_params")) {
                Map smootingParams = (Map)alignmentConfig.get("smoothing_method_params");
                try {
                    this.m_alignmentSmoothWinSizeTF.setText("" + Integer.parseInt(((Object)smootingParams.getOrDefault("window_size", DEFAULT_SMOOTH_WINSIZE_VALUE)).toString()));
                    this.m_alignmentSmoothWinOverlapTF.setText("" + Integer.parseInt(((Object)smootingParams.getOrDefault("window_overlap", DEFAULT_SMOOTH_WINOVERLAP_VALUE)).toString()));
                    this.m_alignmentSmoothMinWinLMTF.setText("" + Integer.parseInt(((Object)smootingParams.getOrDefault("min_window_landmarks", DEFAULT_SMOOTH_NBRLM_VALUE)).toString()));
                }
                catch (NumberFormatException ex) {
                    m_logger.error("error while settings smoothing_params quanti params " + ex);
                    this.m_alignmentSmoothWinSizeTF.setText(DEFAULT_SMOOTH_WINSIZE_VALUE.toString());
                    this.m_alignmentSmoothWinOverlapTF.setText(DEFAULT_SMOOTH_WINOVERLAP_VALUE.toString());
                    this.m_alignmentSmoothMinWinLMTF.setText(DEFAULT_SMOOTH_NBRLM_VALUE.toString());
                }
            }
            this.m_alignmentFeatureMappMethodParameter.setValue(alignmentConfig.getOrDefault("ft_mapping_method_name", FEATURE_MAPPING_METHOD_KEYS[0]));
            Map alnFtParams = (Map)alignmentConfig.get("ft_mapping_method_params");
            try {
                if (alnFtParams.containsKey("moz_tol")) {
                    this.m_alignmentFeatureMapMoZTolTF.setText("" + Double.parseDouble(((Object)alnFtParams.getOrDefault("moz_tol", DEFAULT_ALIGN_FEATMAP_MOZTOL_VALUE)).toString()));
                }
                this.m_alignmentFeatureMapTimeToleranceTF.setText("" + Double.parseDouble(((Object)alnFtParams.getOrDefault("time_tol", DEFAULT_ALIGN_FEATMAP_TIMETOL_VALUE)).toString()));
            }
            catch (NumberFormatException ex) {
                m_logger.error("error while settings ft_mapping_params quanti params " + ex);
                this.m_alignmentFeatureMapMoZTolTF.setText(DEFAULT_ALIGN_FEATMAP_MOZTOL_VALUE.toString());
                this.m_alignmentFeatureMapTimeToleranceTF.setText(DEFAULT_ALIGN_FEATMAP_TIMETOL_VALUE.toString());
            }
            this.m_alignmentSettingsCBoxTitle.setSelected(true);
        } else {
            this.m_alignmentSettingsCBoxTitle.setSelected(false);
        }
        if (quantParams.containsKey("cross_assignment_config")) {
            Map crossAssignmentConfig = (Map)quantParams.get("cross_assignment_config");
            this.m_crossAssignStrategyParameter.setValue(crossAssignmentConfig.getOrDefault("method_name", CROSSASSIGN_STRATEGY_VALUES[0]));
            Map ftMappingParams = crossAssignmentConfig.getOrDefault("ft_mapping_params", new HashMap());
            try {
                this.m_crossAssignFeatureMappMoZTolTF.setText("" + Double.parseDouble(((Object)ftMappingParams.getOrDefault("moz_tol", DEFAULT_CA_FEATMAP_MOZTOL_VALUE)).toString()));
                this.m_crossAssignFeatureMappRTTolTF.setText("" + Double.parseDouble(((Object)ftMappingParams.getOrDefault("time_tol", DEFAULT_CA_FEATMAP_RTTOL_VALUE)).toString()));
            }
            catch (NumberFormatException ex) {
                m_logger.error("error while settings CA ft_mapping_params quanti params " + ex);
                this.m_crossAssignFeatureMappMoZTolTF.setText(DEFAULT_CA_FEATMAP_MOZTOL_VALUE.toString());
                this.m_crossAssignFeatureMappRTTolTF.setText(DEFAULT_CA_FEATMAP_RTTOL_VALUE.toString());
            }
            if (crossAssignmentConfig.containsKey("ft_filter")) {
                this.m_featureFilterCBTitle.setSelected(true);
                Map ftParams = (Map)crossAssignmentConfig.get("ft_filter");
                this.m_featureFilterNameParameter.setValue(ftParams.getOrDefault("name", FEATURE_FILTER_NAME_VALUES[0]));
                this.m_featureFilterOperatorParameter.setValue(ftParams.getOrDefault("operator", FEATURE_FILTER_OPERATOR_VALUES[0]));
                try {
                    this.m_featureFilterValueTF.setText("" + Double.parseDouble(((Object)ftParams.getOrDefault("value", DEFAULT_CA_FILTER_VALUE)).toString()));
                }
                catch (NullPointerException | NumberFormatException ex) {
                    m_logger.error("error while settings ft_filter quanti params " + ex);
                    this.m_featureFilterValueTF.setText(DEFAULT_CA_FILTER_VALUE.toString());
                }
            } else {
                this.m_featureFilterCBTitle.setSelected(false);
            }
            this.m_retainOnlyReliableFeaturesCB.setSelected(Boolean.parseBoolean(((Object)crossAssignmentConfig.getOrDefault("restrain_to_reliable_features", true)).toString()));
            this.m_crossAssignCBoxTitle.setSelected(true);
        } else {
            this.m_crossAssignCBoxTitle.setSelected(false);
        }
        this.m_useLastPeakelDetectionParam.setValue(quantParams.getOrDefault("use_last_peakel_detection", false).toString());
        Map clusterParams = (Map)quantParams.get("clustering_params");
        try {
            this.m_clusteringMoZTolTF.setText("" + Double.parseDouble(((Object)clusterParams.getOrDefault("moz_tol", DEFAULT_CLUSTER_MOZTOL_VALUE)).toString()));
            this.m_clusteringTimeTolTF.setText("" + Double.parseDouble(((Object)clusterParams.getOrDefault("time_tol", DEFAULT_CLUSTER_TIMETOL_VALUE)).toString()));
        }
        catch (NullPointerException | NumberFormatException ex) {
            m_logger.error("error while settings clustering_params quanti params " + ex);
            this.m_clusteringMoZTolTF.setText(DEFAULT_CLUSTER_MOZTOL_VALUE.toString());
            this.m_clusteringTimeTolTF.setText(DEFAULT_CLUSTER_TIMETOL_VALUE.toString());
        }
        this.m_clusteringIntensityComputationParameter.setValue(clusterParams.getOrDefault("intensity_computation", CLUSTERING_INTENSITY_COMPUTATION_VALUES[0]));
        this.m_clusteringTimeComputationParameter.setValue(clusterParams.getOrDefault("time_computation", CLUSTERING_TIME_COMPUTATION_VALUES[0]));
        if (quantParams.containsKey("normalization_method") && quantParams.get("normalization_method") != null) {
            this.m_normalizationSettingsCBTitle.setSelected(true);
            this.m_normalizationParameter.setValue((String)quantParams.getOrDefault("normalization_method", FEATURE_NORMALIZATION_VALUES[0]));
        } else {
            this.m_normalizationSettingsCBTitle.setSelected(false);
        }
        this.updateNormalizationSettings();
        this.updateAlignmentFeatureMapping();
        this.updateAlignmentMethod();
        this.updateAlignmentSmoothing();
    }

    @Override
    public Map<String, Object> getQuantParams() {
        boolean crossAssignmentEnabled;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("config_version", "2.0");
        HashMap<String, String> extractionParams = new HashMap<String, String>();
        extractionParams.put("moz_tol", this.m_extractionMoZTolTF.getText());
        extractionParams.put("moz_tol_unit", "PPM");
        params.put("extraction_params", extractionParams);
        params.put("use_last_peakel_detection", this.m_useLastPeakelDetectionParam.getStringValue());
        HashMap detectionParams = new HashMap();
        HashMap<String, String> detectionToleranceParams = new HashMap<String, String>();
        detectionToleranceParams.put("moz_tol", this.m_psmMatchingMoZTolTF.getText());
        detectionToleranceParams.put("moz_tol_unit", "PPM");
        detectionParams.put("psm_matching_params", detectionToleranceParams);
        detectionParams.put("isotope_matching_params", detectionToleranceParams);
        params.put("detection_params", detectionParams);
        HashMap<String, String> clusteringParams = new HashMap<String, String>();
        clusteringParams.put("moz_tol", this.m_clusteringMoZTolTF.getText());
        clusteringParams.put("moz_tol_unit", "PPM");
        clusteringParams.put("time_tol", this.m_clusteringTimeTolTF.getText());
        clusteringParams.put("time_computation", this.m_clusteringTimeComputationParameter.getStringValue());
        clusteringParams.put("intensity_computation", this.m_clusteringIntensityComputationParameter.getStringValue());
        params.put("clustering_params", clusteringParams);
        if (this.m_alignmentSettingsCBoxTitle.isSelected()) {
            HashMap<String, Object> alignmentConfig = new HashMap<String, Object>();
            alignmentConfig.put("method_name", this.m_alignmentMethodParameter.getStringValue());
            HashMap<String, Object> alignmentMethodParams = new HashMap<String, Object>();
            if (this.m_alignmentMethodCB.getSelectedItem().equals(ALIGNMENT_METHOD_VALUES[1])) {
                alignmentMethodParams.put("mass_interval", DEFAULT_ALIGN_MASSINTERVAL_VALUE);
                alignmentMethodParams.put("max_iterations", this.m_alignmentMaxIterationTF.getText());
            }
            alignmentConfig.put("method_params", alignmentMethodParams);
            alignmentConfig.put("smoothing_method_name", this.m_alignmentSmoothingMethodParameter.getStringValue());
            if (!this.m_alignmentSmoothingMethodCB.getSelectedItem().equals(ALIGNMENT_SMOOTHING_METHOD_VALUES[0])) {
                HashMap<String, String> smootingParams = new HashMap<String, String>();
                smootingParams.put("window_size", this.m_alignmentSmoothWinSizeTF.getText());
                smootingParams.put("window_overlap", this.m_alignmentSmoothWinOverlapTF.getText());
                if (this.m_alignmentSmoothingMethodCB.getSelectedItem().equals(ALIGNMENT_SMOOTHING_METHOD_VALUES[2])) {
                    smootingParams.put("min_window_landmarks", this.m_alignmentSmoothMinWinLMTF.getText());
                }
                alignmentConfig.put("smoothing_method_params", smootingParams);
            }
            alignmentConfig.put("ft_mapping_method_name", this.m_alignmentFeatureMappMethodParameter.getStringValue());
            HashMap<String, String> alnFtParams = new HashMap<String, String>();
            alnFtParams.put("time_tol", this.m_alignmentFeatureMapTimeToleranceTF.getText());
            if (this.m_alignmentFeatureMapMethodCB.getSelectedItem().equals(FEATURE_MAPPING_METHOD_VALUES[1])) {
                alnFtParams.put("moz_tol", this.m_alignmentFeatureMapMoZTolTF.getText());
                alnFtParams.put("moz_tol_unit", "PPM");
            }
            alignmentConfig.put("ft_mapping_method_params", alnFtParams);
            alignmentConfig.put("ignore_errors", this.m_alnIgnoreErrorsParameter.getStringValue());
            params.put("alignment_config", alignmentConfig);
        }
        if (crossAssignmentEnabled = this.m_crossAssignCBoxTitle.isSelected()) {
            HashMap<String, Object> crossAssignmentConfig = new HashMap<String, Object>();
            crossAssignmentConfig.put("method_name", this.m_crossAssignStrategyParameter.getStringValue());
            crossAssignmentConfig.put("restrain_to_reliable_features", this.m_retainOnlyReliableFeaturesCB.isSelected());
            HashMap<String, String> ftMappingParams = new HashMap<String, String>();
            ftMappingParams.put("moz_tol", this.m_crossAssignFeatureMappMoZTolTF.getText());
            ftMappingParams.put("moz_tol_unit", "PPM");
            ftMappingParams.put("time_tol", this.m_crossAssignFeatureMappRTTolTF.getText());
            crossAssignmentConfig.put("ft_mapping_params", ftMappingParams);
            if (this.m_featureFilterCBTitle.isSelected()) {
                HashMap<String, String> ftParams = new HashMap<String, String>();
                ftParams.put("name", this.m_featureFilterNameParameter.getStringValue());
                ftParams.put("operator", this.m_featureFilterOperatorParameter.getStringValue());
                ftParams.put("value", this.m_featureFilterValueTF.getText());
                crossAssignmentConfig.put("ft_filter", ftParams);
            }
            params.put("cross_assignment_config", crossAssignmentConfig);
        }
        if (this.m_normalizationSettingsCBTitle.isSelected()) {
            params.put("normalization_method", this.m_normalizationParameter.getStringValue());
        }
        params.put("detection_method_name", DETECTION_METHOD_KEYS[0]);
        return params;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JTabbedPane m_tabbedPane = new JTabbedPane();
        m_tabbedPane.addTab("Detection", null, this.createDetectionPanel(), "Detection");
        m_tabbedPane.addTab("Clustering", null, this.createClusteringPanel(), "Feature Clustering");
        m_tabbedPane.addTab("Alignment", null, this.createAlignmentPanel(), "Map Alignment");
        m_tabbedPane.addTab("Normalization", null, this.createNormalizationPanel(), "Map Normalization");
        m_tabbedPane.addTab("Cross Assignment", null, this.createCrossAssignmentPanel(), "Cross Assignment");
        mainPanel.add((Component)m_tabbedPane, "Center");
        return mainPanel;
    }

    private JPanel createDetectionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel detectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel extractionMoZTolLabel = new JLabel("Extraction moz tolerance (ppm):");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        detectionPanel.add((Component)extractionMoZTolLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        detectionPanel.add((Component)this.m_extractionMoZTolTF, c);
        c.weightx = 0.0;
        JLabel psmMatchingMoZTolLabel = new JLabel("PSM/Peakel matching moz tolerance (ppm):");
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        detectionPanel.add((Component)psmMatchingMoZTolLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        detectionPanel.add((Component)this.m_psmMatchingMoZTolTF, c);
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        detectionPanel.add((Component)this.m_useLastPeakelDetectionParam.getComponent(), c);
        panel.add((Component)detectionPanel, "North");
        LabelFreeMSParamsCompletePanel.setEnabled(panel, !this.m_readOnly);
        return panel;
    }

    private JPanel createNormalizationPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.m_normalizationSettingsPanel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)this.m_normalizationSettingsCBTitle);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.m_normalizationLabel = new JLabel("Map intensities Normalization ");
        this.m_normalizationSettingsPanel.add((Component)this.m_normalizationLabel, c);
        ++c.gridx;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.m_normalizationSettingsPanel.add((Component)this.m_normalizationCB, c);
        panel.add((Component)this.m_normalizationSettingsPanel, "North");
        LabelFreeMSParamsCompletePanel.setEnabled(panel, false);
        return panel;
    }

    private JPanel createClusteringPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel clusteringPanel = new JPanel(new GridBagLayout());
        JPanel clusteringFeaturePanel = new JPanel(new GridBagLayout());
        clusteringFeaturePanel.setBorder(LabelFreeMSParamsCompletePanel.createTitledBorder(" Feature Clusterization rules ", 1));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        clusteringFeaturePanel.add((Component)new JLabel("delta moz (ppm) <= "), c);
        ++c.gridx;
        c.weightx = 1.0;
        clusteringFeaturePanel.add((Component)this.m_clusteringMoZTolTF, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        clusteringFeaturePanel.add((Component)new JLabel("delta RT (s) <= "), c);
        ++c.gridx;
        c.weightx = 1.0;
        clusteringFeaturePanel.add((Component)this.m_clusteringTimeTolTF, c);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        clusteringPanel.add((Component)clusteringFeaturePanel, gbc);
        JPanel summarizingPanel = new JPanel(new GridBagLayout());
        summarizingPanel.setBorder(LabelFreeMSParamsCompletePanel.createTitledBorder(" Clustered features summarization", 1));
        c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        summarizingPanel.add((Component)new JLabel("time computation:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        summarizingPanel.add((Component)this.m_clusteringTimeComputationCB, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        summarizingPanel.add((Component)new JLabel("intensity computation:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        summarizingPanel.add((Component)this.m_clusteringIntensityComputationCB, c);
        c.weightx = 0.0;
        ++gbc.gridy;
        clusteringPanel.add((Component)summarizingPanel, gbc);
        panel.add((Component)clusteringPanel, "North");
        LabelFreeMSParamsCompletePanel.setEnabled(panel, !this.m_readOnly);
        return panel;
    }

    private JPanel createAlignmentPanel() {
        AssignementActionListener assActionListener = new AssignementActionListener();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder((Border)this.m_alignmentSettingsCBoxTitle);
        this.m_alignmentSettingsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        JLabel m_algnmentMethodLabel = new JLabel("method:");
        this.m_alignmentSettingsPanel.add((Component)m_algnmentMethodLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_alignmentMethodCB.addActionListener(assActionListener);
        this.m_alignmentSettingsPanel.add((Component)this.m_alignmentMethodCB, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        this.m_alignmentMaxIteLabel = new JLabel("max iteration:");
        this.m_alignmentSettingsPanel.add((Component)this.m_alignmentMaxIteLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_alignmentSettingsPanel.add((Component)this.m_alignmentMaxIterationTF, c);
        c.weightx = 0.0;
        JPanel smootingPanel = new JPanel(new GridBagLayout());
        smootingPanel.setBorder(LabelFreeMSParamsCompletePanel.createTitledBorder(" Smoothing ", 1));
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 18;
        c1.fill = 1;
        c1.insets = new Insets(5, 5, 5, 5);
        c1.gridx = 0;
        c1.gridy = 0;
        JLabel m_algnmentSmoothMethodLabel = new JLabel("method:");
        smootingPanel.add((Component)m_algnmentSmoothMethodLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        this.m_alignmentSmoothingMethodCB.addActionListener(assActionListener);
        smootingPanel.add((Component)this.m_alignmentSmoothingMethodCB, c1);
        c1.weightx = 0.0;
        ++c1.gridy;
        c1.gridx = 0;
        this.m_alignmentSmoothTimeIntervalLabel = new JLabel("windows size");
        smootingPanel.add((Component)this.m_alignmentSmoothTimeIntervalLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        smootingPanel.add((Component)this.m_alignmentSmoothWinSizeTF, c1);
        c1.weightx = 0.0;
        ++c1.gridy;
        c1.gridx = 0;
        this.m_alignmentSmoothWinOverlapLabel = new JLabel("sliding window overlap (%):");
        smootingPanel.add((Component)this.m_alignmentSmoothWinOverlapLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        smootingPanel.add((Component)this.m_alignmentSmoothWinOverlapTF, c1);
        c1.weightx = 0.0;
        ++c1.gridy;
        c1.gridx = 0;
        this.m_alignmentSmoothNbrLMLabel = new JLabel("minimum number of landmarks :");
        smootingPanel.add((Component)this.m_alignmentSmoothNbrLMLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        smootingPanel.add((Component)this.m_alignmentSmoothMinWinLMTF, c1);
        c1.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.m_alignmentSettingsPanel.add((Component)smootingPanel, c);
        JPanel ftParamsPanel = new JPanel(new GridBagLayout());
        ftParamsPanel.setBorder(LabelFreeMSParamsCompletePanel.createTitledBorder(" Feature Mapping ", 1));
        c1 = new GridBagConstraints();
        c1.anchor = 23;
        c1.fill = 1;
        c1.insets = new Insets(5, 5, 5, 5);
        c1.gridx = 0;
        c1.gridy = 0;
        JLabel m_algnmentFeatureMapMethodLabel = new JLabel("method:");
        ftParamsPanel.add((Component)m_algnmentFeatureMapMethodLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        this.m_alignmentFeatureMapMethodCB.addActionListener(assActionListener);
        ftParamsPanel.add((Component)this.m_alignmentFeatureMapMethodCB, c1);
        c1.weightx = 0.0;
        ++c1.gridy;
        c1.gridx = 0;
        this.m_alignmentFeatureMoZTolLabel = new JLabel("moz tolerance (ppm):");
        ftParamsPanel.add((Component)this.m_alignmentFeatureMoZTolLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        ftParamsPanel.add((Component)this.m_alignmentFeatureMapMoZTolTF, c1);
        c1.weightx = 0.0;
        c1.gridx = 0;
        ++c1.gridy;
        JLabel m_alignmentFeatureTimeTolLabel = new JLabel("time tolerance (s):");
        ftParamsPanel.add((Component)m_alignmentFeatureTimeTolLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        ftParamsPanel.add((Component)this.m_alignmentFeatureMapTimeToleranceTF, c1);
        c1.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.m_alignmentSettingsPanel.add((Component)ftParamsPanel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.m_alignmentSettingsPanel.add((Component)this.m_alnIgnoreErrorsParameter.getComponent(null), c);
        panel.add((Component)this.m_alignmentSettingsPanel, "North");
        this.updateAlignmentFeatureMapping();
        this.updateAlignmentMethod();
        this.updateAlignmentSmoothing();
        LabelFreeMSParamsCompletePanel.setEnabled(panel, !this.m_readOnly);
        return panel;
    }

    private JPanel createCrossAssignmentPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder((Border)this.m_crossAssignCBoxTitle);
        this.m_crossAssignSettingsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints cm = new GridBagConstraints();
        cm.anchor = 23;
        cm.fill = 1;
        cm.insets = new Insets(5, 5, 5, 5);
        cm.gridx = 0;
        cm.gridy = 0;
        cm.weightx = 0.0;
        JLabel m_allowCrossAssignLabel = new JLabel("Allow cross assignment ");
        this.m_crossAssignSettingsPanel.add((Component)m_allowCrossAssignLabel, cm);
        ++cm.gridx;
        cm.weightx = 1.0;
        this.m_crossAssignSettingsPanel.add((Component)this.m_crossAssignStrategyCB, cm);
        JPanel ftPanel = new JPanel(new GridBagLayout());
        ftPanel.setBorder(LabelFreeMSParamsCompletePanel.createTitledBorder(" Filtering ", 1));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        ftPanel.add((Component)this.m_retainOnlyReliableFeaturesCB, c);
        JPanel m_featureFilterPanel = new JPanel(new GridBagLayout());
        m_featureFilterPanel.setBorder((Border)this.m_featureFilterCBTitle);
        this.m_featureFilterNameLabel = new JLabel("intensity:");
        this.m_featureFilterOperatorLabel = new JLabel("operator:");
        this.m_featureFilterValueLabel = new JLabel("value:");
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 18;
        c1.fill = 1;
        c1.insets = new Insets(5, 5, 5, 5);
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weightx = 0.0;
        m_featureFilterPanel.add((Component)this.m_featureFilterNameLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        m_featureFilterPanel.add((Component)this.m_featureFilterNameCB, c1);
        ++c1.gridy;
        c1.gridx = 0;
        c1.weightx = 0.0;
        m_featureFilterPanel.add((Component)this.m_featureFilterOperatorLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        m_featureFilterPanel.add((Component)this.m_featureFilterOperatorCB, c1);
        ++c1.gridy;
        c1.gridx = 0;
        c1.weightx = 0.0;
        m_featureFilterPanel.add((Component)this.m_featureFilterValueLabel, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        m_featureFilterPanel.add((Component)this.m_featureFilterValueTF, c1);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        ftPanel.add((Component)m_featureFilterPanel, c);
        ++cm.gridy;
        cm.gridx = 0;
        cm.weightx = 1.0;
        cm.gridwidth = 2;
        this.m_crossAssignSettingsPanel.add((Component)ftPanel, cm);
        JPanel ftParamsPanel = new JPanel(new GridBagLayout());
        ftParamsPanel.setBorder(LabelFreeMSParamsCompletePanel.createTitledBorder(" Feature Mapping ", 1));
        c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel m_crossAssignFeatureMappMoZTolLabel = new JLabel("moz tolerance (ppm):");
        c.gridx = 0;
        c.gridy = 0;
        ftParamsPanel.add((Component)m_crossAssignFeatureMappMoZTolLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        ftParamsPanel.add((Component)this.m_crossAssignFeatureMappMoZTolTF, c);
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        JLabel m_crossAssignFeatureMappRTTolLabel = new JLabel("RT tolerance (s):");
        ftParamsPanel.add((Component)m_crossAssignFeatureMappRTTolLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        ftParamsPanel.add((Component)this.m_crossAssignFeatureMappRTTolTF, c);
        c.weightx = 0.0;
        ++cm.gridy;
        cm.gridx = 0;
        cm.weightx = 1.0;
        cm.gridwidth = 2;
        this.m_crossAssignSettingsPanel.add((Component)ftParamsPanel, cm);
        panel.add((Component)this.m_crossAssignSettingsPanel, "North");
        LabelFreeMSParamsCompletePanel.setEnabled(panel, !this.m_readOnly);
        return panel;
    }

    private void updateCrossAssignment() {
        LabelFreeMSParamsCompletePanel.setEnabled(this.m_crossAssignSettingsPanel, !this.m_readOnly && this.m_crossAssignCBoxTitle.isSelected());
        this.updateCrossAssignmentSettings();
        if (this.m_readOnly) {
            this.m_crossAssignSettingsPanel.setVisible(this.m_crossAssignCBoxTitle.isSelected());
        }
    }

    private void updateCrossAssignmentSettings() {
        boolean filterEnabled = this.m_crossAssignCBoxTitle.isSelected() && this.m_featureFilterCBTitle.isSelected();
        this.m_featureFilterNameCB.setEnabled(!this.m_readOnly && filterEnabled);
        this.m_featureFilterNameLabel.setEnabled(!this.m_readOnly && filterEnabled);
        this.m_featureFilterOperatorLabel.setEnabled(!this.m_readOnly && filterEnabled);
        this.m_featureFilterValueLabel.setEnabled(!this.m_readOnly && filterEnabled);
        this.m_featureFilterOperatorCB.setEnabled(!this.m_readOnly && filterEnabled);
        this.m_featureFilterValueTF.setEnabled(!this.m_readOnly && filterEnabled);
        if (this.m_readOnly) {
            this.m_featureFilterNameCB.setVisible(filterEnabled);
            this.m_featureFilterNameLabel.setVisible(filterEnabled);
            this.m_featureFilterOperatorLabel.setVisible(filterEnabled);
            this.m_featureFilterValueLabel.setVisible(filterEnabled);
            this.m_featureFilterOperatorCB.setVisible(filterEnabled);
            this.m_featureFilterValueTF.setVisible(filterEnabled);
        }
    }

    private void updateAlignment() {
        LabelFreeMSParamsCompletePanel.setEnabled(this.m_alignmentSettingsPanel, !this.m_readOnly && this.m_alignmentSettingsCBoxTitle.isSelected());
        this.updateAlignmentSettings();
        if (this.m_readOnly) {
            this.m_alignmentSettingsPanel.setVisible(this.m_alignmentSettingsCBoxTitle.isSelected());
        }
    }

    private void updateNormalizationSettings() {
        boolean isEnabled = this.m_normalizationSettingsCBTitle.isSelected();
        this.m_normalizationCB.setEnabled(!this.m_readOnly && isEnabled);
        this.m_normalizationLabel.setEnabled(!this.m_readOnly && isEnabled);
        if (this.m_readOnly) {
            this.m_normalizationCB.setVisible(isEnabled);
            this.m_normalizationLabel.setVisible(isEnabled);
        }
    }

    private void updateAlignmentSettings() {
        this.updateAlignmentMethod();
        this.updateAlignmentSmoothing();
        this.updateAlignmentFeatureMapping();
    }

    private void updateAlignmentMethod() {
        boolean isIterative = this.m_alignmentMethodCB.getSelectedItem().equals(ALIGNMENT_METHOD_VALUES[1]);
        this.m_alignmentMaxIteLabel.setVisible(isIterative);
        this.m_alignmentMaxIterationTF.setVisible(isIterative);
    }

    private void updateAlignmentSmoothing() {
        boolean isSettingNeeded = !this.m_alignmentSmoothingMethodCB.getSelectedItem().equals(ALIGNMENT_SMOOTHING_METHOD_VALUES[0]);
        boolean isNbrLMNeeded = this.m_alignmentSmoothingMethodCB.getSelectedItem().equals(ALIGNMENT_SMOOTHING_METHOD_VALUES[2]);
        this.m_alignmentSmoothWinSizeTF.setVisible(isSettingNeeded);
        this.m_alignmentSmoothTimeIntervalLabel.setVisible(isSettingNeeded);
        this.m_alignmentSmoothWinOverlapTF.setVisible(isSettingNeeded);
        this.m_alignmentSmoothWinOverlapLabel.setVisible(isSettingNeeded);
        this.m_alignmentSmoothNbrLMLabel.setVisible(isNbrLMNeeded);
        this.m_alignmentSmoothMinWinLMTF.setVisible(isNbrLMNeeded);
    }

    private void updateAlignmentFeatureMapping() {
        boolean isSettingNeeded = this.m_alignmentFeatureMapMethodCB.getSelectedItem().equals(FEATURE_MAPPING_METHOD_VALUES[1]);
        this.m_alignmentFeatureMoZTolLabel.setVisible(isSettingNeeded);
        this.m_alignmentFeatureMapMoZTolTF.setVisible(isSettingNeeded);
    }

    private static void setEnabled(Container container, boolean isEnabled) {
        container.setEnabled(isEnabled);
        for (Component children : container.getComponents()) {
            if (Container.class.isAssignableFrom(children.getClass())) {
                LabelFreeMSParamsCompletePanel.setEnabled((Container)children, isEnabled);
                continue;
            }
            children.setEnabled(isEnabled);
        }
    }

    class AssignementActionListener
    implements ActionListener {
        AssignementActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LabelFreeMSParamsCompletePanel.this.updateAlignmentSettings();
        }
    }
}

