/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.corewrapper.data.QuantPostProcessingParams;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantPostProcessingPanel
extends JPanel {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.QuantPostProcessingPanel");
    private ParameterList m_parameterList;
    private boolean completeMode = false;
    private JScrollPane m_scrollPane;
    private JTabbedPane m_tabbedPane;
    private JComboBox<String> m_peptidesSelectionMethodCB;
    private JCheckBox m_discardMissCleavedPeptidesChB;
    private JCheckBox m_discardModifiedPeptidesChB;
    private JCheckBox m_discardPeptideIonsSharingPeakelsChB;
    private JCheckBox m_applyProfileClusteringChB;
    private List<JCheckBox> m_peptideModificationListChB;
    private JComboBox<String> m_peptideAbundanceSummarizingMethodCB;
    private JLabel m_modifiedPeptidesFilteringMethodLabel;
    private JComboBox<String> m_modifiedPeptidesFilteringMethodCB;
    private JComboBox<String> m_peptideIonAbundanceSummarizingMethodCB;
    private JTextField m_peptideStatTestsAlpha;
    private JCheckBox m_applyPepNormalizationChB;
    private JCheckBox m_applyPepMissValInferenceChB;
    private JCheckBox m_applyPepVarianceCorrectionChB;
    private JCheckBox m_applyPepTTestChB;
    private JCheckBox m_applyPepZTestChB;
    private JTextField m_proteinStatTestsAlpha;
    private JCheckBox m_applyProtNormalizationChB;
    private JCheckBox m_applyProtMissValInferenceChB;
    private JCheckBox m_applyProtVarianceCorrectionChB;
    private JCheckBox m_applyProtTTestChB;
    private JCheckBox m_applyProtZTestChB;
    private DoubleParameter m_peptideStatTestsAlphaParameter;
    private DoubleParameter m_proteinStatTestsAlphaParameter;
    private BooleanParameter m_discardMissCleavedPeptidesParameter;
    private BooleanParameter m_discardModifiedPeptidesParameter;
    private BooleanParameter m_discardPeptideIonsSharingPeakelsParameter;
    private BooleanParameter m_applyPepNormalizationParameter;
    private BooleanParameter m_applyProtNormalizationParameter;
    private BooleanParameter m_applyPepMissValInferenceParameter;
    private BooleanParameter m_applyProtMissValInferenceParameter;
    private BooleanParameter m_applyPepVarianceCorrectionParameter;
    private BooleanParameter m_applyProtVarianceCorrectionParameter;
    private BooleanParameter m_applyPepTTestParameter;
    private BooleanParameter m_applyProtTTestParameter;
    private BooleanParameter m_applyPepZTestParameter;
    private BooleanParameter m_applyProtZTestParameter;
    private BooleanParameter m_applyProfileClusteringParameter;
    private ObjectParameter<String> m_peptidesSelectionMethodParameter;
    private ObjectParameter<String> m_peptideAbundanceSummarizingMethodParameter;
    private ObjectParameter<String> m_modifiedPeptidesFilteringMethodParameter;
    private ObjectParameter<String> m_pepIonsAbundanceSummarizingMethodParameter;
    private List<BooleanParameter> m_peptidesModificationListParameter;
    private boolean m_readOnly;
    Map<Long, String> m_ptmSpecificityNameById;

    public QuantPostProcessingPanel(boolean readOnly, Map<Long, String> ptmSpecificityNameById) {
        this.m_readOnly = readOnly;
        this.m_ptmSpecificityNameById = ptmSpecificityNameById;
        this.init();
    }

    private void init() {
        Preferences preferences = NbPreferences.root();
        this.completeMode = preferences.getBoolean("Profi", false);
        this.m_parameterList = new ParameterList("QuantPostProcessing");
        this.m_parameterList.addBackwardCompatiblePrefix("QuantProfile");
        this.m_peptideModificationListChB = new ArrayList<JCheckBox>();
        this.m_peptidesModificationListParameter = new ArrayList<BooleanParameter>();
        this.createParameters();
        this.m_parameterList.updateValues(NbPreferences.root());
        for (AbstractParameter param : this.m_parameterList) {
            param.setUsed(true);
        }
        this.initPanel();
    }

    private void createParameters() {
        this.m_peptideStatTestsAlpha = new JTextField();
        this.m_peptideStatTestsAlpha.setEnabled(!this.m_readOnly);
        String paramKey = QuantPostProcessingParams.getPrefixedSettingKey((String)"peptide", (String)"stat_tests_alpha");
        this.m_peptideStatTestsAlphaParameter = new DoubleParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_peptideStatTestsAlpha, new Double(0.01), null, null);
        this.m_parameterList.add((Object)this.m_peptideStatTestsAlphaParameter);
        this.m_proteinStatTestsAlpha = new JTextField();
        this.m_proteinStatTestsAlpha.setEnabled(!this.m_readOnly);
        paramKey = QuantPostProcessingParams.getPrefixedSettingKey((String)"protein", (String)"stat_tests_alpha");
        this.m_proteinStatTestsAlphaParameter = new DoubleParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_proteinStatTestsAlpha, new Double(0.01), null, null);
        this.m_parameterList.add((Object)this.m_proteinStatTestsAlphaParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"discard_miss_cleaved_peptides");
        this.m_discardMissCleavedPeptidesChB = new JCheckBox(StringUtils.getLabelFromCamelCase((String)paramKey));
        this.m_discardMissCleavedPeptidesChB.setEnabled(!this.m_readOnly);
        this.m_discardMissCleavedPeptidesParameter = new BooleanParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_discardMissCleavedPeptidesChB, Boolean.valueOf(false));
        this.m_discardMissCleavedPeptidesParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"discard_missed_cleaved_peptides"));
        this.m_parameterList.add((Object)this.m_discardMissCleavedPeptidesParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"discard_modified_peptides");
        this.m_discardModifiedPeptidesChB = new JCheckBox(StringUtils.getLabelFromCamelCase((String)paramKey));
        this.m_discardModifiedPeptidesChB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuantPostProcessingPanel.this.updateDiscardPTMs();
            }
        });
        this.m_discardModifiedPeptidesChB.setEnabled(!this.m_readOnly);
        this.m_discardModifiedPeptidesParameter = new BooleanParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_discardModifiedPeptidesChB, Boolean.valueOf(false));
        this.m_discardModifiedPeptidesParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"discard_oxidized_peptides"));
        this.m_parameterList.add((Object)this.m_discardModifiedPeptidesParameter);
        this.m_ptmSpecificityNameById.forEach((id, name) -> {
            JCheckBox discardPeptidesWithModifChB = new JCheckBox((String)name);
            discardPeptidesWithModifChB.setEnabled(!this.m_readOnly);
            BooleanParameter ptmToDiscardParameter = new BooleanParameter("discardPeptideModification_" + id, name, (JComponent)discardPeptidesWithModifChB, Boolean.valueOf(false));
            ptmToDiscardParameter.setAssociatedData(id);
            this.m_peptideModificationListChB.add(discardPeptidesWithModifChB);
            this.m_peptidesModificationListParameter.add(ptmToDiscardParameter);
            this.m_parameterList.add((Object)ptmToDiscardParameter);
        });
        paramKey = QuantPostProcessingParams.getSettingKey((String)"discard_pep_ions_sharing_peakels");
        this.m_discardPeptideIonsSharingPeakelsChB = new JCheckBox(StringUtils.getLabelFromCamelCase((String)paramKey));
        this.m_discardPeptideIonsSharingPeakelsChB.setEnabled(!this.m_readOnly);
        this.m_discardPeptideIonsSharingPeakelsParameter = new BooleanParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_discardPeptideIonsSharingPeakelsChB, Boolean.valueOf(false));
        this.m_discardPeptideIonsSharingPeakelsParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"discard_peptides_sharing_peakels"));
        this.m_parameterList.add((Object)this.m_discardPeptideIonsSharingPeakelsParameter);
        this.m_applyPepNormalizationChB = new JCheckBox("Apply Normalization (median)");
        this.m_applyPepNormalizationChB.setEnabled(!this.m_readOnly);
        this.m_applyPepNormalizationParameter = new BooleanParameter("applyPepNormalization", "Apply Normalization on peptides", (JComponent)this.m_applyPepNormalizationChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyPepNormalizationParameter);
        this.m_applyProtNormalizationChB = new JCheckBox("Apply Normalization (median)");
        this.m_applyProtNormalizationChB.setEnabled(!this.m_readOnly);
        this.m_applyProtNormalizationParameter = new BooleanParameter("applyProtNormalization", "Apply Normalization on proteins", (JComponent)this.m_applyProtNormalizationChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyProtNormalizationParameter);
        this.m_applyPepMissValInferenceChB = new JCheckBox("Apply Missing Value Inference");
        this.m_applyPepMissValInferenceChB.setEnabled(!this.m_readOnly);
        this.m_applyPepMissValInferenceParameter = new BooleanParameter("applyPepMissValInference", "Apply Miss Val Inference on peptides", (JComponent)this.m_applyPepMissValInferenceChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyPepMissValInferenceParameter);
        this.m_applyProtMissValInferenceChB = new JCheckBox("Apply Missing Value Inference");
        this.m_applyProtMissValInferenceChB.setEnabled(!this.m_readOnly);
        this.m_applyProtMissValInferenceParameter = new BooleanParameter("applyProtMissValInference", "Apply Miss Val Inference on proteins", (JComponent)this.m_applyProtMissValInferenceChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyProtMissValInferenceParameter);
        this.m_applyPepVarianceCorrectionChB = new JCheckBox("Apply Variance Correction");
        this.m_applyPepVarianceCorrectionChB.setEnabled(!this.m_readOnly);
        this.m_applyPepVarianceCorrectionParameter = new BooleanParameter("applyPepVarianceCorrection", "Apply Variance Correction on peptides", (JComponent)this.m_applyPepVarianceCorrectionChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyPepVarianceCorrectionParameter);
        this.m_applyProtVarianceCorrectionChB = new JCheckBox("Apply Variance Correction");
        this.m_applyProtVarianceCorrectionChB.setEnabled(!this.m_readOnly);
        this.m_applyProtVarianceCorrectionParameter = new BooleanParameter("applyProtVarianceCorrection", "Apply Variance Correction on proteins", (JComponent)this.m_applyProtVarianceCorrectionChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyProtVarianceCorrectionParameter);
        this.m_applyPepTTestChB = new JCheckBox("Apply T-Test (peptide)");
        this.m_applyPepTTestChB.setEnabled(!this.m_readOnly);
        this.m_applyPepTTestParameter = new BooleanParameter("applyPepTTest", "Apply TTest on peptides", (JComponent)this.m_applyPepTTestChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyPepTTestParameter);
        this.m_applyProtTTestChB = new JCheckBox("Apply T-Test (protein)");
        this.m_applyProtTTestChB.setEnabled(!this.m_readOnly);
        this.m_applyProtTTestParameter = new BooleanParameter("applyProtTTest", "Apply TTest on proteins", (JComponent)this.m_applyProtTTestChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyProtTTestParameter);
        this.m_applyPepZTestChB = new JCheckBox("Apply Z-Test (peptide)");
        this.m_applyPepZTestChB.setEnabled(!this.m_readOnly);
        this.m_applyPepZTestParameter = new BooleanParameter("applyPepZTest", "Apply ZTest on peptides", (JComponent)this.m_applyPepZTestChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyPepZTestParameter);
        this.m_applyProtZTestChB = new JCheckBox("Apply Z-Test (protein)");
        this.m_applyProtZTestChB.setEnabled(!this.m_readOnly);
        this.m_applyProtZTestParameter = new BooleanParameter("applyProtZTest", "Apply ZTest on proteins", (JComponent)this.m_applyProtZTestChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyProtZTestParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"apply_profile_clustering");
        this.m_applyProfileClusteringChB = new JCheckBox(StringUtils.getLabelFromCamelCase((String)paramKey));
        this.m_applyProfileClusteringChB.setEnabled(!this.m_readOnly);
        this.m_applyProfileClusteringParameter = new BooleanParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_applyProfileClusteringChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyProfileClusteringParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"peptides_selection_method");
        this.m_peptidesSelectionMethodCB = new JComboBox<String>(QuantPostProcessingParams.getPeptidesSelectionMethodValues());
        this.m_peptidesSelectionMethodCB.setEnabled(!this.m_readOnly);
        this.m_peptidesSelectionMethodParameter = new ObjectParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), this.m_peptidesSelectionMethodCB, (Object[])QuantPostProcessingParams.getPeptidesSelectionMethodValues(), (Object[])QuantPostProcessingParams.getPeptidesSelectionMethodKeys(), 0, null);
        this.m_parameterList.add(this.m_peptidesSelectionMethodParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"peptide_abundance_summarizing_method");
        this.m_peptideAbundanceSummarizingMethodCB = new JComboBox<String>(QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodValues());
        this.m_peptideAbundanceSummarizingMethodCB.setEnabled(!this.m_readOnly);
        this.m_peptideAbundanceSummarizingMethodParameter = new ObjectParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), this.m_peptideAbundanceSummarizingMethodCB, (Object[])QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodValues(), (Object[])QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodKeys(), 5, null);
        this.m_peptideAbundanceSummarizingMethodParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"abundance_summarizing_method"));
        this.m_peptideAbundanceSummarizingMethodParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"abundance_summarizer_method"));
        this.m_parameterList.add(this.m_peptideAbundanceSummarizingMethodParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"pep_ion_abundance_summarizing_method");
        this.m_peptideIonAbundanceSummarizingMethodCB = new JComboBox<String>(QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodValues());
        this.m_peptideIonAbundanceSummarizingMethodCB.setEnabled(!this.m_readOnly);
        this.m_pepIonsAbundanceSummarizingMethodParameter = new ObjectParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), this.m_peptideIonAbundanceSummarizingMethodCB, (Object[])QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodValues(), (Object[])QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodKeys(), 0, null);
        this.m_pepIonsAbundanceSummarizingMethodParameter.addBackwardCompatibleKey("ionAbundanceSummarizerMethod");
        this.m_parameterList.add(this.m_pepIonsAbundanceSummarizingMethodParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"modified_peptide_filtering_method");
        this.m_modifiedPeptidesFilteringMethodCB = new JComboBox<String>(QuantPostProcessingParams.getModifiedPeptideFilteringMethodValues());
        this.m_modifiedPeptidesFilteringMethodCB.setEnabled(!this.m_readOnly);
        this.m_modifiedPeptidesFilteringMethodParameter = new ObjectParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), this.m_modifiedPeptidesFilteringMethodCB, (Object[])QuantPostProcessingParams.getModifiedPeptideFilteringMethodValues(), (Object[])QuantPostProcessingParams.getModifiedPeptideFilteringMethodKeys(), 0, null);
        this.m_modifiedPeptidesFilteringMethodParameter.addBackwardCompatibleKey("modifiedPeptidesFilteringMethod");
        this.m_parameterList.add(this.m_modifiedPeptidesFilteringMethodParameter);
    }

    private void updateDiscardPTMs() {
        if (!this.m_readOnly) {
            this.m_peptideModificationListChB.forEach(ptmCBx -> ptmCBx.setEnabled(this.m_discardModifiedPeptidesChB.isSelected()));
            this.m_modifiedPeptidesFilteringMethodLabel.setEnabled(this.m_discardModifiedPeptidesChB.isSelected());
            this.m_modifiedPeptidesFilteringMethodCB.setEnabled(this.m_discardModifiedPeptidesChB.isSelected());
        }
    }

    public void loadParameters(Preferences filePreferences, String version) throws BackingStoreException {
        boolean loadedPTMsParamsError = false;
        String[] hiddenParams = new String[]{this.m_parameterList.getPrefixName() + this.m_peptideStatTestsAlphaParameter.getName(), this.m_parameterList.getPrefixName() + this.m_proteinStatTestsAlphaParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyPepMissValInferenceParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyProtMissValInferenceParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyPepVarianceCorrectionParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyProtVarianceCorrectionParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyPepTTestParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyProtTTestParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyPepZTestParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyProtZTestParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyProfileClusteringParameter.getName(), this.m_parameterList.getPrefixName() + this.m_applyProfileClusteringParameter.getName()};
        Preferences preferences = NbPreferences.root();
        String[] keys = filePreferences.keys();
        ArrayList<String> thisQuantPtmIds = new ArrayList<String>();
        ArrayList<String> prefQuantPtmIds = new ArrayList<String>();
        for (BooleanParameter ptmToDiscardParameter : this.m_peptidesModificationListParameter) {
            String[] ptmId = (String[])ptmToDiscardParameter.getAssociatedData();
            thisQuantPtmIds.add(this.m_parameterList.getPrefixName() + "discardPeptideModification_" + ptmId);
        }
        boolean discardModifiedPeptides = false;
        String filePrefix = version.equals("1.0") ? (String)this.m_parameterList.getBackwardCompatiblePrefixes().get(0) : this.m_parameterList.getPrefixName();
        for (String key : keys) {
            String value;
            if (key.startsWith(filePrefix + "discardPeptideModification_")) {
                prefQuantPtmIds.add(key);
            }
            if (key.startsWith(filePrefix + QuantPostProcessingParams.getSettingKey((String)"discard_modified_peptides"))) {
                discardModifiedPeptides = filePreferences.getBoolean(key, false);
            } else if (key.startsWith(filePrefix + QuantPostProcessingParams.getSettingKey((String)"discard_oxidized_peptides"))) {
                discardModifiedPeptides = filePreferences.getBoolean(key, false);
            }
            if (!this.completeMode) {
                if (Arrays.asList(hiddenParams).contains(key)) {
                    filePreferences.remove(key);
                    continue;
                }
                value = filePreferences.get(key, null);
                preferences.put(key, value);
                continue;
            }
            value = filePreferences.get(key, null);
            preferences.put(key, value);
        }
        if (prefQuantPtmIds.size() >= thisQuantPtmIds.size()) {
            if (!prefQuantPtmIds.containsAll(thisQuantPtmIds)) {
                loadedPTMsParamsError = true;
            }
        } else {
            loadedPTMsParamsError = true;
        }
        if (loadedPTMsParamsError && discardModifiedPeptides) {
            JOptionPane.showMessageDialog(this, "Warning: PTMs to discard don't match current PTMs list", "Load Parameter ERROR", 0);
            String label = this.m_discardModifiedPeptidesChB.getText() + " (WARNING-PTMs: Read parameters don't match current list)";
            this.m_discardModifiedPeptidesChB.setText(label);
        }
        this.getParameterList().loadParameters(filePreferences);
        this.updateDiscardPTMs();
    }

    public ParameterList getParameterList() {
        this.m_discardPeptideIonsSharingPeakelsChB.setEnabled(true);
        return this.m_parameterList;
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.m_tabbedPane = new JTabbedPane();
        if (this.completeMode) {
            this.m_tabbedPane.addTab("Pep. selection", null, this.getPeptidesSelectionPanel(), "Specify peptides to consider for quantitation");
            this.m_tabbedPane.addTab("Pep. configuration", null, this.getQuantPeptidesConfigurationPanel(), "Parameters used for peptides quantitation");
            this.m_tabbedPane.addTab("Prot. configuration", null, this.getQuantProteinsConfigurationPanel(), "Parameters used for proteins quantitation");
        } else {
            this.m_tabbedPane.addTab("Pep. selection", null, this.getPeptidesSelectionPanel(), "Specify peptides to consider for quantitation");
            this.m_tabbedPane.addTab("Pep. configuration", null, this.getPeptidesConfigurationPanel(), "Parameters used for peptides quantitation");
            this.m_tabbedPane.addTab("Prot. configuration", null, this.getProteinsConfigurationPanel(), "Parameters used for proteins quantitation");
        }
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView(this.m_tabbedPane);
        this.m_scrollPane.createVerticalScrollBar();
        this.add((Component)this.m_scrollPane, "Center");
        this.updateDiscardPTMs();
    }

    private JPanel getPeptidesSelectionPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel pepSelectionPanel = new JPanel();
        pepSelectionPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        JLabel peptideSelectionMethodLabel = new JLabel(this.m_peptidesSelectionMethodParameter.getName() + ":");
        peptideSelectionMethodLabel.setHorizontalAlignment(4);
        pepSelectionPanel.add((Component)peptideSelectionMethodLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        pepSelectionPanel.add(this.m_peptidesSelectionMethodCB, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        pepSelectionPanel.add((Component)this.m_discardMissCleavedPeptidesChB, c);
        ++c.gridy;
        pepSelectionPanel.add((Component)this.m_discardModifiedPeptidesChB, c);
        c.insets = new Insets(5, 20, 5, 5);
        for (JCheckBox modifCB : this.m_peptideModificationListChB) {
            ++c.gridy;
            c.weightx = 0.5;
            pepSelectionPanel.add((Component)modifCB, c);
        }
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.m_modifiedPeptidesFilteringMethodLabel = new JLabel(this.m_modifiedPeptidesFilteringMethodParameter.getName() + ":");
        this.m_modifiedPeptidesFilteringMethodLabel.setHorizontalAlignment(4);
        pepSelectionPanel.add((Component)this.m_modifiedPeptidesFilteringMethodLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        pepSelectionPanel.add(this.m_modifiedPeptidesFilteringMethodCB, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        pepSelectionPanel.add((Component)this.m_discardPeptideIonsSharingPeakelsChB, c);
        northPanel.add((Component)pepSelectionPanel, "North");
        return northPanel;
    }

    private JPanel getQuantPeptidesConfigurationPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel pepQuantConfigPanel = new JPanel();
        pepQuantConfigPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        JLabel ionAbundanceSummarizerMethodLabel = new JLabel(this.m_pepIonsAbundanceSummarizingMethodParameter.getName());
        ionAbundanceSummarizerMethodLabel.setHorizontalAlignment(4);
        pepQuantConfigPanel.add((Component)ionAbundanceSummarizerMethodLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        pepQuantConfigPanel.add(this.m_peptideIonAbundanceSummarizingMethodCB, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        pepQuantConfigPanel.add((Component)this.m_applyPepNormalizationChB, c);
        ++c.gridy;
        pepQuantConfigPanel.add((Component)this.m_applyPepMissValInferenceChB, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        pepQuantConfigPanel.add((Component)new JLabel(this.m_peptideStatTestsAlphaParameter.getName()), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        pepQuantConfigPanel.add((Component)this.m_peptideStatTestsAlpha, c);
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        pepQuantConfigPanel.add((Component)this.m_applyPepTTestChB, c);
        this.m_applyPepTTestChB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuantPostProcessingPanel.this.m_applyPepVarianceCorrectionChB.setEnabled(QuantPostProcessingPanel.this.m_applyPepTTestChB.isSelected());
                if (!QuantPostProcessingPanel.this.m_applyPepTTestChB.isSelected()) {
                    QuantPostProcessingPanel.this.m_applyPepVarianceCorrectionChB.setSelected(false);
                }
            }
        });
        ++c.gridy;
        this.m_applyPepVarianceCorrectionChB.setEnabled(this.m_applyPepTTestChB.isSelected());
        if (!this.m_applyPepTTestChB.isSelected()) {
            this.m_applyPepVarianceCorrectionChB.setSelected(false);
        }
        pepQuantConfigPanel.add((Component)this.m_applyPepVarianceCorrectionChB, c);
        ++c.gridy;
        pepQuantConfigPanel.add((Component)this.m_applyPepZTestChB, c);
        northPanel.add((Component)pepQuantConfigPanel, "North");
        return northPanel;
    }

    private JPanel getPeptidesConfigurationPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel pepQuantConfigPanel = new JPanel();
        pepQuantConfigPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        JLabel ionAbundanceSummarizerMethodLabel = new JLabel(this.m_pepIonsAbundanceSummarizingMethodParameter.getName());
        ionAbundanceSummarizerMethodLabel.setHorizontalAlignment(4);
        pepQuantConfigPanel.add((Component)ionAbundanceSummarizerMethodLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        pepQuantConfigPanel.add(this.m_peptideIonAbundanceSummarizingMethodCB, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        pepQuantConfigPanel.add((Component)this.m_applyPepNormalizationChB, c);
        northPanel.add((Component)pepQuantConfigPanel, "North");
        return northPanel;
    }

    private JPanel getQuantProteinsConfigurationPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel protQuantConfigPanel = new JPanel();
        protQuantConfigPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        JLabel abundanceSummarizerMethodLabel = new JLabel(this.m_peptideAbundanceSummarizingMethodParameter.getName());
        abundanceSummarizerMethodLabel.setHorizontalAlignment(4);
        protQuantConfigPanel.add((Component)abundanceSummarizerMethodLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        protQuantConfigPanel.add(this.m_peptideAbundanceSummarizingMethodCB, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        protQuantConfigPanel.add((Component)this.m_applyProfileClusteringChB, c);
        ++c.gridy;
        protQuantConfigPanel.add((Component)this.m_applyProtNormalizationChB, c);
        ++c.gridy;
        protQuantConfigPanel.add((Component)this.m_applyProtMissValInferenceChB, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        protQuantConfigPanel.add((Component)new JLabel(this.m_proteinStatTestsAlphaParameter.getName()), c);
        ++c.gridx;
        c.weightx = 1.0;
        protQuantConfigPanel.add((Component)this.m_proteinStatTestsAlpha, c);
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        protQuantConfigPanel.add((Component)this.m_applyProtTTestChB, c);
        this.m_applyProtTTestChB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuantPostProcessingPanel.this.m_applyProtVarianceCorrectionChB.setEnabled(QuantPostProcessingPanel.this.m_applyProtTTestChB.isSelected());
            }
        });
        ++c.gridy;
        this.m_applyProtVarianceCorrectionChB.setEnabled(this.m_applyProtTTestChB.isSelected());
        protQuantConfigPanel.add((Component)this.m_applyProtVarianceCorrectionChB, c);
        ++c.gridy;
        protQuantConfigPanel.add((Component)this.m_applyProtZTestChB, c);
        northPanel.add((Component)protQuantConfigPanel, "North");
        return northPanel;
    }

    private JPanel getProteinsConfigurationPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel protQuantConfigPanel = new JPanel();
        protQuantConfigPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        JLabel abundanceSummarizerMethodLabel = new JLabel(this.m_peptideAbundanceSummarizingMethodParameter.getName());
        abundanceSummarizerMethodLabel.setHorizontalAlignment(4);
        protQuantConfigPanel.add((Component)abundanceSummarizerMethodLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        protQuantConfigPanel.add(this.m_peptideAbundanceSummarizingMethodCB, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        protQuantConfigPanel.add((Component)this.m_applyProtNormalizationChB, c);
        northPanel.add((Component)protQuantConfigPanel, "North");
        return northPanel;
    }

    public Map<String, Object> getQuantParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("config_version", "3.0");
        params.put("discard_miss_cleaved_peptides", this.m_discardMissCleavedPeptidesChB.isSelected());
        params.put("discard_modified_peptides", this.m_discardModifiedPeptidesChB.isSelected());
        params.put("pep_ion_abundance_summarizing_method", QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodKeys()[this.m_peptideIonAbundanceSummarizingMethodCB.getSelectedIndex()]);
        params.put("peptides_selection_method", QuantPostProcessingParams.getPeptidesSelectionMethodKeys()[this.m_peptidesSelectionMethodCB.getSelectedIndex()]);
        HashMap modifiedPeptideFilterConfigMap = new HashMap();
        ArrayList<Long> ptmIds = new ArrayList<Long>();
        for (BooleanParameter ptmToDiscardParameter : this.m_peptidesModificationListParameter) {
            if (!((JCheckBox)ptmToDiscardParameter.getComponent()).isSelected()) continue;
            Long ptmId = (Long)ptmToDiscardParameter.getAssociatedData();
            ptmIds.add(ptmId);
        }
        modifiedPeptideFilterConfigMap.put("ptm_definition_ids_to_discard", ptmIds);
        params.put("modified_peptide_filter_config", modifiedPeptideFilterConfigMap);
        params.put("modified_peptide_filtering_method", QuantPostProcessingParams.getModifiedPeptideFilteringMethodKeys()[this.m_modifiedPeptidesFilteringMethodCB.getSelectedIndex()]);
        params.put("discard_pep_ions_sharing_peakels", this.m_discardPeptideIonsSharingPeakelsChB.isSelected());
        params.put("peptide_abundance_summarizing_method", QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodKeys()[this.m_peptideAbundanceSummarizingMethodCB.getSelectedIndex()]);
        params.put("apply_profile_clustering", this.m_applyProfileClusteringChB.isSelected());
        HashMap<String, Object> peptideStatConfigMap = new HashMap<String, Object>();
        peptideStatConfigMap.put("stat_tests_alpha", this.m_peptideStatTestsAlpha.getText());
        peptideStatConfigMap.put("apply_normalization", this.m_applyPepNormalizationChB.isSelected());
        peptideStatConfigMap.put("apply_miss_val_inference", this.m_applyPepMissValInferenceChB.isSelected());
        peptideStatConfigMap.put("apply_variance_correction", this.m_applyPepVarianceCorrectionChB.isSelected());
        peptideStatConfigMap.put("apply_ttest", this.m_applyPepTTestChB.isSelected());
        peptideStatConfigMap.put("apply_ztest", this.m_applyPepZTestChB.isSelected());
        params.put(QuantPostProcessingParams.getPrefixedParam((String)"peptide", (String)"stat_config"), peptideStatConfigMap);
        HashMap<String, Object> proteinStatConfigMap = new HashMap<String, Object>();
        proteinStatConfigMap.put("stat_tests_alpha", this.m_proteinStatTestsAlpha.getText());
        proteinStatConfigMap.put("apply_normalization", this.m_applyProtNormalizationChB.isSelected());
        proteinStatConfigMap.put("apply_miss_val_inference", this.m_applyProtMissValInferenceChB.isSelected());
        proteinStatConfigMap.put("apply_variance_correction", this.m_applyProtVarianceCorrectionChB.isSelected());
        proteinStatConfigMap.put("apply_ttest", this.m_applyProtTTestChB.isSelected());
        proteinStatConfigMap.put("apply_ztest", this.m_applyProtZTestChB.isSelected());
        params.put(QuantPostProcessingParams.getPrefixedParam((String)"protein", (String)"stat_config"), proteinStatConfigMap);
        return params;
    }

    public void setRefinedParams(Map<String, Object> refinedParams) {
        boolean useOnlySpecificPeptides;
        boolean isVersion3 = false;
        boolean isVersion2 = false;
        boolean isVersion1 = false;
        String version = (String)refinedParams.get("config_version");
        Object isDiscardModifiedPeptide = refinedParams.get("discard_modified_peptides");
        if (version == null) {
            isVersion1 = true;
        } else if ("2.0".equals(version)) {
            isVersion2 = true;
        } else {
            isVersion3 = true;
        }
        String selectionMethod = "";
        selectionMethod = isVersion3 ? (String)refinedParams.getOrDefault("peptides_selection_method", "ALL_PEPTIDES") : ((useOnlySpecificPeptides = Boolean.valueOf(refinedParams.getOrDefault("use_only_specific_peptides", "false").toString()).booleanValue()) ? "SPECIFIC" : "ALL_PEPTIDES");
        String[] pepSelectionMethodKeys = QuantPostProcessingParams.getPeptidesSelectionMethodKeys();
        int index = 0;
        for (int i = 0; i < pepSelectionMethodKeys.length; ++i) {
            if (!pepSelectionMethodKeys[i].equals(selectionMethod)) continue;
            index = i;
            break;
        }
        this.m_peptidesSelectionMethodCB.setSelectedIndex(index);
        Object isDmcPep = isVersion1 ? refinedParams.getOrDefault("discard_missed_cleaved_peptides", "false") : refinedParams.getOrDefault("discard_miss_cleaved_peptides", "false");
        this.m_discardMissCleavedPeptidesChB.setSelected(Boolean.valueOf(isDmcPep.toString()));
        boolean isV1DiscardOxidPepSelected = false;
        if (isVersion1) {
            isV1DiscardOxidPepSelected = Boolean.valueOf(refinedParams.get("discard_oxidized_peptides").toString());
            this.m_discardModifiedPeptidesChB.setSelected(isV1DiscardOxidPepSelected);
            this.m_modifiedPeptidesFilteringMethodLabel.setEnabled(false);
        } else {
            this.m_discardModifiedPeptidesChB.setSelected(Boolean.valueOf(isDiscardModifiedPeptide.toString()));
        }
        ArrayList ptmIdListFromParam = null;
        if (isVersion2) {
            ptmIdListFromParam = (ArrayList)refinedParams.get("ptm_definition_ids_to_discard");
        } else if (isVersion3) {
            Map modifiedPeptideFilterConfigMap = (Map)refinedParams.get("modified_peptide_filter_config");
            ptmIdListFromParam = (ArrayList)modifiedPeptideFilterConfigMap.get("ptm_definition_ids_to_discard");
        }
        ArrayList<Long> ptmIdList = new ArrayList<Long>();
        if (ptmIdListFromParam != null) {
            for (Object l : ptmIdListFromParam) {
                ptmIdList.add(Long.parseLong("" + l));
            }
        } else if (isV1DiscardOxidPepSelected) {
            ptmIdList = new ArrayList();
            for (Long id : this.m_ptmSpecificityNameById.keySet()) {
                if (!this.m_ptmSpecificityNameById.get(id).contains("Oxidation")) continue;
                ptmIdList.add(id);
            }
        }
        for (BooleanParameter ptmToDiscardParameter : this.m_peptidesModificationListParameter) {
            JCheckBox ptmChB = (JCheckBox)ptmToDiscardParameter.getComponent();
            Long ptmId = (Long)ptmToDiscardParameter.getAssociatedData();
            if (ptmIdList.contains(ptmId)) {
                ptmChB.setSelected(true);
                continue;
            }
            ptmChB.setSelected(false);
        }
        String pmfMethod = isVersion1 ? "" : (String)refinedParams.get("modified_peptide_filtering_method");
        index = 0;
        String[] modifPepFilteringMethodKeys = QuantPostProcessingParams.getModifiedPeptideFilteringMethodKeys();
        for (int i = 0; i < modifPepFilteringMethodKeys.length; ++i) {
            if (!modifPepFilteringMethodKeys[i].equals(pmfMethod)) continue;
            index = i;
            break;
        }
        this.m_modifiedPeptidesFilteringMethodCB.setSelectedIndex(index);
        Boolean discardSharingPeakel = isVersion3 ? Boolean.valueOf(refinedParams.get("discard_pep_ions_sharing_peakels").toString()) : Boolean.valueOf(refinedParams.get("discard_peptides_sharing_peakels").toString());
        this.m_discardPeptideIonsSharingPeakelsChB.setSelected(discardSharingPeakel);
        String[] abundanceSummarizingMethodKeys = QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodKeys();
        String summarisedMethodKey = isVersion3 ? (String)refinedParams.get("peptide_abundance_summarizing_method") : (String)refinedParams.get("abundance_summarizing_method");
        index = 0;
        for (int i = 0; i < abundanceSummarizingMethodKeys.length; ++i) {
            if (!abundanceSummarizingMethodKeys[i].equals(summarisedMethodKey)) continue;
            index = i;
            break;
        }
        this.m_peptideAbundanceSummarizingMethodCB.setSelectedIndex(index);
        String ionPepSummarisingMethodKey = isVersion1 ? "BEST_ION" : (String)refinedParams.getOrDefault("pep_ion_abundance_summarizing_method", "BEST_ION");
        String[] ionAbundanceSummarizingMethodKeys = QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodKeys();
        index = 0;
        for (int i = 0; i < ionAbundanceSummarizingMethodKeys.length; ++i) {
            if (!ionAbundanceSummarizingMethodKeys[i].equals(ionPepSummarisingMethodKey)) continue;
            index = i;
            break;
        }
        this.m_peptideIonAbundanceSummarizingMethodCB.setSelectedIndex(index);
        this.m_applyProfileClusteringChB.setSelected(Boolean.valueOf(refinedParams.get("apply_profile_clustering").toString()));
        Map peptideStatConfigMap = (Map)refinedParams.get(QuantPostProcessingParams.getPrefixedParam((String)"peptide", (String)"stat_config"));
        this.m_peptideStatTestsAlpha.setText(peptideStatConfigMap.get("stat_tests_alpha").toString());
        this.m_applyPepNormalizationChB.setSelected(Boolean.valueOf(peptideStatConfigMap.get("apply_normalization").toString()));
        this.m_applyPepMissValInferenceChB.setSelected(Boolean.valueOf(peptideStatConfigMap.get("apply_miss_val_inference").toString()));
        this.m_applyPepVarianceCorrectionChB.setSelected(Boolean.valueOf(peptideStatConfigMap.get("apply_variance_correction").toString()));
        this.m_applyPepTTestChB.setSelected(Boolean.valueOf(peptideStatConfigMap.get("apply_ttest").toString()));
        this.m_applyPepZTestChB.setSelected(Boolean.valueOf(peptideStatConfigMap.get("apply_ztest").toString()));
        Map proteinStatConfigMap = (Map)refinedParams.get(QuantPostProcessingParams.getPrefixedParam((String)"protein", (String)"stat_config"));
        this.m_proteinStatTestsAlpha.setText(proteinStatConfigMap.get("stat_tests_alpha").toString());
        this.m_applyProtNormalizationChB.setSelected(Boolean.valueOf(proteinStatConfigMap.get("apply_normalization").toString()));
        this.m_applyProtMissValInferenceChB.setSelected(Boolean.valueOf(proteinStatConfigMap.get("apply_miss_val_inference").toString()));
        this.m_applyProtVarianceCorrectionChB.setSelected(Boolean.valueOf(proteinStatConfigMap.get("apply_variance_correction").toString()));
        this.m_applyProtTTestChB.setSelected(Boolean.valueOf(proteinStatConfigMap.get("apply_ttest").toString()));
        this.m_applyProtZTestChB.setSelected(Boolean.valueOf(proteinStatConfigMap.get("apply_ztest").toString()));
        this.updateDiscardPTMs();
    }

    public void setDiscardPeptidesSharingPeakelsChB(boolean isAggregation) {
        if (isAggregation) {
            this.m_discardPeptideIonsSharingPeakelsChB.setSelected(false);
        }
        this.m_discardPeptideIonsSharingPeakelsChB.setEnabled(!isAggregation);
    }
}

