/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.uds.QuantitationLabel;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractParamsPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.PtmSpecificityRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ResidueMethodParamsPanel
extends AbstractParamsPanel {
    private final QuantitationMethod m_quantMethod;
    private final List<PtmSpecificity> m_ptms;
    private Map<QuantitationLabel, List<JComboBox<PtmSpecificity>>> m_comboBoxesByTags;

    public ResidueMethodParamsPanel(QuantitationMethod method, List<PtmSpecificity> ptms) {
        this.m_quantMethod = method;
        this.m_ptms = ptms;
        this.setLayout(new BorderLayout());
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Residue Labeling parameters"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.m_comboBoxesByTags = new HashMap<QuantitationLabel, List<JComboBox<PtmSpecificity>>>();
        for (QuantitationLabel label : this.m_quantMethod.getLabels()) {
            JLabel jLabel = new JLabel(label.getName() + ":");
            final JComboBox<PtmSpecificity> combo1 = new JComboBox<PtmSpecificity>(this.m_ptms.toArray(new PtmSpecificity[0]));
            final JComboBox<PtmSpecificity> combo2 = new JComboBox<PtmSpecificity>(this.m_ptms.toArray(new PtmSpecificity[0]));
            ArrayList<JComboBox<PtmSpecificity>> list = new ArrayList<JComboBox<PtmSpecificity>>();
            list.add(combo1);
            list.add(combo2);
            this.m_comboBoxesByTags.put(label, list);
            combo1.setRenderer(new PtmSpecificityRenderer());
            combo2.setRenderer(new PtmSpecificityRenderer());
            panel.add((Component)jLabel, c);
            ++c.gridx;
            JButton button = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL7));
            button.setMargin(new Insets(2, 2, 2, 2));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean visibility = !combo1.isVisible();
                    combo1.setVisible(visibility);
                    if (visibility) {
                        ((JButton)e.getSource()).setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL7));
                    } else {
                        ((JButton)e.getSource()).setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS));
                    }
                }
            });
            panel.add((Component)button, c);
            ++c.gridx;
            panel.add(combo1, c);
            ++c.gridx;
            button = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS));
            button.setMargin(new Insets(2, 2, 2, 2));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean visibility = !combo2.isVisible();
                    combo2.setVisible(visibility);
                    if (visibility) {
                        ((JButton)e.getSource()).setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL7));
                    } else {
                        ((JButton)e.getSource()).setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS));
                    }
                }
            });
            panel.add((Component)button, c);
            ++c.gridx;
            panel.add(combo2, c);
            combo2.setVisible(false);
            ++c.gridx;
            c.weightx = 500.0;
            c.fill = 2;
            panel.add(Box.createHorizontalGlue(), c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
        }
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        panel.add(Box.createGlue(), c);
        return panel;
    }

    @Override
    public Map<String, Object> getQuantParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList tags = new ArrayList();
        for (Map.Entry<QuantitationLabel, List<JComboBox<PtmSpecificity>>> e : this.m_comboBoxesByTags.entrySet()) {
            HashMap<String, Serializable> labelParams = new HashMap<String, Serializable>();
            ArrayList<Long> ptmsIds = new ArrayList<Long>();
            for (JComboBox<PtmSpecificity> combo : e.getValue()) {
                if (!combo.isVisible() || combo.getSelectedItem() == null) continue;
                ptmsIds.add(((PtmSpecificity)combo.getSelectedItem()).getId());
            }
            labelParams.put("tag_id", Long.valueOf(e.getKey().getId()));
            labelParams.put("ptm_specificity_ids", ptmsIds);
            tags.add(labelParams);
        }
        params.put("tags", tags);
        params.put("label_free_quant_config", true);
        return params;
    }

    @Override
    public void setQuantParams(Map<String, Object> quantParams) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

