/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMGraphicCtrlPanel;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMPeptidesGraphicModel;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewContext;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import fr.proline.studio.rsmexplorer.gui.ptm.mark.PTMMarkCtrl;
import fr.proline.studio.rsmexplorer.gui.ptm.mark.ProteinSequence;
import fr.proline.studio.rsmexplorer.gui.ptm.pep.PeptideAreaCtrl;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMPeptidesGraphicView
extends JPanel {
    private static Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    protected AbstractDataBox m_dataBox;
    private PTMPeptidesGraphicPanel m_internalPanel;
    private PTMPeptidesGraphicModel m_dataModel;
    private PTMGraphicCtrlPanel m_superCtrl = null;

    public void setSuperCtrl(PTMGraphicCtrlPanel superCtrl) {
        this.m_superCtrl = superCtrl;
    }

    public void setScrollLocation(int ajustedLocation) {
        this.m_internalPanel.setHorizonScrollLocation(ajustedLocation);
        this.repaint();
    }

    public void setViewPosition(int sequencePosition) {
        this.m_internalPanel.setHorizonScrollLocation(sequencePosition);
        this.repaint();
    }

    public void setProteinSequence(String sequence) {
        this.m_internalPanel.m_dataModel.setProteinSequence(sequence);
        this.m_internalPanel.updateData();
    }

    public PTMPeptidesGraphicView(boolean showClustersData) {
        this.m_internalPanel = new PTMPeptidesGraphicPanel(showClustersData);
        this.m_dataModel = new PTMPeptidesGraphicModel();
        this.m_internalPanel.setModel(this.m_dataModel);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.m_internalPanel.setSize(-29, 2);
        this.add((Component)this.m_internalPanel, "Center");
    }

    public void setSelectedRow(int i) {
        this.m_internalPanel.setSelectedPeptideIndex(i);
    }

    public void setSelectedPTMPeptide(PTMPeptideInstance pep) {
        int row = this.m_dataModel.getPeptideIndex(pep);
        this.m_internalPanel.setSelectedPeptideIndex(row);
        this.repaint();
    }

    public PTMPeptideInstance getSelectedPTMPeptideInstance() {
        int selectedRowIndex = this.m_internalPanel.getSelectedPeptideIndex();
        if (this.m_dataModel.getRowCount() > 0 && selectedRowIndex < this.m_dataModel.getRowCount()) {
            return this.m_dataModel.getPeptideAt(selectedRowIndex);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.m_internalPanel.getSelectedPeptideIndex();
    }

    public PTMSite getMainPTMSite() {
        return this.m_dataModel.getMainPTMSite();
    }

    public void setData(List<PTMPeptideInstance> peptidesInstances) {
        this.m_dataModel.setData(peptidesInstances, this.m_dataBox.getProjectId());
        if (peptidesInstances == null) {
            this.m_internalPanel.clean();
        } else {
            this.m_internalPanel.updateData();
            this.m_dataBox.addDataChanged(PTMPeptideInstance.class, null);
            this.m_dataBox.propagateDataChanged();
        }
        this.setScrollLocation(this.m_dataModel.getLowerStartInProtSeq());
        this.repaint();
    }

    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    public String getSequence() {
        return this.m_dataModel.getProteinSequence();
    }

    private class PTMPeptidesGraphicPanel
    extends JPanel {
        private static final int INITIAL_WIDTH = 1200;
        private static final int AJUSTE_GAP = 3;
        private PTMPeptidesGraphicModel m_dataModel = null;
        private JScrollPane m_scrollPane;
        private final TitlePane m_titlePane;
        private final PeptidePane m_peptidesPane;
        private final PeptideNumberPane m_peptidesNumberPane;
        private int m_sequenceLength;
        private boolean m_isDataNull;
        PeptideAreaCtrl m_peptideAreaCtrl = new PeptideAreaCtrl();

        public PTMPeptidesGraphicPanel(boolean showClusterData) {
            PTMMarkCtrl ctrlMark = new PTMMarkCtrl();
            ProteinSequence ctrlSequence = new ProteinSequence();
            this.m_titlePane = new TitlePane(ctrlMark, ctrlSequence);
            this.m_peptidesPane = new PeptidePane();
            this.m_peptidesNumberPane = showClusterData ? new ColoredClusterMarkPane() : new PeptideNumberPane();
            this.m_sequenceLength = 0;
            this.initComponents();
        }

        private void initComponents() {
            this.setDoubleBuffered(false);
            this.m_titlePane.setMarkBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
            this.m_titlePane.setSequenceBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.HEIGHT_MARK);
            this.m_peptidesPane.setBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
            this.m_peptidesNumberPane.setBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
            this.m_titlePane.setPreferredSize(new Dimension(1200, ViewSetting.HEIGHT_MARK + ViewSetting.HEIGHT_SEQUENCE));
            this.m_titlePane.setBackground(Color.WHITE);
            this.m_peptidesPane.setBackground(Color.WHITE);
            this.m_titlePane.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, CyclicColorPalette.GRAY_GRID));
            this.m_peptidesPane.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, CyclicColorPalette.GRAY_GRID));
            this.m_scrollPane = new JScrollPane(this.m_peptidesPane, 20, 30);
            this.m_scrollPane.setColumnHeaderView(this.m_titlePane);
            this.m_scrollPane.setRowHeaderView(this.m_peptidesNumberPane);
            this.m_scrollPane.setBackground(Color.white);
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_scrollPane, "Center");
        }

        public void setModel(PTMPeptidesGraphicModel dataModel) {
            this.m_dataModel = dataModel;
        }

        private void setHorizonScrollLocation(int ajustedLocation) {
            JScrollBar bar = this.m_scrollPane.getHorizontalScrollBar();
            int max = bar.getMaximum();
            int visibleAmount = bar.getVisibleAmount();
            int x = (int)((float)max / (float)this.m_sequenceLength * (float)((ajustedLocation -= (int)Math.round((double)this.m_sequenceLength * (double)(visibleAmount / 2) / (double)max)) - 3));
            bar.setValue(x);
        }

        private void setViewPosition(int ajustedLocation, int peptideIndex) {
            JViewport jvp = this.m_scrollPane.getViewport();
            Rectangle visibleRec = jvp.getVisibleRect();
            Point vp = jvp.getViewPosition();
            int x = ajustedLocation * ViewSetting.WIDTH_AA;
            int y = peptideIndex * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
            Point p = new Point(x, y);
            if (Math.abs(vp.x - p.x) > visibleRec.width || Math.abs(vp.y - p.y) > visibleRec.height) {
                jvp.setViewPosition(p);
            }
        }

        @Override
        public void paint(Graphics g) {
            this.m_scrollPane.getViewport().revalidate();
            super.paint(g);
        }

        protected int getSelectedPeptideIndex() {
            return this.m_peptideAreaCtrl.getSelectedIndex();
        }

        protected void clean() {
            this.m_isDataNull = true;
        }

        protected void setSelectedPeptideIndex(int i) {
            this.m_peptideAreaCtrl.setSelectedIndex(i);
        }

        protected void updateData() {
            this.m_titlePane.updateData();
            this.m_peptidesPane.updateData();
            this.m_isDataNull = false;
            this.m_sequenceLength = this.m_dataModel.getProteinSequence().length();
        }

        private void selectedAction(int selectedIndex, int oldSelected) {
            if (selectedIndex >= 0 && selectedIndex < this.m_dataModel.getRowCount()) {
                PTMPeptideInstance pep = this.m_dataModel.getPeptideAt(selectedIndex);
                PTMPeptideInstance oldPep = this.m_dataModel.getPeptideAt(oldSelected);
                if (pep != null) {
                    if (oldPep != null) {
                        if (Math.abs(oldPep.getStartPosition() - pep.getStartPosition()) > 3) {
                            this.setHorizonScrollLocation(pep.getStartPosition());
                        }
                    } else {
                        this.setHorizonScrollLocation(pep.getStartPosition());
                    }
                }
                this.m_peptideAreaCtrl.setSelectedIndex(selectedIndex);
                if (selectedIndex != oldSelected && selectedIndex != -1 && PTMPeptidesGraphicView.this.m_dataBox != null) {
                    if (PTMPeptidesGraphicView.this.m_superCtrl != null) {
                        PTMPeptidesGraphicView.this.m_superCtrl.onMessage(PTMGraphicCtrlPanel.Source.PEPTIDE_AREA, PTMGraphicCtrlPanel.Message.SELECTED);
                    }
                    PTMPeptidesGraphicView.this.m_dataBox.addDataChanged(PTMPeptideInstance.class, null);
                    PTMPeptidesGraphicView.this.m_dataBox.propagateDataChanged();
                    this.repaint();
                }
            }
        }

        private class ColoredClusterMarkPane
        extends PeptideNumberPane {
            private Map<PTMCluster, Color> PTM_CLUSTER_COLORS;
            private Map<PTMCluster, String> PTM_CLUSTER_ID;
            int m_x0;
            int m_y0;

            private ColoredClusterMarkPane() {
                this.PTM_CLUSTER_COLORS = new HashMap<PTMCluster, Color>();
                this.PTM_CLUSTER_ID = new HashMap<PTMCluster, String>();
                this.setBackground(Color.WHITE);
                ScrollPaneRowHeaderMouseAdapter coloredTooltips = new ScrollPaneRowHeaderMouseAdapter();
                this.addMouseMotionListener(coloredTooltips);
                this.addMouseListener(coloredTooltips);
            }

            public Color getColor(PTMCluster cluster) {
                Color c = this.PTM_CLUSTER_COLORS.get(cluster);
                if (c == null) {
                    Color co = CyclicColorPalette.getColorBlue((int)this.PTM_CLUSTER_COLORS.size());
                    int rgb = co.getRGB() | 0xFF000000;
                    c = new Color(rgb & 0xFFFFFF);
                    this.PTM_CLUSTER_COLORS.put(cluster, c);
                    String s = String.valueOf(cluster.getId());
                    this.PTM_CLUSTER_ID.put(cluster, s);
                }
                return c;
            }

            @Override
            public void setBeginPoint(int x, int y) {
                this.m_x0 = x;
                this.m_y0 = y;
            }

            @Override
            public Dimension getPreferredSize() {
                int width = ViewSetting.WIDTH_AA + 2 * ViewSetting.BORDER_GAP;
                int height = PTMPeptidesGraphicPanel.this.m_dataModel.getRowCount() * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
                if (height == 0) {
                    height = 5 * ViewSetting.HEIGHT_AA;
                }
                return new Dimension(width, height);
            }

            @Override
            protected void paintComponent(Graphics g) {
                if (!PTMPeptidesGraphicPanel.this.m_isDataNull) {
                    this.PTM_CLUSTER_COLORS = new HashMap<PTMCluster, Color>();
                    this.PTM_CLUSTER_ID = new HashMap<PTMCluster, String>();
                    Graphics2D g2 = (Graphics2D)g;
                    FontMetrics f = g2.getFontMetrics(ViewSetting.FONT_NUMBER);
                    int ascend = f.getAscent();
                    int y0 = this.m_y0;
                    g2.setFont(ViewSetting.FONT_NUMBER);
                    int rowCount = PTMPeptidesGraphicPanel.this.m_dataModel.getRowCount();
                    for (int i = 1; i < rowCount + 1; ++i) {
                        PTMPeptideInstance item = PTMPeptidesGraphicPanel.this.m_dataModel.getPeptideAt(i - 1);
                        List clusters = item.getClusters();
                        int size = clusters.size();
                        int xi0 = this.m_x0;
                        int colorWidth = ViewSetting.WIDTH_AA / size;
                        for (int j = 0; j < size; ++j) {
                            int xi;
                            xi0 = xi = xi0 + colorWidth * j;
                            PTMCluster cluster = (PTMCluster)clusters.get(j);
                            g2.setColor(this.getColor(cluster));
                            g2.fillRect(xi0, y0, colorWidth, ViewSetting.WIDTH_AA);
                        }
                        String colorId = this.PTM_CLUSTER_ID.get(clusters.get(0));
                        int stringWidth = f.stringWidth(colorId);
                        int x0 = this.m_x0 + (ViewSetting.WIDTH_AA - stringWidth) / 2;
                        g2.setColor(Color.WHITE);
                        g2.drawString(colorId, x0, y0 + ascend);
                        y0 = (int)((double)y0 + (double)ViewSetting.HEIGHT_AA * 1.5);
                    }
                }
            }

            class ScrollPaneRowHeaderMouseAdapter
            extends MouseAdapter {
                ScrollPaneRowHeaderMouseAdapter() {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    PTMPeptideInstance pep;
                    int x = e.getX();
                    int y = e.getY();
                    StringBuilder tips = new StringBuilder();
                    int index = (int)((double)(y - ColoredClusterMarkPane.this.m_y0) / ((double)ViewSetting.HEIGHT_AA * 1.5));
                    if (index >= 0 && index < PTMPeptidesGraphicPanel.this.m_dataModel.getRowCount() && (pep = PTMPeptidesGraphicPanel.this.m_dataModel.getPeptideAt(index)) != null) {
                        List clusters = pep.getClusters();
                        int size = clusters.size();
                        tips.append("<html>").append("<body>Clusters: ");
                        for (int j = 0; j < size; ++j) {
                            PTMCluster cluster = (PTMCluster)clusters.get(j);
                            String htmlColor = CyclicColorPalette.getHTMLColoredBlock((Color)ColoredClusterMarkPane.this.getColor(cluster));
                            tips.append(htmlColor).append((String)ColoredClusterMarkPane.this.PTM_CLUSTER_ID.get(cluster)).append(' ');
                        }
                        tips.append("</body>").append("</html>");
                    }
                    ColoredClusterMarkPane.this.setToolTipText(tips.toString());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    int oldSelected = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex();
                    int selectedIndex = (int)((double)(y - ColoredClusterMarkPane.this.m_y0) / ((double)ViewSetting.HEIGHT_AA * 1.5));
                    PTMPeptidesGraphicPanel.this.selectedAction(selectedIndex, oldSelected);
                }
            }
        }

        private class PeptideNumberPane
        extends JPanel {
            int m_x0;
            int m_y0;

            private PeptideNumberPane() {
                this.setBackground(Color.WHITE);
            }

            public void setBeginPoint(int x, int y) {
                this.m_x0 = x;
                this.m_y0 = y;
            }

            @Override
            public Dimension getPreferredSize() {
                int width = ViewSetting.WIDTH_AA + 2 * ViewSetting.BORDER_GAP;
                int height = PTMPeptidesGraphicPanel.this.m_dataModel.getRowCount() * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
                if (height == 0) {
                    height = 5 * ViewSetting.HEIGHT_AA;
                }
                return new Dimension(width, height);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (!PTMPeptidesGraphicPanel.this.m_isDataNull) {
                    Graphics2D g2 = (Graphics2D)g;
                    FontMetrics f = g2.getFontMetrics(ViewSetting.FONT_NUMBER);
                    int ascend = f.getAscent();
                    int y0 = this.m_y0 + ascend;
                    g2.setColor(Color.black);
                    g2.setFont(ViewSetting.FONT_NUMBER);
                    int rowCount = PTMPeptidesGraphicPanel.this.m_dataModel.getRowCount();
                    for (int i = 1; i < rowCount + 1; ++i) {
                        String number = String.valueOf(i);
                        int stringWidth = f.stringWidth(number);
                        int x0 = this.m_x0 + ViewSetting.WIDTH_AA - stringWidth;
                        g2.drawString("" + i, x0, y0);
                        y0 = (int)((double)y0 + (double)ViewSetting.HEIGHT_AA * 1.5);
                    }
                }
            }
        }

        private class PeptidePane
        extends JPanel {
            private PeptidePane() {
                PeptideAreaMouseAdapter mouseAdapter = new PeptideAreaMouseAdapter();
                this.addMouseListener(mouseAdapter);
                this.addMouseMotionListener(mouseAdapter);
                this.addKeyListener(new PeptideAreaKeyAdapter());
            }

            public void updateData() {
                PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setPTMPepInstanceData(PTMPeptidesGraphicPanel.this.m_dataModel.getPTMPeptideInstance());
                PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setSelectedIndex(0);
            }

            public void setBeginPoint(int x, int y) {
                PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setBeginPoint(x, y);
            }

            @Override
            public Dimension getPreferredSize() {
                int width = (PTMPeptidesGraphicPanel.this.m_sequenceLength + 3) * ViewSetting.WIDTH_AA;
                int height = PTMPeptidesGraphicPanel.this.m_dataModel.getRowCount() * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
                if (height == 0) {
                    height = 5 * ViewSetting.HEIGHT_AA;
                }
                return new Dimension(width, height);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (!PTMPeptidesGraphicPanel.this.m_isDataNull) {
                    ViewContext viewContext = new ViewContext();
                    viewContext.setAreaWidth(this.getWidth());
                    Graphics2D g2 = (Graphics2D)g;
                    PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.paint(g2, viewContext);
                }
            }

            class PeptideAreaMouseAdapter
            extends MouseAdapter {
                PeptideAreaMouseAdapter() {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    PeptidePane.this.requestFocusInWindow();
                    int oldSelected = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex();
                    int selectedIndex = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex(e.getX(), e.getY());
                    PTMPeptidesGraphicPanel.this.selectedAction(selectedIndex, oldSelected);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    String tips = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getToolTipText(x, y);
                    PeptidePane.this.setToolTipText(tips);
                }
            }

            class PeptideAreaKeyAdapter
            extends KeyAdapter {
                @Override
                public void keyPressed(KeyEvent evt) {
                    int oldSelected = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex();
                    if (evt.getKeyCode() == 38) {
                        PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setRelativeSelected(-1);
                    } else if (evt.getKeyCode() == 40) {
                        PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setRelativeSelected(1);
                    }
                    int selectedIndex = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex();
                    PTMPeptidesGraphicPanel.this.selectedAction(selectedIndex, oldSelected);
                }
            }
        }

        private class TitlePane
        extends JPanel {
            private PTMMarkCtrl m_ctrlMark;
            private ProteinSequence m_ctrlSequence;

            private TitlePane(PTMMarkCtrl ctrlMark, ProteinSequence ctrlSequence) {
                this.m_ctrlMark = ctrlMark;
                this.m_ctrlSequence = ctrlSequence;
                this.addMouseMotionListener(new MouseAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        int x = e.getX();
                        int y = e.getY();
                        String tips = TitlePane.this.m_ctrlMark.getToolTipText(x, y);
                        TitlePane.this.setToolTipText(tips);
                    }
                });
            }

            public void updateData() {
                this.m_ctrlSequence.setData(PTMPeptidesGraphicPanel.this.m_dataModel.getProteinSequence());
                if (PTMPeptidesGraphicPanel.this.m_dataModel.getMainPTMSite() != null) {
                    this.m_ctrlSequence.setPTMSequencePosition(PTMPeptidesGraphicPanel.this.m_dataModel.getMainPTMSite().getPositionOnProtein());
                } else {
                    this.m_ctrlSequence.setPTMSequencePosition(-1);
                }
                this.m_ctrlMark.setData(PTMPeptidesGraphicPanel.this.m_dataModel.getAllPtmMarks());
            }

            public void setMarkBeginPoint(int x, int y) {
                this.m_ctrlMark.setBeginPoint(x, y);
            }

            public void setSequenceBeginPoint(int x, int y) {
                this.m_ctrlSequence.setBeginPoint(x, y);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((PTMPeptidesGraphicPanel.this.m_sequenceLength + 3) * ViewSetting.WIDTH_AA, ViewSetting.HEIGHT_MARK + ViewSetting.HEIGHT_SEQUENCE);
            }

            @Override
            protected void paintComponent(Graphics g) {
                this.isPaintingOrigin();
                super.paintComponent(g);
                if (!PTMPeptidesGraphicPanel.this.m_isDataNull) {
                    ViewContext viewContext = new ViewContext();
                    viewContext.setShowNCtermIndex(false);
                    Graphics2D g2 = (Graphics2D)g;
                    this.m_ctrlMark.paint(g2, viewContext);
                    this.m_ctrlSequence.paint(g2, viewContext);
                }
            }
        }
    }
}

