/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm.mark;

import fr.proline.studio.rsmexplorer.gui.ptm.ViewContext;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewPtmAbstract;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class ProteinSequence
extends ViewPtmAbstract {
    String m_sequence;
    private int m_ptmSeqPos;

    public ProteinSequence() {
        this.x0 = 0;
        this.y0 = 0;
    }

    public void setData(String s) {
        this.m_sequence = s;
    }

    @Override
    public void setBeginPoint(int x, int y) {
        this.x0 = x;
        this.y0 = y;
    }

    @Override
    public void paint(Graphics2D g, ViewContext viewContext) {
        if (this.m_sequence == null) {
            return;
        }
        int aaWidth = ViewSetting.WIDTH_AA;
        int aaHeight = ViewSetting.HEIGHT_AA;
        g.setFont(ViewSetting.FONT_SEQUENCE);
        g.setColor(ViewSetting.SEQUENCE_COLOR);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.drawString(this.m_sequence, this.x0 + aaWidth, this.y0 + ViewSetting.HEIGHT_AA);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        if (this.m_ptmSeqPos >= 0) {
            int xPtmA = this.x0 + aaWidth * this.m_ptmSeqPos;
            g.setColor(Color.red);
            int[] xPtm = new int[]{xPtmA, xPtmA + aaWidth, xPtmA + aaWidth / 2};
            int yPtmA = this.y0 + aaHeight + 2;
            int[] yPtm = new int[]{yPtmA, yPtmA, yPtmA + aaHeight / 2};
            g.fillPolygon(xPtm, yPtm, yPtm.length);
        }
    }

    public void setPTMSequencePosition(int i) {
        this.m_ptmSeqPos = i;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.m_sequence);
        if (this.m_ptmSeqPos >= 0) {
            sb.append("PTMSite @ " + this.m_ptmSeqPos);
        }
        return sb.toString();
    }
}

