/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.renderer;

import fr.proline.studio.table.renderer.GrayableTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;

public class CompareValueRenderer
implements GrayableTableCellRenderer {
    private CompareValuePanel m_valuePanel = null;
    private boolean m_grayed = false;
    private static Color STRIPPED_COLOR = UIManager.getColor("UIColorHighlighter.stripingBackground");

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color selectionBackground = null;
        if (isSelected) {
            selectionBackground = table.getSelectionBackground();
        } else if (row % 2 == 1) {
            selectionBackground = STRIPPED_COLOR;
        }
        if (this.m_valuePanel == null) {
            this.m_valuePanel = new CompareValuePanel();
        }
        this.m_valuePanel.init((CompareValue)value, selectionBackground, this.m_grayed);
        return this.m_valuePanel;
    }

    public void setGrayed(boolean v) {
        this.m_grayed = v;
    }

    public static class CompareValuePanel
    extends JPanel {
        private static final int DELTA_X = 6;
        private static final int DELTA_Y = 2;
        private static final int DIM_Y = 20;
        private CompareValue m_v;
        private Color m_selectionBackground;
        private boolean m_grayed;

        public void init(CompareValue v, Color selectionBackground, boolean grayed) {
            this.m_v = v;
            this.m_selectionBackground = selectionBackground;
            this.m_grayed = grayed;
        }

        @Override
        public Dimension getPreferredSize() {
            int width = (this.m_v.getNumberColumns() + 2) * 8;
            return new Dimension(width, 20);
        }

        @Override
        public void paint(Graphics g) {
            if (this.m_selectionBackground != null) {
                g.setColor(this.m_selectionBackground);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            int nbCols = this.m_v.getNumberColumns();
            for (int i = 0; i < nbCols; ++i) {
                if (this.m_grayed) {
                    Color c = this.m_v.getColor(i);
                    int gray = (int)((double)c.getRed() * 0.299 + (double)c.getGreen() * 0.587 + (double)c.getBlue() * 0.114);
                    Color newColor = new Color(gray, gray, gray).brighter();
                    g.setColor(newColor);
                } else {
                    g.setColor(this.m_v.getColor(i));
                }
                double maxValue = this.m_v.getMaximumValue();
                double value = this.m_v.getValue(i);
                int height = (int)Math.round(value / maxValue * 16.0);
                g.fillRect((i + 1) * 8, 20 - height - 2, 6, height);
                g.setColor(Color.gray);
                g.drawRect((i + 1) * 8, 20 - height - 2, 6, height);
            }
        }
    }

    public static abstract class CompareValue
    implements Comparable<CompareValue> {
        public abstract int getNumberColumns();

        public abstract Color getColor(int var1);

        public abstract double getValue(int var1);

        public abstract double getMaximumValue();

        public abstract double calculateComparableValue();
    }
}

