/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.renderer;

import fr.proline.studio.utils.DataFormat;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class FloatRenderer
implements TableCellRenderer {
    private final TableCellRenderer m_defaultRenderer;
    private int m_digits = 2;
    private boolean m_scientific = false;
    private boolean m_showNaN = false;

    public FloatRenderer(TableCellRenderer defaultRenderer, int digits, boolean scientific, boolean showNaN) {
        this.m_defaultRenderer = defaultRenderer;
        this.m_digits = digits;
        this.m_scientific = scientific;
        this.m_showNaN = showNaN;
    }

    public FloatRenderer(TableCellRenderer defaultRenderer, int digits) {
        this.m_defaultRenderer = defaultRenderer;
        this.m_digits = digits;
    }

    public FloatRenderer(TableCellRenderer defaultRenderer) {
        this.m_defaultRenderer = defaultRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String formatedValue;
        Float f = (Float)value;
        if (f == null || f.isNaN()) {
            formatedValue = this.m_showNaN ? "NaN" : "";
        } else if (this.m_scientific) {
            double dAbs = Math.abs(f.floatValue());
            if (dAbs != 0.0 && dAbs * Math.pow(10.0, this.m_digits - 1) >= 1.0) {
                formatedValue = DataFormat.format((float)f.floatValue(), (int)this.m_digits);
            } else {
                int digits = this.m_digits - 2;
                if (digits < 2) {
                    digits = 2;
                }
                formatedValue = DataFormat.formatScientific((float)f.floatValue(), (int)digits);
            }
        } else {
            formatedValue = DataFormat.format((float)f.floatValue(), (int)this.m_digits);
        }
        return this.m_defaultRenderer.getTableCellRendererComponent(table, formatedValue, isSelected, hasFocus, row, column);
    }
}

