/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.spectrum;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.studio.WindowManager;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.spectrum.PeptideFragmentationData;
import fr.proline.studio.rsmexplorer.gui.spectrum.SpectrumFragmentationUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.slf4j.LoggerFactory;

public abstract class AbstractPeptideSpectrumPanel
extends HourglassPanel
implements DataBoxPanelInterface,
SplittedPanelContainer.ReactiveTabbedComponent,
PlotChangeListener {
    public static Color ABC_SERIE_COLOR = new Color(51, 153, 255);
    public static Color XYZ_SERIE_COLOR = new Color(255, 85, 85);
    private static final int ABC_SERIE_LABEL_YPOS = 0;
    private static final int ABC_SERIE_LABEL_XPOS = 1;
    private static final int XYZ_SERIE_LABEL_YPOS = 2;
    private static final int XYZ_SERIE_LABEL_XPOS = 3;
    private static final String SERIES_NAME = "spectrumData";
    protected final DefaultXYDataset m_dataSet = new DefaultXYDataset();
    protected final JFreeChart m_chart;
    protected AbstractDataBox m_dataBox;
    protected ChartPanel m_spectrumPanel;
    protected JToolBar m_toolbar;
    protected DPeptideMatch m_peptideMatch;
    protected PeptideFragmentationData m_peptideFragmentationData;

    public AbstractPeptideSpectrumPanel(String yAxisTitle) {
        this.m_chart = ChartFactory.createXYLineChart((String)"", (String)"m/z", (String)yAxisTitle, (XYDataset)this.m_dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.m_chart.setNotify(true);
        this.m_chart.removeLegend();
        this.m_chart.setBackgroundPaint((Paint)Color.white);
        TextTitle textTitle = this.m_chart.getTitle();
        textTitle.setFont(textTitle.getFont().deriveFont(0, 10.0f));
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        plot.getRangeAxis().setUpperMargin(0.2);
        float maxXvalue = (float)this.m_chart.getXYPlot().getDomainAxis().getUpperBound();
        this.m_chart.getXYPlot().getDomainAxis().setDefaultAutoRange(new Range(0.0, (double)maxXvalue * 1.6));
        plot.setBackgroundPaint((Paint)Color.white);
        XYStickRenderer renderer = new XYStickRenderer();
        renderer.setBaseStroke(new BasicStroke(1.0f));
        plot.setRenderer((XYItemRenderer)renderer);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ChartPanel cp = new ChartPanel(this.m_chart, true){

            public void restoreAutoBounds() {
                XYPlot plot = (XYPlot)this.getChart().getPlot();
                double domainStart = plot.getDomainAxis().getDefaultAutoRange().getLowerBound();
                double domainEnd = plot.getDomainAxis().getDefaultAutoRange().getUpperBound();
                double rangeStart = plot.getRangeAxis().getDefaultAutoRange().getLowerBound();
                double rangeEnd = plot.getRangeAxis().getDefaultAutoRange().getUpperBound();
                plot.getDomainAxis().setRange(domainStart, domainEnd);
                plot.getRangeAxis().setRange(rangeStart, rangeEnd);
            }
        };
        cp.setMinimumDrawWidth(0);
        cp.setMinimumDrawHeight(0);
        cp.setMaximumDrawWidth(Integer.MAX_VALUE);
        cp.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.m_spectrumPanel = cp;
        JMenuItem showSpectrumTitle = new JMenuItem("Show Spectrum Title");
        showSpectrumTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractPeptideSpectrumPanel.this.m_peptideMatch != null && AbstractPeptideSpectrumPanel.this.m_peptideMatch.isMsQuerySet() && AbstractPeptideSpectrumPanel.this.m_peptideMatch.getMsQuery().isSpectrumFullySet()) {
                    JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), AbstractPeptideSpectrumPanel.this.m_peptideMatch.getMsQuery().getDSpectrum().getTitle(), "Spectrum Title", 1);
                }
            }
        });
        this.m_spectrumPanel.getPopupMenu().add(showSpectrumTitle);
        this.m_toolbar = this.initToolbar();
        this.add(this.m_toolbar, "West");
        this.add((Component)this.m_spectrumPanel, "Center");
    }

    public final JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("Spectre", (JPanel)this.m_spectrumPanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(DPeptideMatch peptideMatch, PeptideFragmentationData peptideFragmentationData) {
        if (peptideMatch != this.m_peptideMatch || this.m_peptideFragmentationData != peptideFragmentationData) {
            this.m_peptideMatch = peptideMatch;
            this.m_peptideFragmentationData = peptideFragmentationData;
            this.updateFragmentationPlot(peptideMatch, peptideFragmentationData);
        }
    }

    public abstract void updateFragmentationPlot(DPeptideMatch var1, PeptideFragmentationData var2);

    public abstract void addCustomAnnotations();

    public void annotateSpectrum() {
        XYTextAnnotation xyta;
        int sizeXYZserie;
        this.clearAnnotations();
        if (this.m_peptideMatch == null || this.m_peptideFragmentationData == null) {
            return;
        }
        if (this.m_peptideFragmentationData.isEmpty()) {
            return;
        }
        if (!this.m_peptideMatch.isMsQuerySet() || !this.m_peptideMatch.getMsQuery().isSpectrumFullySet()) {
            return;
        }
        List<PeptideFragmentationData.TheoreticalFragmentSeries> theoreticalFragmentSeries = this.m_peptideFragmentationData.getTheoreticalFragmentSeries();
        PeptideFragmentationData.FragmentMatch[] fragmentMatches = this.m_peptideFragmentationData.getFragmentMatches();
        String peptideSequence = this.m_peptideMatch.getPeptide().getSequence();
        int sizeMaxSeries = peptideSequence.length();
        double[][] fragTableTheo = new double[4][sizeMaxSeries + 1];
        double[][] fragTable = new double[4][sizeMaxSeries + 1];
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        String xyzSerieName = this.m_peptideFragmentationData.getXYZReferenceSeriesName();
        String abcSerieName = this.m_peptideFragmentationData.getABCReferenceSeriesName();
        int abcSeriesIndex = this.m_peptideFragmentationData.getTheoreticalFragmentSeriesIndex(abcSerieName);
        int xyzSeriesIndex = this.m_peptideFragmentationData.getTheoreticalFragmentSeriesIndex(xyzSerieName);
        double abcReferenceYPosition = this.getReferenceABCSeriesRange();
        double xyzReferenceYPosition = this.getReferenceXYZSeriesRange();
        double tickHalfSize = this.pixelToValueRange(3.0);
        plot.clearRangeMarkers();
        ValueMarker target = new ValueMarker(xyzReferenceYPosition);
        target.setPaint((Paint)XYZ_SERIE_COLOR);
        target.setLabel(xyzSerieName);
        target.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        target.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        plot.addRangeMarker((Marker)target);
        ValueMarker target2 = new ValueMarker(abcReferenceYPosition);
        target2.setPaint((Paint)ABC_SERIE_COLOR);
        target2.setLabel(abcSerieName);
        target2.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        target2.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        plot.addRangeMarker((Marker)target2);
        int sizeABCserie = theoreticalFragmentSeries.size() == 0 ? 0 : theoreticalFragmentSeries.get((int)abcSeriesIndex).masses.length;
        int n = sizeXYZserie = theoreticalFragmentSeries.size() == 0 ? 0 : theoreticalFragmentSeries.get((int)xyzSeriesIndex).masses.length;
        if (xyzSerieName.contains("z+1")) {
            xyzSerieName = "z";
        }
        int nbThroughB = 0;
        int nbThroughY = 0;
        for (int j = 0; j < theoreticalFragmentSeries.size(); ++j) {
            for (int k = 0; k < theoreticalFragmentSeries.get((int)j).masses.length; ++k) {
                fragTableTheo[0][nbThroughB] = abcReferenceYPosition;
                fragTableTheo[1][nbThroughB] = theoreticalFragmentSeries.get((int)j).masses[k];
                fragTableTheo[2][nbThroughY] = xyzReferenceYPosition;
                fragTableTheo[3][nbThroughY] = theoreticalFragmentSeries.get((int)j).masses[k];
                for (int i = 0; i < fragmentMatches.length; ++i) {
                    if (j == abcSeriesIndex && fragmentMatches[i].getCharge() == theoreticalFragmentSeries.get(j).getCharge() && fragmentMatches[i].getSeriesName().equals(theoreticalFragmentSeries.get((int)j).frag_series) && fragmentMatches[i].getPosition() == nbThroughB + 1 && Math.abs(fragmentMatches[i].calculated_moz - theoreticalFragmentSeries.get((int)j).masses[k]) < 0.1) {
                        fragTable[0][nbThroughB] = fragmentMatches[i].intensity.floatValue();
                        fragTable[1][nbThroughB] = theoreticalFragmentSeries.get((int)j).masses[k];
                    }
                    if (j != xyzSeriesIndex || fragmentMatches[i].getCharge() != theoreticalFragmentSeries.get(j).getCharge() || !fragmentMatches[i].getSeriesName().equals(theoreticalFragmentSeries.get((int)j).frag_series) || sizeMaxSeries - fragmentMatches[i].getPosition() != nbThroughY || !(Math.abs(fragmentMatches[i].calculated_moz - theoreticalFragmentSeries.get((int)j).masses[k]) < 0.1)) continue;
                    fragTable[2][nbThroughY] = fragmentMatches[i].intensity.floatValue();
                    fragTable[3][nbThroughY] = theoreticalFragmentSeries.get((int)j).masses[k];
                }
                if (j == abcSeriesIndex) {
                    ++nbThroughB;
                }
                if (j != xyzSeriesIndex) continue;
                ++nbThroughY;
            }
        }
        double abcPrev = fragTable[1][0] - SpectrumFragmentationUtil.getMassFromAminoAcid(peptideSequence.charAt(0));
        boolean xyzPrevFound = false;
        boolean abcPrevFound = false;
        String surroundingCharacters = "";
        Font font = new Font("Monospaced", 1, 11);
        if (!abcSerieName.equals("")) {
            if (peptideSequence.length() < sizeABCserie) {
                LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("AW: strange, serie length is not same length as sequence length...serie length:" + sizeABCserie + " for sequence " + peptideSequence);
                for (int filler = 0; filler < sizeABCserie - peptideSequence.length(); ++filler) {
                    peptideSequence = peptideSequence + "?";
                }
            }
            for (int i = 0; i < sizeABCserie; ++i) {
                String aa;
                if (abcPrev != 0.0 && i > 0) {
                    float[] dash = new float[]{10.0f};
                    BasicStroke stk = new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.5f);
                    XYLineAnnotation line = new XYLineAnnotation(abcPrev, abcReferenceYPosition + tickHalfSize, abcPrev, abcReferenceYPosition - tickHalfSize, (Stroke)stk, (Paint)ABC_SERIE_COLOR);
                    plot.addAnnotation((XYAnnotation)line);
                }
                if (fragTable[1][i] != 0.0 || i == sizeABCserie - 1 && abcPrevFound) {
                    if (i == sizeABCserie - 1) {
                        abcPrevFound = true;
                        fragTable[1][i] = abcPrev + SpectrumFragmentationUtil.getMassFromAminoAcid(peptideSequence.charAt(i));
                    }
                    aa = "" + peptideSequence.charAt(i);
                    xyta = new XYTextAnnotation(surroundingCharacters + aa + surroundingCharacters, (abcPrev + fragTable[1][i]) / 2.0, abcReferenceYPosition);
                    if (abcPrevFound || i == 0 || i == sizeABCserie - 1) {
                        xyta.setPaint((Paint)Color.white);
                        xyta.setBackgroundPaint((Paint)ABC_SERIE_COLOR);
                    } else {
                        xyta.setPaint((Paint)ABC_SERIE_COLOR);
                        xyta.setBackgroundPaint((Paint)Color.white);
                    }
                    xyta.setFont(font);
                    plot.addAnnotation((XYAnnotation)xyta);
                    abcPrev = fragTableTheo[1][i];
                    abcPrevFound = true;
                    continue;
                }
                aa = "" + peptideSequence.charAt(i);
                if (i == sizeABCserie - 1) {
                    fragTableTheo[1][i] = abcPrev + SpectrumFragmentationUtil.getMassFromAminoAcid(peptideSequence.charAt(i));
                }
                if (i == 0) {
                    abcPrev = fragTableTheo[1][0] - SpectrumFragmentationUtil.getMassFromAminoAcid(peptideSequence.charAt(i));
                }
                xyta = new XYTextAnnotation(surroundingCharacters + aa + surroundingCharacters, (abcPrev + fragTableTheo[1][i]) / 2.0, abcReferenceYPosition);
                xyta.setPaint((Paint)ABC_SERIE_COLOR);
                xyta.setFont(font);
                xyta.setBackgroundPaint((Paint)Color.white);
                plot.addAnnotation((XYAnnotation)xyta);
                abcPrev = fragTableTheo[1][i];
                abcPrevFound = false;
            }
        }
        double xyzPrev = 0.0;
        if (!xyzSerieName.equals("")) {
            for (int i = sizeXYZserie - 1; i >= 0; --i) {
                String aa;
                if (xyzPrev != 0.0) {
                    float[] dash = new float[]{10.0f};
                    BasicStroke stk = new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.5f);
                    XYLineAnnotation line = new XYLineAnnotation(xyzPrev, xyzReferenceYPosition - tickHalfSize, xyzPrev, xyzReferenceYPosition + tickHalfSize, (Stroke)stk, (Paint)XYZ_SERIE_COLOR);
                    plot.addAnnotation((XYAnnotation)line);
                }
                if (fragTable[3][i] != 0.0 || i == 0 && xyzPrevFound) {
                    if (i == 0) {
                        xyzPrevFound = true;
                        fragTable[3][i] = xyzPrev + SpectrumFragmentationUtil.getMassFromAminoAcid(peptideSequence.charAt(i));
                    }
                    aa = "" + peptideSequence.charAt(i);
                    xyta = new XYTextAnnotation(surroundingCharacters + aa + surroundingCharacters, (xyzPrev + fragTable[3][i]) / 2.0, xyzReferenceYPosition);
                    if (xyzPrevFound || i == sizeXYZserie - 1 || i == 0) {
                        xyta.setPaint((Paint)Color.white);
                        xyta.setBackgroundPaint((Paint)XYZ_SERIE_COLOR);
                    } else {
                        xyta.setPaint((Paint)XYZ_SERIE_COLOR);
                        xyta.setBackgroundPaint((Paint)Color.white);
                    }
                    xyta.setFont(font);
                    plot.addAnnotation((XYAnnotation)xyta);
                    xyzPrev = fragTableTheo[3][i];
                    xyzPrevFound = true;
                    continue;
                }
                aa = "" + peptideSequence.charAt(i);
                if (i == 0) {
                    fragTableTheo[3][i] = xyzPrev + SpectrumFragmentationUtil.getMassFromAminoAcid(peptideSequence.charAt(i));
                }
                if (i == sizeXYZserie - 1) {
                    xyzPrev = fragTableTheo[3][i] - SpectrumFragmentationUtil.getMassFromAminoAcid(peptideSequence.charAt(i));
                }
                xyta = new XYTextAnnotation(surroundingCharacters + aa + surroundingCharacters, (xyzPrev + fragTableTheo[3][i]) / 2.0, xyzReferenceYPosition);
                xyta.setPaint((Paint)XYZ_SERIE_COLOR);
                xyta.setFont(font);
                xyta.setBackgroundPaint((Paint)Color.white);
                plot.addAnnotation((XYAnnotation)xyta);
                xyzPrev = fragTableTheo[3][i];
                xyzPrevFound = false;
            }
        }
        this.addCustomAnnotations();
    }

    public double getReferenceABCSeriesRange() {
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        return (double)((float)plot.getRangeAxis().getUpperBound()) - this.pixelToValueRange(18.0);
    }

    public double getReferenceXYZSeriesRange() {
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        return (double)((float)plot.getRangeAxis().getUpperBound()) - this.pixelToValueRange(36.0);
    }

    public double pixelToValueRange(double pixelSize) {
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        Rectangle2D dataArea = this.m_spectrumPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        double java2DToValue = plot.getRangeAxis().java2DToValue(0.0, dataArea, plot.getRangeAxisEdge());
        java2DToValue = Math.abs(java2DToValue - plot.getRangeAxis().java2DToValue(pixelSize, dataArea, plot.getRangeAxisEdge()));
        return java2DToValue;
    }

    public abstract double[][] getMassIntensityValues(DSpectrum var1);

    protected void clearAnnotations() {
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        plot.clearAnnotations();
        plot.clearRangeMarkers();
    }

    protected void constructSpectrumChart(DPeptideMatch pm) {
        DSpectrum spectrum;
        DMsQuery msQuery;
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        this.clearAnnotations();
        this.m_dataSet.removeSeries((Comparable)((Object)SERIES_NAME));
        if (pm == null) {
            this.m_chart.setTitle("No Data Available");
            return;
        }
        Peptide p = pm.getPeptide();
        if (p == null) {
            this.m_chart.setTitle("No Data Available");
            return;
        }
        DMsQuery dMsQuery = msQuery = pm.isMsQuerySet() ? pm.getMsQuery() : null;
        if (msQuery == null) {
            this.m_chart.setTitle("No Data Available");
            return;
        }
        DSpectrum dSpectrum = spectrum = msQuery.isSpectrumFullySet() ? msQuery.getDSpectrum() : null;
        if (spectrum == null) {
            this.m_chart.setTitle("No Data Available");
            return;
        }
        double[][] data = this.getMassIntensityValues(spectrum);
        this.m_dataSet.addSeries((Comparable)((Object)SERIES_NAME), data);
        StringBuffer title = new StringBuffer("Query ");
        title.append(msQuery.getInitialId()).append(" - ").append(p.getSequence());
        if (!p.getPtmString().isEmpty() && p.getTransientData().isPeptideReadablePtmStringLoaded()) {
            title.append(" [").append(p.getTransientData().getPeptideReadablePtmString().getReadablePtmString()).append("] ");
        }
        title.append(" ").append(pm.getCharge()).append("+");
        this.m_chart.setTitle(title.toString());
        this.m_spectrumPanel.setBackground(Color.white);
        plot.getDomainAxis().setAutoRange(true);
        plot.getRangeAxis().setAutoRange(true);
    }

    public void plotChanged(PlotChangeEvent arg0) {
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public static class XYStickRenderer
    extends AbstractXYItemRenderer {
        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            double x = dataset.getXValue(series, item);
            double y = dataset.getYValue(series, item);
            if (!Double.isNaN(y)) {
                RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
                RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
                double transX = domainAxis.valueToJava2D(x, dataArea, xAxisLocation);
                double transY = rangeAxis.valueToJava2D(y, dataArea, yAxisLocation);
                double transOY = rangeAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
                g2.setPaint(this.getItemPaint(series, item));
                this.setSeriesPaint(0, Color.black);
                g2.setStroke(new BasicStroke(0.5f));
                PlotOrientation orientation = plot.getOrientation();
                if (orientation == PlotOrientation.VERTICAL) {
                    g2.drawLine((int)transX, (int)transOY, (int)transX, (int)transY);
                } else if (orientation == PlotOrientation.HORIZONTAL) {
                    g2.drawLine((int)transOY, (int)transX, (int)transY, (int)transX);
                }
                int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
                int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
                this.updateCrosshairValues(crosshairState, x, y, domainAxisIndex, rangeAxisIndex, transX, transY, orientation);
            }
        }
    }
}

