/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.spectrum;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.actions.ClearRestrainAction;
import fr.proline.studio.filter.actions.RestrainAction;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.AbstractTableAction;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsetPeptideSpectrumValuesPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final long serialVersionUID = 1L;
    private AbstractDataBox m_dataBox;
    private DPeptideMatch m_previousPeptideMatch = null;
    private String m_spectrumTitle;
    private JScrollPane m_scrollPane;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private SpectrumValuesTable m_spectrumValuesTable = null;

    public RsetPeptideSpectrumValuesPanel() {
        this.setLayout(new BorderLayout());
        JPanel spectrumValuesPanel = this.createSpectrumValuesPanel();
        this.add(spectrumValuesPanel, "Center");
    }

    private JPanel createSpectrumValuesPanel() {
        JPanel spectrumValuesPanel = new JPanel();
        spectrumValuesPanel.setBounds(0, 0, 500, 400);
        spectrumValuesPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        spectrumValuesPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        spectrumValuesPanel.add((Component)toolbar, "West");
        return spectrumValuesPanel;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_spectrumValuesTable = new SpectrumValuesTable();
        this.m_spectrumValuesTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new SpectrumValuesTableModel(), true));
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView((Component)((Object)this.m_spectrumValuesTable));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)this.m_scrollPane, c);
        return internalPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_spectrumValuesTable.getModel(), (SettingsInterface)this.m_spectrumValuesTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_spectrumValuesTable.getModel())){

            protected void filteringDone() {
                RsetPeptideSpectrumValuesPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                RsetPeptideSpectrumValuesPanel.this.m_dataBox.propagateDataChanged();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)this.m_spectrumValuesTable.getModel(), "Spectrum Values", (JXTable)this.m_spectrumValuesTable);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_spectrumValuesTable.getModel())){

            public void actionPerformed() {
                JXTable table = RsetPeptideSpectrumValuesPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(RsetPeptideSpectrumValuesPanel.this.m_dataBox.getId(), RsetPeptideSpectrumValuesPanel.this.m_dataBox.getUserName(), RsetPeptideSpectrumValuesPanel.this.m_dataBox.getDataName(), RsetPeptideSpectrumValuesPanel.this.m_dataBox.getTypeName(), table);
                Image i = RsetPeptideSpectrumValuesPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        toolbar.add((Component)this.m_addCompareDataButton);
        return toolbar;
    }

    public void setData(DPeptideMatch peptideMatch) {
        if (peptideMatch == this.m_previousPeptideMatch) {
            return;
        }
        this.m_previousPeptideMatch = peptideMatch;
        this.retrieveSpectrumData(peptideMatch);
    }

    private void retrieveSpectrumData(DPeptideMatch pm) {
        DSpectrum spectrum;
        DMsQuery msQuery;
        if (pm == null) {
            ((SpectrumValuesTableModel)((CompoundTableModel)this.m_spectrumValuesTable.getModel()).getBaseModel()).setData(null, null);
            return;
        }
        Peptide p = pm.getPeptide();
        if (p == null) {
            return;
        }
        DMsQuery dMsQuery = msQuery = pm.isMsQuerySet() ? pm.getMsQuery() : null;
        if (msQuery == null) {
            return;
        }
        DSpectrum dSpectrum = spectrum = msQuery.isSpectrumFullySet() ? msQuery.getDSpectrum() : null;
        if (spectrum == null) {
            return;
        }
        double[][] data = spectrum.getMassIntensityValues();
        if (data != null) {
            this.m_spectrumTitle = spectrum.getTitle();
            ((SpectrumValuesTableModel)((CompoundTableModel)this.m_spectrumValuesTable.getModel()).getBaseModel()).setData(data[0], data[1]);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_spectrumValuesTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_spectrumValuesTable;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class SpectrumValuesTableModel
    extends DecoratedTableModel
    implements GlobalTableModelInterface {
        public static final int COLTYPE_VALUE_ID = 0;
        public static final int COLTYPE_PEPTIDE_M_Z = 1;
        public static final int COLTYPE_PEPTIDE_INTENSITY = 2;
        private static final String[] m_columnNames = new String[]{"Id", "m/z", "Intensity"};
        private static final String[] m_columnTooltips = new String[]{"Id", "m/z", "Intensity"};
        private double[] m_massDoubleArray = null;
        private double[] m_intensityDoubleArray = null;
        private String m_modelName;
        private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

        public void setData(double[] massDoubleArray, double[] intensityDoubleArray) {
            this.m_massDoubleArray = massDoubleArray;
            this.m_intensityDoubleArray = intensityDoubleArray;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return m_columnNames.length;
        }

        public String getColumnName(int col) {
            return m_columnNames[col];
        }

        public String getToolTipForHeader(int col) {
            return m_columnTooltips[col];
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Integer.class;
                }
                case 1: 
                case 2: {
                    return Double.class;
                }
            }
            return null;
        }

        public int getRowCount() {
            if (this.m_massDoubleArray == null) {
                return 0;
            }
            return this.m_massDoubleArray.length;
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return row;
                }
                case 1: {
                    return this.m_massDoubleArray[row];
                }
                case 2: {
                    return this.m_intensityDoubleArray[row];
                }
            }
            return null;
        }

        public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
            filtersMap.put(0, (Filter)new IntegerFilter(this.getColumnName(0), null, 0));
            filtersMap.put(1, (Filter)new DoubleFilter(this.getColumnName(1), null, 1));
            filtersMap.put(2, (Filter)new DoubleFilter(this.getColumnName(2), null, 2));
        }

        public int getLoadingPercentage() {
            return 100;
        }

        public boolean isLoaded() {
            return true;
        }

        public String getDataColumnIdentifier(int columnIndex) {
            return this.getColumnName(columnIndex);
        }

        public Class getDataColumnClass(int columnIndex) {
            return this.getColumnClass(columnIndex);
        }

        public Object getDataValueAt(int rowIndex, int columnIndex) {
            return this.getValueAt(rowIndex, columnIndex);
        }

        public int[] getKeysColumn() {
            int[] keys = new int[]{0};
            return keys;
        }

        public void setName(String name) {
            this.m_modelName = name;
        }

        public String getName() {
            return this.m_modelName;
        }

        public int getInfoColumn() {
            return 0;
        }

        public Map<String, Object> getExternalData() {
            return null;
        }

        public PlotInformation getPlotInformation() {
            return null;
        }

        public Long getTaskId() {
            return -1L;
        }

        public LazyData getLazyData(int row, int col) {
            return null;
        }

        public void givePriorityTo(Long taskId, int row, int col) {
        }

        public void sortingChanged(int col) {
        }

        public int getSubTaskId(int col) {
            return -1;
        }

        public PlotType getBestPlotType() {
            return null;
        }

        public int[] getBestColIndex(PlotType plotType) {
            return null;
        }

        public String getExportRowCell(int row, int col) {
            return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return null;
        }

        public String getExportColumnName(int col) {
            return this.getColumnName(col);
        }

        public TableCellRenderer getRenderer(int row, int col) {
            if (this.m_rendererMap.containsKey(col)) {
                return this.m_rendererMap.get(col);
            }
            DefaultRightAlignRenderer renderer = null;
            switch (col) {
                case 0: {
                    renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
                    break;
                }
                case 1: 
                case 2: {
                    renderer = new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4, true, false);
                }
            }
            this.m_rendererMap.put(col, (TableCellRenderer)renderer);
            return renderer;
        }

        public GlobalTableModelInterface getFrozzenModel() {
            return this;
        }

        public ArrayList<ExtraDataType> getExtraDataTypes() {
            return null;
        }

        public Object getValue(Class c) {
            return this.getSingleValue(c);
        }

        public Object getRowValue(Class c, int row) {
            return null;
        }

        public Object getColValue(Class c, int col) {
            return null;
        }
    }

    private class SpectrumValuesTable
    extends DecoratedTable {
        public TablePopupMenu initPopupMenu() {
            TablePopupMenu popupMenu = new TablePopupMenu();
            popupMenu.addAction((AbstractTableAction)new RestrainAction(){

                public void filteringDone() {
                    RsetPeptideSpectrumValuesPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                    RsetPeptideSpectrumValuesPanel.this.m_dataBox.propagateDataChanged();
                }
            });
            popupMenu.addAction((AbstractTableAction)new ClearRestrainAction(){

                public void filteringDone() {
                    RsetPeptideSpectrumValuesPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                    RsetPeptideSpectrumValuesPanel.this.m_dataBox.propagateDataChanged();
                }
            });
            return popupMenu;
        }

        public void prepostPopupMenu() {
        }
    }
}

