/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.MapTime;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.core.orm.lcms.ProcessedMapMozCalibration;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.pattern.xic.DataboxMapAlignment;
import fr.proline.studio.rsmexplorer.gui.xic.AbstractMapAlignmentPanel;
import fr.proline.studio.rsmexplorer.gui.xic.MapTimeTableModel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTScatterPlot;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTTableModel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MapMozAlignmentPanel
extends AbstractMapAlignmentPanel {
    private Map<Long, ProcessedMap> m_pMapById;

    public MapMozAlignmentPanel(DataboxMapAlignment dataBox) {
        super(dataBox, " moz ");
    }

    @Override
    protected String getTitleLabel() {
        return "<html>Reference Map: <font color='RED'>&#x25A0;&nbsp;</font>   map   &nbsp;, Alignment Mode : I/H) </html>";
    }

    @Override
    protected List<JButton> getMoreCloudButtons() {
        return new ArrayList<JButton>();
    }

    @Override
    protected JPanel createConvertPanel() {
        JPanel moz2DeltaPanel = new JPanel();
        moz2DeltaPanel.setLayout(new FlowLayout(0));
        moz2DeltaPanel.add(this.m_srcTimeValueTF);
        moz2DeltaPanel.add(new JLabel("(min) in "));
        this.m_sourceMapsCB.setName("cbSourceMaps");
        moz2DeltaPanel.add(this.m_sourceMapsCB);
        moz2DeltaPanel.add(new JLabel(" correspond to"));
        this.m_destValueTF = new JTextField(10);
        this.m_destValueTF.setName("tfDestTime");
        this.m_destValueTF.setEditable(false);
        moz2DeltaPanel.add(this.m_destValueTF);
        moz2DeltaPanel.add(new JLabel(" delta moz "));
        return moz2DeltaPanel;
    }

    @Override
    public void setData(QuantChannelInfo quantChannelInfo, List<ExtendedTableModelInterface> compareDataInterfaceList) {
        if (!this.m_isInitialized) {
            this.m_quantChannelInfo = quantChannelInfo;
            this.m_pMapByIndex = new HashMap();
            this.m_pMapById = new HashMap<Long, ProcessedMap>();
            String[] mapItems = new String[this.m_quantChannelInfo.getDataset().getMaps().size()];
            int i = 0;
            for (ProcessedMap map : this.m_quantChannelInfo.getDataset().getMaps()) {
                String mapTitle = this.m_quantChannelInfo.getMapTitle(map.getId());
                StringBuilder sb = new StringBuilder();
                String mapColor = this.m_quantChannelInfo.getMapHtmlColor(map.getId());
                sb.append("<html><font color='").append(mapColor).append("'>&#x25A0;&nbsp;</font>");
                sb.append(mapTitle);
                sb.append("</html>");
                mapItems[i] = sb.toString();
                this.m_pMapByIndex.put(i, map);
                this.m_pMapById.put(map.getId(), map);
                ++i;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html> Alignment Smooting Mode : ");
            sb.append(this.getAlignmentSmoothingMethod());
            sb.append("</html>");
            this.m_labelTitle.setText(sb.toString());
            DefaultComboBoxModel<String> sourceMapsModel = new DefaultComboBoxModel<String>(mapItems);
            this.m_sourceMapsCB.setModel(sourceMapsModel);
            if (mapItems.length > 0) {
                sourceMapsModel.setSelectedItem(mapItems[0]);
            }
            this.setDataGraphic();
            this.m_isInitialized = true;
            this.repaint();
        }
    }

    private String getAlignmentSmoothingMethod() {
        String method = "unknown";
        try {
            Map quantParams = this.m_quantChannelInfo.getDataset().getQuantProcessingConfigAsMap();
            if (quantParams.containsKey("alignment_config")) {
                Map alignmentConfig = (Map)quantParams.get("alignment_config");
                method = alignmentConfig.getOrDefault("smoothing_method_name", "unknown");
            }
            return method;
        }
        catch (Exception e) {
            return "unknown alignment method exception ";
        }
    }

    @Override
    protected Double getCorrespondingData(Double time, Long mapId) {
        Double timeInSeconds = time * 60.0;
        logger.debug("calculate delta moz at RT " + timeInSeconds + " for mapId=" + mapId);
        Double calcDeltaMoz = Double.NaN;
        try {
            ProcessedMap pMap = this.m_pMapById.get(mapId);
            if (pMap.getProcessedMapMozCalibration() != null && pMap.getProcessedMapMozCalibration().size() > 0) {
                int index;
                List mapMozs = ((ProcessedMapMozCalibration)pMap.getProcessedMapMozCalibration().get(0)).getProcessedMapMozList();
                mapMozs.sort(Comparator.comparing(MapTime::getTime));
                for (index = 0; index < mapMozs.size() && !(((MapTime)mapMozs.get(index)).getTime() > timeInSeconds); ++index) {
                }
                if (index < mapMozs.size()) {
                    calcDeltaMoz = ((MapTime)mapMozs.get(index)).getDeltaValue();
                }
            }
            logger.debug("...result= " + calcDeltaMoz);
        }
        catch (Exception e) {
            logger.error("Error while retrieving time in map calibration: " + e);
        }
        return -calcDeltaMoz.doubleValue();
    }

    @Override
    protected void setDataGraphic() {
        long mapIdSrc = this.getSelectedMapId(this.m_sourceMapsCB);
        ProcessedMap pMap = this.m_pMapById.get(mapIdSrc);
        String mapTitle = this.m_quantChannelInfo.getMapTitle(mapIdSrc);
        String title = "MoZ calibration for " + mapTitle;
        Color color = this.m_quantChannelInfo.getMapColor(mapIdSrc);
        double crossAssignmentTimeTolerance = ((DataboxMapAlignment)this.m_dataBox).getCrossAssignmentTimeTolerance();
        double featureAlignmentTimeTolerance = ((DataboxMapAlignment)this.m_dataBox).getFeatureAlignmentTimeTolerance();
        if (pMap.getProcessedMapMozCalibration() != null && pMap.getProcessedMapMozCalibration().size() > 0) {
            IonsRTTableModel cloudData;
            MapTimeTableModel extendedTableModel = new MapTimeTableModel(((ProcessedMapMozCalibration)pMap.getProcessedMapMozCalibration().get(0)).getProcessedMapMozList(), color, title, mapTitle);
            PlotLinear alignmentCurve = new PlotLinear(this.m_alignmentGraphicPanel, (ExtendedTableModelInterface)extendedTableModel, null, 0, 1);
            alignmentCurve.setPlotInformation(extendedTableModel.getPlotInformation());
            alignmentCurve.setStroke(3.0f);
            this.m_alignmentGraphicPanel.setPlot((PlotBaseAbstract)alignmentCurve);
            if (this.m_isIonsCloudLoaded && (cloudData = this.getCloudData(mapIdSrc)) != null) {
                int axisX = 5;
                int axisY = 4;
                this.m_ionsScatterPlot = new IonsRTScatterPlot(this.m_alignmentGraphicPanel, cloudData, null, axisX, axisY);
                this.m_ionsScatterPlot.showCrossAssignedIons(this.m_showHideCrossAssigned.getActionCommand().equals("HIDE"));
                this.m_ionsScatterPlot.setColor(color);
                this.m_ionsScatterPlot.setFeatureAlignmentTimeTolerance(featureAlignmentTimeTolerance);
                if (this.m_zoomMode == 0) {
                    double yMax = alignmentCurve.getYMax();
                    double yMin = alignmentCurve.getYMin();
                    this.m_ionsScatterPlot.setYMax(yMax + 2.0 * crossAssignmentTimeTolerance);
                    this.m_ionsScatterPlot.setYMin(yMin - 2.0 * crossAssignmentTimeTolerance);
                }
                this.m_alignmentGraphicPanel.addPlot((PlotXYAbstract)this.m_ionsScatterPlot);
            }
        } else {
            this.m_alignmentGraphicPanel.clearPlotsWithRepaint();
        }
        this.m_alignmentGraphicPanel.repaint();
    }
}

