/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.XicPeptideMatchTableModel;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class XicPeptideMatchPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane m_psmScrollPane;
    private XicPeptideMatchTable m_psmTable;
    private MarkerContainerPanel m_markerContainerPanel;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;

    public XicPeptideMatchPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel featurePanel = this.createFeaturePanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                featurePanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)featurePanel, JLayeredPane.DEFAULT_LAYER);
    }

    private JPanel createFeaturePanel() {
        JPanel psmPanel = new JPanel();
        psmPanel.setBounds(0, 0, 500, 400);
        psmPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        psmPanel.add((Component)toolbar, "West");
        psmPanel.add((Component)internalPanel, "Center");
        return psmPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_psmTable.getModel(), (SettingsInterface)this.m_psmTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_psmTable.getModel())){

            protected void filteringDone() {
                XicPeptideMatchPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                XicPeptideMatchPanel.this.m_dataBox.propagateDataChanged();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_psmTable.getModel()), "PSM", (JXTable)this.m_psmTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_psmScrollPane = new JScrollPane();
        this.m_psmTable = new XicPeptideMatchTable();
        this.m_psmTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new XicPeptideMatchTableModel(this.m_psmTable), true));
        this.m_psmTable.getColumnExt(this.m_psmTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_psmTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_psmScrollPane, (MarkerComponentInterface)this.m_psmTable);
        this.m_psmScrollPane.setViewportView((Component)((Object)this.m_psmTable));
        this.m_psmTable.setFillsViewportHeight(true);
        this.m_psmTable.setViewport(this.m_psmScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void setData(Long taskId, DQuantitationChannel[] quantChannelArray, QuantChannelInfo quantChannelInfo, List<DPeptideMatch> peptideMatchList, Map<Long, List<Long>> peptideMatchIdListPerQC, boolean finished) {
        ((XicPeptideMatchTableModel)((CompoundTableModel)this.m_psmTable.getModel()).getBaseModel()).setData(taskId, quantChannelArray, quantChannelInfo, peptideMatchList, peptideMatchIdListPerQC);
        int nb = 0;
        if (peptideMatchList != null) {
            nb = peptideMatchList.size();
        }
        if (nb > 0) {
            this.m_psmTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(nb);
        }
        if (finished) {
            this.m_psmTable.setSortable(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_psmTable.dataUpdated(subTask, finished);
        if (finished) {
            this.m_psmTable.setSortable(true);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_psmTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_psmTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public DPeptideMatch getSelectedPSM() {
        return this.m_psmTable.getSelectedPSM();
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_psmTable;
    }

    private class XicPeptideMatchTable
    extends LazyTable
    implements ExportModelInterface {
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public XicPeptideMatchTable() {
            super(XicPeptideMatchPanel.this.m_psmScrollPane.getVerticalScrollBar());
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            XicPeptideMatchPanel.this.m_dataBox.addDataChanged(DPeptideMatch.class);
            XicPeptideMatchPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
            XicPeptideMatchPanel.this.m_dataBox.propagateDataChanged();
        }

        public boolean selectPSM(Long peptideMatchId, String searchText) {
            XicPeptideMatchTableModel tableModel = (XicPeptideMatchTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(peptideMatchId);
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((XicPeptideMatchTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        @Override
        public void sortingChanged(int col) {
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return XicPeptideMatchPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return XicPeptideMatchPanel.this.m_dataBox.isLoaded();
        }

        public DPeptideMatch getSelectedPSM() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            selectedRow = this.convertRowIndexToModel(selectedRow);
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            XicPeptideMatchTableModel tableModel = (XicPeptideMatchTableModel)compoundTableModel.getBaseModel();
            return tableModel.getPSM(selectedRow);
        }

        public String getExportColumnName(int col) {
            return ((CompoundTableModel)XicPeptideMatchPanel.this.m_psmTable.getModel()).getExportColumnName(this.convertColumnIndexToModel(col));
        }

        public String getExportRowCell(int row, int col) {
            return ((CompoundTableModel)this.getModel()).getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ((CompoundTableModel)this.getModel()).getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            if (rowIndex < 0) {
                return null;
            }
            int colIndex = this.columnAtPoint(p);
            if (colIndex < 0) {
                return null;
            }
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            int realRowIndex = this.convertRowIndexToModel(rowIndex);
            CompoundTableModel tableModel = (CompoundTableModel)this.getModel();
            return tableModel.getTootlTipValue(realRowIndex, realColumnIndex);
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(XicPeptideMatchPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }
    }
}

