/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.xic;

import fr.proline.core.orm.uds.BiologicalGroup;
import fr.proline.core.orm.uds.BiologicalSample;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.GroupSetup;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.RawFile;
import fr.proline.core.orm.uds.Run;
import fr.proline.core.orm.uds.SampleAnalysis;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.data.RunInfoData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.DatabaseRunsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dock.gui.InfoLabel;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.xic.CreateAction;
import fr.proline.studio.rsmexplorer.actions.xic.DeleteAction;
import fr.proline.studio.rsmexplorer.actions.xic.RenameAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import fr.proline.studio.rsmexplorer.tree.xic.DatasetReferenceNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalGroupNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICRunNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICTransferHandler;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class QuantExperimentalDesignTree
extends AbstractTree {
    private JPopupMenu m_mainPopup;
    private ArrayList<AbstractRSMAction> m_mainActions;

    public QuantExperimentalDesignTree(AbstractNode top, boolean editable, boolean canImport) {
        this(top, editable, canImport, false);
    }

    public QuantExperimentalDesignTree(AbstractNode top, boolean editable, boolean canImport, boolean restrictToDnDToItself) {
        this.setEditable(editable);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        XICTransferHandler handler = new XICTransferHandler(false, this, restrictToDnDToItself);
        super.setTransferHandler(handler);
        if (canImport) {
            this.setDropMode(DropMode.ON_OR_INSERT);
        }
        this.setDragEnabled(true);
        this.initTree(top);
    }

    @Override
    public void rename(AbstractNode rsmNode, String newName) {
        AbstractNode.NodeTypes nodeType = rsmNode.getType();
        if (nodeType == AbstractNode.NodeTypes.BIOLOGICAL_GROUP || nodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE || nodeType == AbstractNode.NodeTypes.DATA_SET) {
            ((DataSetData)rsmNode.getData()).setTemporaryName(newName);
        } else if (nodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
            ((XICBiologicalSampleAnalysisNode)rsmNode).setQuantChannelName(newName);
        }
    }

    public void renameXicTitle(String newName) {
        AbstractNode rootNode = (AbstractNode)this.m_model.getRoot();
        this.rename(rootNode, newName);
        ((DefaultTreeModel)this.getModel()).nodeChanged(rootNode);
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        AbstractNode node;
        AbstractNode.NodeTypes nodeType;
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            return false;
        }
        return this.isEditable() && ((nodeType = (node = (AbstractNode)path.getLastPathComponent()).getType()) == AbstractNode.NodeTypes.BIOLOGICAL_GROUP || nodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE || nodeType == AbstractNode.NodeTypes.DATA_SET || nodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isEditable() && SwingUtilities.isRightMouseButton(e)) {
            this.triggerPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void triggerPopup(MouseEvent e) {
        AbstractNode[] selectedNodes = this.getSelectedNodes();
        if (this.m_mainPopup == null) {
            this.m_mainActions = new ArrayList(5);
            CreateAction createAction = new CreateAction(this);
            this.m_mainActions.add(createAction);
            this.m_mainActions.add(null);
            RenameAction renameAction = new RenameAction(this);
            this.m_mainActions.add(renameAction);
            this.m_mainActions.add(null);
            DeleteAction deleteAction = new DeleteAction(this);
            this.m_mainActions.add(deleteAction);
            this.m_mainPopup = new JPopupMenu();
            for (int i = 0; i < this.m_mainActions.size(); ++i) {
                AbstractRSMAction action = this.m_mainActions.get(i);
                if (action == null) {
                    this.m_mainPopup.addSeparator();
                    continue;
                }
                this.m_mainPopup.add(action.getPopupPresenter());
            }
        }
        JPopupMenu popup = this.m_mainPopup;
        ArrayList<AbstractRSMAction> actions = this.m_mainActions;
        for (int i = 0; i < actions.size(); ++i) {
            AbstractRSMAction action = actions.get(i);
            if (action == null) continue;
            action.updateEnabled(selectedNodes);
        }
        popup.show((JComponent)e.getSource(), e.getX(), e.getY());
    }

    public static void displayExperimentalDesign(DDataset dataset, AbstractNode rootNode, AbstractTree tree, boolean expandPath, boolean includeRunNodes) {
        if (dataset == null) {
            return;
        }
        AbstractTree.RSMTreeModel treeModel = (AbstractTree.RSMTreeModel)tree.getModel();
        if (rootNode.getChildCount() > 0) {
            rootNode.removeAllChildren();
            treeModel.nodeStructureChanged(rootNode);
        }
        rootNode.setIsChanging(false);
        treeModel.nodeChanged(rootNode);
        GroupSetup groupSetup = dataset.getGroupSetup();
        if (groupSetup == null) {
            return;
        }
        ArrayList<DQuantitationChannel> listQuantChannels = dataset.getMasterQuantitationChannels().isEmpty() ? new ArrayList<DQuantitationChannel>() : ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).getQuantitationChannels();
        List listBiologicalGroups = groupSetup.getBiologicalGroups();
        int childIndex = 0;
        DDataset refDataset = ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).getIdentDataset();
        Long refResultSummaryId = ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).getIdentResultSummaryId();
        DatasetReferenceNode refDatasetNode = new DatasetReferenceNode((AbstractData)DataSetData.createTemporaryAggregate((String)(refDataset == null ? "auto" : refDataset.getName())));
        if (!(refDataset == null || refResultSummaryId != null && refResultSummaryId.equals(refDataset.getResultSummaryId()))) {
            refDatasetNode.setInvalidReference(true);
        }
        treeModel.insertNodeInto(refDatasetNode, rootNode, childIndex++);
        if (dataset.isAggregation()) {
            DatasetReferenceNode aggregationNode = new DatasetReferenceNode((AbstractData)DataSetData.createTemporaryAggregate((String)"Aggregation"), true);
            treeModel.insertNodeInto(aggregationNode, rootNode, childIndex++);
            try {
                ArrayList refDatasetIs = (ArrayList)dataset.getQuantProcessingConfigAsMap().get("quantitation_ids");
                int refDatasetIndex = 0;
                for (Integer datasetId : refDatasetIs) {
                    DataSetNode node = new DataSetNode((AbstractData)DataSetData.createTemporaryQuantitation((String)datasetId.toString()));
                    QuantExperimentalDesignTree.loadDataSet(datasetId.longValue(), node);
                    node.setIsReference();
                    treeModel.insertNodeInto(node, aggregationNode, refDatasetIndex++);
                }
            }
            catch (Exception e) {
                WindowManager.getDefault().getMainWindow().alert(InfoLabel.INFO_LEVEL.ERROR, "Unable to build aggregated datasets nodes", (Throwable)e);
            }
        }
        for (BiologicalGroup bioGroup : listBiologicalGroups) {
            XICBiologicalGroupNode biologicalGroupNode = new XICBiologicalGroupNode((AbstractData)DataSetData.createTemporaryAggregate((String)bioGroup.getName()));
            treeModel.insertNodeInto(biologicalGroupNode, rootNode, childIndex);
            List listSample = bioGroup.getBiologicalSamples();
            int childSampleIndex = 0;
            for (BiologicalSample biologicalSample : listSample) {
                String sampleName = biologicalSample.getName();
                if (sampleName.startsWith(bioGroup.getName())) {
                    sampleName = sampleName.substring(bioGroup.getName().length());
                }
                XICBiologicalSampleNode biologicalSampleNode = new XICBiologicalSampleNode((AbstractData)DataSetData.createTemporaryAggregate((String)sampleName));
                treeModel.insertNodeInto(biologicalSampleNode, biologicalGroupNode, childSampleIndex);
                int childSampleAnalysisIndex = 0;
                for (SampleAnalysis sampleAnalysis : biologicalSample.getSampleAnalyses()) {
                    DQuantitationChannel qCh = QuantExperimentalDesignTree.getQuantChannelSampleAnalysis(sampleAnalysis, listQuantChannels);
                    if (qCh == null) continue;
                    String name = qCh.getName();
                    DataSetData dsData = DataSetData.createTemporaryIdentification((String)name);
                    if (qCh.getIdentRs() != null) {
                        DDataset dds = new DDataset(qCh.getIdentDatasetId().longValue(), dataset.getProject(), name, Dataset.DatasetType.IDENTIFICATION, 0, Long.valueOf(qCh.getIdentRs().getId()), Long.valueOf(qCh.getIdentResultSummaryId()), qCh.getNumber());
                        dds.setResultSet(qCh.getIdentRs());
                        dsData.setDataset(dds);
                    }
                    dsData.setChannelNumber(Integer.valueOf(qCh.getNumber()));
                    XICBiologicalSampleAnalysisNode sampleAnalysisNode = new XICBiologicalSampleAnalysisNode((AbstractData)dsData);
                    if (qCh.getName() != null) {
                        sampleAnalysisNode.setQuantChannelName(qCh.getName());
                    }
                    if (qCh.getRun() != null) {
                        Run run = qCh.getRun();
                        RawFile rawFile = run.getRawFile();
                        RunInfoData runInfoData = new RunInfoData();
                        runInfoData.setLinkedRawFile(rawFile);
                        runInfoData.setRun(run);
                        runInfoData.setStatus(RunInfoData.Status.LINKED_IN_DATABASE);
                        XICRunNode runNode = new XICRunNode((AbstractData)runInfoData, treeModel);
                        if (includeRunNodes) {
                            sampleAnalysisNode.add(runNode);
                        } else {
                            sampleAnalysisNode.addXicRunNode(runNode, false);
                        }
                    }
                    treeModel.insertNodeInto(sampleAnalysisNode, biologicalSampleNode, childSampleAnalysisIndex);
                    if (expandPath) {
                        tree.expandPath(new TreePath(sampleAnalysisNode.getPath()));
                    } else {
                        tree.expandPath(new TreePath(biologicalSampleNode.getPath()));
                    }
                    ++childSampleAnalysisIndex;
                }
                ++childSampleIndex;
            }
            if (dataset.isAggregation()) {
                tree.expandPath(new TreePath(biologicalGroupNode.getPath()));
                Enumeration<TreeNode> e = biologicalGroupNode.children();
                while (e.hasMoreElements()) {
                    XICBiologicalSampleNode samplNode = (XICBiologicalSampleNode)e.nextElement();
                    tree.expandPath(new TreePath(samplNode.getPath()));
                }
            }
            ++childIndex;
        }
    }

    private static void loadDataSet(Long quantiDatasetId, final DataSetNode datasetNode) {
        final ArrayList readDatasetList = new ArrayList(1);
        QuantitationTree tree = QuantitationTree.getCurrentTree();
        final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        AbstractDatabaseCallback readDatasetCallback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    DDataset ds = (DDataset)readDatasetList.get(0);
                    ((DataSetData)datasetNode.getData()).setDataset(ds);
                    datasetNode.setIsChanging(false);
                    treeModel.nodeChanged(datasetNode);
                } else {
                    treeModel.removeNodeFromParent(datasetNode);
                }
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(readDatasetCallback);
        task.initLoadDataset(quantiDatasetId, readDatasetList);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    private static DQuantitationChannel getQuantChannelSampleAnalysis(SampleAnalysis sampleAnalysis, List<DQuantitationChannel> listQuantChannels) {
        for (DQuantitationChannel qCh : listQuantChannels) {
            SampleAnalysis sampleReplicate = qCh.getSampleReplicate();
            if (sampleReplicate == null || sampleReplicate.getId() != sampleAnalysis.getId()) continue;
            return qCh;
        }
        return null;
    }

    public static List<Long> getQuantifiedRsmIds(AbstractNode node) {
        ArrayList<Long> rsmIds = new ArrayList<Long>();
        Enumeration<TreeNode> xicGrps = node.children();
        while (xicGrps.hasMoreElements()) {
            AbstractNode grpNode = (AbstractNode)xicGrps.nextElement();
            if (!XICBiologicalGroupNode.class.isAssignableFrom(grpNode.getClass())) continue;
            Enumeration<TreeNode> grpSpls = grpNode.children();
            while (grpSpls.hasMoreElements()) {
                AbstractNode splNode = (AbstractNode)grpSpls.nextElement();
                Enumeration<TreeNode> identRSMs = splNode.children();
                while (identRSMs.hasMoreElements()) {
                    XICBiologicalSampleAnalysisNode qChannelNode;
                    AbstractNode identNode = (AbstractNode)identRSMs.nextElement();
                    if (!XICBiologicalSampleAnalysisNode.class.isAssignableFrom(identNode.getClass()) || (qChannelNode = (XICBiologicalSampleAnalysisNode)identNode).getData() == null || ((DataSetData)qChannelNode.getData()).getDataset() == null) continue;
                    rsmIds.add(((DataSetData)qChannelNode.getData()).getDataset().getResultSummaryId());
                }
            }
        }
        return rsmIds;
    }

    public static Map<String, Object> toExperimentalDesignParameters(AbstractNode node, DDataset refDataset, Long refRsmId) throws IllegalAccessException {
        HashMap<String, Object> experimentalDesignParams = new HashMap<String, Object>();
        String errorMsg = null;
        int ratioNumeratorGrp = 1;
        int ratioDenominatorGrp = 1;
        int grpNumber = 1;
        int splNumber = 1;
        int splAnalysisNumber = 1;
        ArrayList _biologicalGroupList = new ArrayList();
        HashMap<String, Long> _rsmIdBySampleAnalysis = new HashMap<String, Long>();
        HashMap<Long, Long> _runIdByRSMId = new HashMap<Long, Long>();
        HashMap _samplesAnalysisBySample = new HashMap();
        HashMap<Integer, String> splNameByNbr = new HashMap<Integer, String>();
        ArrayList<Long> rsmIdsToGetRunIdsFor = new ArrayList<Long>();
        Enumeration<TreeNode> xicGrps = node.children();
        while (xicGrps.hasMoreElements() && errorMsg == null) {
            AbstractNode grpNode = (AbstractNode)xicGrps.nextElement();
            if (!XICBiologicalGroupNode.class.isAssignableFrom(grpNode.getClass())) continue;
            String grpName = grpNode.getData().getName();
            Enumeration<TreeNode> grpSpls = grpNode.children();
            ArrayList<Integer> splNumbers = new ArrayList<Integer>();
            while (grpSpls.hasMoreElements() && errorMsg == null) {
                AbstractNode splNode = (AbstractNode)grpSpls.nextElement();
                String sampleName = grpName + splNode.getData().getName();
                splNameByNbr.put(splNumber, sampleName);
                splNumbers.add(splNumber++);
                Enumeration<TreeNode> identRSMs = splNode.children();
                ArrayList<String> splAnalysisNames = new ArrayList<String>();
                while (identRSMs.hasMoreElements()) {
                    XICBiologicalSampleAnalysisNode qChannelNode = (XICBiologicalSampleAnalysisNode)identRSMs.nextElement();
                    XICRunNode associatedRunNode = qChannelNode.getXicRunNode();
                    String quantChName = qChannelNode.getQuantChannelName();
                    if (quantChName == null || quantChName.isEmpty()) {
                        quantChName = qChannelNode.getData().getName();
                    }
                    splAnalysisNames.add(quantChName);
                    if (!DataSetData.class.isInstance(qChannelNode.getData())) {
                        errorMsg = "Invalide Sample Analysis specified ";
                        break;
                    }
                    if (qChannelNode.getData() == null || ((DataSetData)qChannelNode.getData()).getDataset() == null) continue;
                    Long rsmId = ((DataSetData)qChannelNode.getData()).getDataset().getResultSummaryId();
                    _rsmIdBySampleAnalysis.put(quantChName, rsmId);
                    if (associatedRunNode != null && ((RunInfoData)associatedRunNode.getData()).getRun() != null) {
                        _runIdByRSMId.put(rsmId, ((RunInfoData)associatedRunNode.getData()).getRun().getId());
                        continue;
                    }
                    rsmIdsToGetRunIdsFor.add(rsmId);
                }
                _samplesAnalysisBySample.put(sampleName, splAnalysisNames);
            }
            HashMap<String, Object> biologicalGroupParams = new HashMap<String, Object>();
            biologicalGroupParams.put("number", grpNumber++);
            biologicalGroupParams.put("name", grpName);
            biologicalGroupParams.put("sample_numbers", splNumbers);
            _biologicalGroupList.add(biologicalGroupParams);
        }
        if (!rsmIdsToGetRunIdsFor.isEmpty()) {
            _runIdByRSMId.putAll(QuantExperimentalDesignTree.getRunIdForRSMs(rsmIdsToGetRunIdsFor));
        }
        if (errorMsg != null) {
            throw new IllegalAccessException(errorMsg);
        }
        if (grpNumber > 2) {
            ratioDenominatorGrp = 2;
        }
        HashMap<String, Integer> ratioParams = new HashMap<String, Integer>();
        ratioParams.put("number", 1);
        ratioParams.put("numerator_group_number", ratioNumeratorGrp);
        ratioParams.put("denominator_group_number", ratioDenominatorGrp);
        ArrayList<HashMap<String, Integer>> ratioParamsList = new ArrayList<HashMap<String, Integer>>();
        ratioParamsList.add(ratioParams);
        HashMap<String, Object> groupSetupParams = new HashMap<String, Object>();
        groupSetupParams.put("number", 1);
        groupSetupParams.put("name", node.getData().getName());
        groupSetupParams.put("biological_groups", _biologicalGroupList);
        groupSetupParams.put("ratio_definitions", ratioParamsList);
        ArrayList<HashMap<String, Object>> groupSetupParamsList = new ArrayList<HashMap<String, Object>>();
        groupSetupParamsList.add(groupSetupParams);
        experimentalDesignParams.put("group_setups", groupSetupParamsList);
        ArrayList biologicalSampleList = new ArrayList();
        ArrayList quantChanneList = new ArrayList();
        ArrayList samplesNbrList = new ArrayList(splNameByNbr.keySet());
        Collections.sort(samplesNbrList);
        for (Integer nextSplNbr : samplesNbrList) {
            String nextSpl = (String)splNameByNbr.get(nextSplNbr);
            HashMap<String, Object> biologicalSampleParams = new HashMap<String, Object>();
            biologicalSampleParams.put("number", nextSplNbr);
            biologicalSampleParams.put("name", nextSpl);
            biologicalSampleList.add(biologicalSampleParams);
            List splAnalysis = (List)_samplesAnalysisBySample.get(nextSpl);
            for (String nextSplAnalysis : splAnalysis) {
                HashMap<String, Object> quantChannelParams = new HashMap<String, Object>();
                quantChannelParams.put("number", splAnalysisNumber++);
                quantChannelParams.put("sample_number", nextSplNbr);
                quantChannelParams.put("name", nextSplAnalysis);
                if (_rsmIdBySampleAnalysis.containsKey(nextSplAnalysis)) {
                    quantChannelParams.put("ident_result_summary_id", _rsmIdBySampleAnalysis.get(nextSplAnalysis));
                    quantChannelParams.put("run_id", _runIdByRSMId.get(_rsmIdBySampleAnalysis.get(nextSplAnalysis)));
                }
                quantChanneList.add(quantChannelParams);
            }
        }
        experimentalDesignParams.put("biological_samples", biologicalSampleList);
        ArrayList masterQuantChannelsList = new ArrayList();
        HashMap<String, Object> masterQuantChannelParams = new HashMap<String, Object>();
        masterQuantChannelParams.put("number", 1);
        masterQuantChannelParams.put("name", node.getData().getName());
        masterQuantChannelParams.put("quant_channels", quantChanneList);
        if (refDataset != null) {
            masterQuantChannelParams.put("ident_dataset_id", refRsmId != null ? refRsmId.longValue() : refDataset.getId());
            masterQuantChannelParams.put("ident_result_summary_id", refDataset.getResultSummaryId());
        }
        masterQuantChannelsList.add(masterQuantChannelParams);
        experimentalDesignParams.put("master_quant_channels", masterQuantChannelsList);
        return experimentalDesignParams;
    }

    private static HashMap<Long, Long> getRunIdForRSMs(Collection<Long> rsmIDs) {
        Long pID = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId();
        HashMap<Long, Long> returnedRunIdsByRsmIds = new HashMap<Long, Long>();
        DatabaseRunsTask loadRunIdsTask = new DatabaseRunsTask(null);
        loadRunIdsTask.initLoadRunIdsForRsms(pID.longValue(), new ArrayList<Long>(rsmIDs), returnedRunIdsByRsmIds);
        loadRunIdsTask.fetchData();
        return returnedRunIdsByRsmIds;
    }
}

