/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModelInterface;

public abstract class LazyTableModel
extends DecoratedTableModel
implements LazyTableModelInterface {
    protected LazyTable m_table;
    protected Long m_taskId = null;
    private LazyData[] m_lazyDataArray = null;

    public LazyTableModel(LazyTable table) {
        this.m_table = table;
    }

    public Long getTaskId() {
        return this.m_taskId;
    }

    public LazyData getLazyData(int row, int col) {
        int nb = this.getRowCount();
        if (this.m_lazyDataArray == null || this.m_lazyDataArray.length != nb) {
            this.m_lazyDataArray = new LazyData[nb];
            for (int i = 0; i < nb; ++i) {
                this.m_lazyDataArray[i] = new LazyData();
            }
        }
        return this.m_lazyDataArray[row];
    }

    public void givePriorityTo(Long taskId, int row, int col) {
        int sortedCol = this.m_table.getSortedColumnIndex();
        if (sortedCol == -1) {
            AccessDatabaseThread.getAccessDatabaseThread().addPriorityIndex(taskId, row);
        } else {
            AccessDatabaseThread.getAccessDatabaseThread().setPriorityIndex(taskId, row);
        }
    }

    public void sortingChanged(int col) {
        int subTaskId = this.getSubTaskId(col);
        if (subTaskId != -1) {
            AccessDatabaseThread.getAccessDatabaseThread().givePriorityToSubTask(this.m_taskId, subTaskId);
        }
    }

    public abstract int getSubTaskId(int var1);

    public PlotDataSpec getDataSpecAt(int row) {
        return null;
    }
}

