/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class ExtractionRequest {
    private final double minMz;
    private final double maxMz;
    private final double mz;
    private final float elutionTimeLowerBound;
    private final float elutionTimeUpperBound;
    private final float elutionTime;
    private final double fragmentMz;
    private final double fragmentMinMz;
    private final double fragmentMaxMz;
    private final int msLevel;

    protected ExtractionRequest(Builder builder) {
        this.maxMz = builder.getMaxMz();
        this.minMz = builder.getMinMz();
        this.elutionTimeLowerBound = builder.elutionTimeLowerBound;
        this.elutionTimeUpperBound = builder.elutionTimeUpperBound;
        this.elutionTime = builder.elutionTime;
        this.mz = builder.getMz();
        this.fragmentMz = builder.getFragmentMz();
        this.fragmentMinMz = builder.getFragmentMinMz();
        this.fragmentMaxMz = builder.getFragmentMaxMz();
        this.msLevel = builder.msLevel;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public double getMinMz() {
        return this.minMz;
    }

    public double getMaxMz() {
        return this.maxMz;
    }

    public double getMz() {
        return this.mz;
    }

    public float getElutionTimeLowerBound() {
        return this.elutionTimeLowerBound;
    }

    public float getElutionTimeUpperBound() {
        return this.elutionTimeUpperBound;
    }

    public float getElutionTime() {
        return this.elutionTime;
    }

    public double getFragmentMz() {
        return this.fragmentMz;
    }

    public double getFragmentMinMz() {
        return this.fragmentMinMz;
    }

    public double getFragmentMaxMz() {
        return this.fragmentMaxMz;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public boolean isMsnExtraction() {
        return this.msLevel > 1;
    }

    public static class Builder<T extends Builder<T>> {
        double mz = 0.0;
        double minMz = 0.0;
        double maxMz = 0.0;
        float elutionTime = -1.0f;
        float elutionTimeLowerBound = -1.0f;
        float elutionTimeUpperBound = -1.0f;
        double fragmentMz = -1.0;
        double fragmentMinMz = -1.0;
        double fragmentMaxMz = -1.0;
        int msLevel = 1;

        protected T self() {
            return (T)this;
        }

        public T setMinMz(double minMz) {
            this.minMz = minMz;
            return this.self();
        }

        public T setMaxMz(double maxMz) {
            this.maxMz = maxMz;
            return this.self();
        }

        public T setFragmentMz(double parentMz) {
            this.fragmentMz = parentMz;
            return this.self();
        }

        public T setFragmentMinMz(double minMz) {
            this.fragmentMinMz = minMz;
            return this.self();
        }

        public T setFragmentMaxMz(double maxMz) {
            this.fragmentMaxMz = maxMz;
            return this.self();
        }

        public T setElutionTimeLowerBound(float startRT) {
            this.elutionTimeLowerBound = startRT;
            return this.self();
        }

        public T setElutionTimeUpperBound(float stopRT) {
            this.elutionTimeUpperBound = stopRT;
            return this.self();
        }

        public T setElutionTime(float rt) {
            this.elutionTime = rt;
            return this.self();
        }

        public T setMz(double mz) {
            this.mz = mz;
            return this.self();
        }

        public T setMsLevel(int level) {
            this.msLevel = level;
            return this.self();
        }

        public double getMinMz() {
            return this.minMz;
        }

        public double getMaxMz() {
            return this.maxMz;
        }

        public double getMz() {
            return this.mz;
        }

        public double getFragmentMz() {
            return this.fragmentMz;
        }

        public double getFragmentMinMz() {
            return this.fragmentMinMz;
        }

        public double getFragmentMaxMz() {
            return this.fragmentMaxMz;
        }

        public ExtractionRequest build() {
            return new ExtractionRequest(this);
        }
    }
}

