/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.profi.mzdb.XicMethod;
import fr.proline.mzscope.model.ExtractionRequest;

public class MsnExtractionRequest
extends ExtractionRequest {
    private final float mzTolPPM;
    private final float fragmentMzTolPPM;
    private final XicMethod method;

    public static Builder<?> builder() {
        return new Builder();
    }

    protected MsnExtractionRequest(Builder builder) {
        super(builder);
        this.mzTolPPM = builder.mzTolPPM;
        this.fragmentMzTolPPM = builder.fragmentMzTolPPM;
        this.method = builder.method;
    }

    public float getMzTolPPM() {
        return this.mzTolPPM;
    }

    public float getFragmentMzTolPPM() {
        return this.fragmentMzTolPPM;
    }

    public XicMethod getMethod() {
        return this.method;
    }

    public static class Builder<T extends Builder<T>>
    extends ExtractionRequest.Builder<T> {
        float mzTolPPM = 10.0f;
        float fragmentMzTolPPM = 50.0f;
        XicMethod method = XicMethod.MAX;

        public T setMzTolPPM(float mzTolPPM) {
            this.mzTolPPM = mzTolPPM;
            if (this.mz > 0.0) {
                this.maxMz = this.mz + this.mz * (double)mzTolPPM / 1000000.0;
                this.minMz = this.mz - this.mz * (double)mzTolPPM / 1000000.0;
            }
            return (T)((Builder)this.self());
        }

        @Override
        public T setMz(double mz) {
            this.mz = mz;
            this.maxMz = mz + mz * (double)this.mzTolPPM / 1000000.0;
            this.minMz = mz - mz * (double)this.mzTolPPM / 1000000.0;
            return (T)((Builder)this.self());
        }

        @Override
        public T setMaxMz(double maxMz) {
            super.setMaxMz(maxMz);
            if (this.getMinMz() > 0.0) {
                this.mz = (maxMz + this.minMz) / 2.0;
                this.mzTolPPM = (float)(1000000.0 * (maxMz - this.minMz) / (2.0 * this.mz));
            }
            return (T)((Builder)this.self());
        }

        @Override
        public T setMinMz(double minMz) {
            super.setMinMz(minMz);
            if (this.getMaxMz() > 0.0) {
                this.mz = (this.maxMz + minMz) / 2.0;
                this.mzTolPPM = (float)(1000000.0 * (this.maxMz - minMz) / (2.0 * this.mz));
            }
            return (T)((Builder)this.self());
        }

        @Override
        public T setFragmentMz(double mz) {
            this.fragmentMz = mz;
            this.fragmentMaxMz = this.fragmentMz + this.fragmentMz * (double)this.fragmentMzTolPPM / 1000000.0;
            this.fragmentMinMz = this.fragmentMz - this.fragmentMz * (double)this.fragmentMzTolPPM / 1000000.0;
            super.setMsLevel(2);
            return (T)((Builder)this.self());
        }

        @Override
        public T setFragmentMaxMz(double maxMz) {
            super.setFragmentMaxMz(maxMz);
            if (this.getFragmentMinMz() > 0.0) {
                this.fragmentMz = (this.fragmentMaxMz + this.fragmentMinMz) / 2.0;
                this.fragmentMzTolPPM = (float)(1000000.0 * (this.fragmentMaxMz - this.fragmentMinMz) / (2.0 * this.fragmentMz));
                super.setMsLevel(2);
            }
            return (T)((Builder)this.self());
        }

        @Override
        public T setFragmentMinMz(double minMz) {
            super.setFragmentMinMz(minMz);
            if (this.getFragmentMaxMz() > 0.0) {
                this.fragmentMz = (this.fragmentMaxMz + this.fragmentMinMz) / 2.0;
                this.fragmentMzTolPPM = (float)(1000000.0 * (this.fragmentMaxMz - this.fragmentMinMz) / (2.0 * this.fragmentMz));
                super.setMsLevel(2);
            }
            return (T)((Builder)this.self());
        }

        public T setFragmentMzTolPPM(float mzTolPPM) {
            this.fragmentMzTolPPM = mzTolPPM;
            if (this.fragmentMz > 0.0) {
                this.fragmentMaxMz = this.fragmentMz + this.fragmentMz * (double)this.fragmentMzTolPPM / 1000000.0;
                this.fragmentMinMz = this.fragmentMz - this.fragmentMz * (double)this.fragmentMzTolPPM / 1000000.0;
            }
            return (T)((Builder)this.self());
        }

        public T setMethod(XicMethod method) {
            this.method = method;
            return (T)((Builder)this.self());
        }

        @Override
        public MsnExtractionRequest build() {
            return new MsnExtractionRequest(this);
        }
    }
}

