/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.ui.MetricsDetailsPanel;
import fr.proline.mzscope.ui.model.MapTableModel;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.MonoGraphicsPanel;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCMetricsPanel
extends JPanel
implements CrossSelectionInterface {
    private static final Logger logger = LoggerFactory.getLogger(QCMetrics.class);
    private static final String SOURCE = "Source";
    private List<QCMetrics> m_metrics;
    private List<String> m_metricNames;
    private List<Map<String, Object>> m_metricsSummaries;
    private final CompoundTableModel m_tableModel = new CompoundTableModel((GlobalTableModelInterface)new MapTableModel(), true);
    private DecoratedMarkerTable m_table;
    private MonoGraphicsPanel m_graphicsPanel;
    private JTabbedPane m_tabbedPanel;
    private JToolBar m_toolbar;
    private MetricsDetailsPanel m_detailsPanel;

    public QCMetricsPanel(List<QCMetrics> metrics) {
        this.initComponents();
        this.addMetrics(metrics, "raw file");
    }

    public void addMetrics(List<QCMetrics> metrics, String label) {
        if (this.m_metrics == null) {
            this.m_metrics = new ArrayList<QCMetrics>();
            this.m_metricNames = new ArrayList<String>();
            this.m_metricsSummaries = new ArrayList<Map<String, Object>>();
        }
        Set existingMetrics = this.m_metrics.stream().map(m -> m.getName()).collect(Collectors.toSet());
        for (QCMetrics m2 : metrics) {
            if (existingMetrics.contains(m2.getName())) continue;
            this.m_metrics.add(m2);
            Map<String, Object> summary = m2.asSummary();
            summary.put(SOURCE, label);
            this.m_metricsSummaries.add(summary);
            this.m_metricNames.add(m2.getName());
        }
        ((MapTableModel)this.m_tableModel.getBaseModel()).setData(this.m_metricsSummaries, this.m_metricNames);
        this.m_graphicsPanel.setData((ExtendedTableModelInterface)this.m_tableModel, (CrossSelectionInterface)this);
    }

    private void initComponents() {
        JSplitPane split = new JSplitPane(0);
        this.m_toolbar = new JToolBar();
        this.m_toolbar.setFloatable(false);
        this.m_toolbar.setOrientation(1);
        this.m_toolbar.setRollover(true);
        JScrollPane tableScrollPane = new JScrollPane();
        this.m_table = new DecoratedMarkerTable(){

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }
        };
        this.m_table.setModel((TableModel)this.m_tableModel);
        tableScrollPane.setViewportView((Component)this.m_table);
        this.m_table.setFillsViewportHeight(true);
        this.m_table.setViewport(tableScrollPane.getViewport());
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow;
                if (!e.getValueIsAdjusting() && (selectedRow = QCMetricsPanel.this.m_table.getSelectedRow()) >= 0) {
                    selectedRow = QCMetricsPanel.this.m_table.convertRowIndexToModel(selectedRow);
                    selectedRow = QCMetricsPanel.this.m_tableModel.convertCompoundRowToBaseModelRow(selectedRow);
                    QCMetricsPanel.this.m_detailsPanel.setQCMetrics((QCMetrics)QCMetricsPanel.this.m_metrics.get(selectedRow));
                }
            }
        });
        ExportButton exportButton = new ExportButton((ProgressInterface)this.m_tableModel, "Export", (JXTable)this.m_table);
        this.m_toolbar.add((Component)exportButton);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)this.m_tableModel){

            protected void filteringDone() {
            }
        };
        this.m_toolbar.add((Component)filterButton);
        MarkerContainerPanel markerContainerPanel = new MarkerContainerPanel(tableScrollPane, (MarkerComponentInterface)this.m_table);
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BorderLayout());
        tablePane.add((Component)this.m_toolbar, "West");
        tablePane.add((Component)markerContainerPanel, "Center");
        this.m_tabbedPanel = new JTabbedPane();
        this.m_graphicsPanel = new MonoGraphicsPanel(false);
        this.m_tabbedPanel.add("All Metrics", (Component)this.m_graphicsPanel);
        this.m_detailsPanel = new MetricsDetailsPanel();
        this.m_tabbedPanel.add("Metrics details", this.m_detailsPanel);
        split.setLeftComponent(tablePane);
        split.setRightComponent(this.m_tabbedPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)split, "Center");
    }

    public JToolBar getToolBar() {
        return this.m_toolbar;
    }

    public void select(ArrayList<Long> uniqueIds) {
        this.m_table.select(uniqueIds);
    }

    public ArrayList<Long> getSelection() {
        logger.debug("Get selection requested ! ");
        return this.m_table.getSelection();
    }
}

