/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.model.BaseFeature;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.processing.PeakelsHelper;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.dialog.RTParamDialog;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.ui.peakels.AbstractPeakelsPanel;
import fr.proline.mzscope.ui.peakels.FeaturesTableModel;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.extendedtablemodel.ImportedDataTableModel;
import fr.proline.studio.utils.IconManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesPanel
extends AbstractPeakelsPanel {
    private static final Logger logger = LoggerFactory.getLogger(FeaturesPanel.class);
    private List<IFeature> m_features = new ArrayList<IFeature>();
    private PeakelsHelper m_helper = null;

    public FeaturesPanel(IMzScopeController controller) {
        super(controller);
    }

    @Override
    protected CompoundTableModel buildTableModel() {
        FeaturesTableModel model = new FeaturesTableModel();
        return new CompoundTableModel((GlobalTableModelInterface)model, true);
    }

    @Override
    protected JToolBar initToolbar() {
        JToolBar toolbar = super.initToolbar();
        JButton matchIonsBtn = new JButton();
        matchIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE_IMPORT));
        matchIonsBtn.setToolTipText("Match (m/z,rt) values from a csv file...");
        matchIonsBtn.addActionListener(e -> this.matchCSVIons());
        toolbar.add(matchIonsBtn);
        JButton buildSpectrumBtn = new JButton();
        buildSpectrumBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SIGNAL));
        buildSpectrumBtn.setToolTipText("Build Spectrum from peakels");
        buildSpectrumBtn.addActionListener(e -> this.buildSpectrum());
        toolbar.add(buildSpectrumBtn);
        return toolbar;
    }

    private void buildSpectrum() {
        List<IPeakel> peakels = this.getSelectedIPeakels();
        Peakel peakel = peakels.get(0).getPeakel();
        PeakelsHelper helper = this.getPeakelsHelper();
        RTParamDialog dialog = new RTParamDialog((Window)this.getTopLevelAncestor());
        dialog.setHelpHeaderText("The spectrum construction needs to search for co-eluting peakels.<br> The coelution definition is based on the following time tolerance.");
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            List<Peakel> coelutingPeakels = helper.findCoelutingPeakels(peakel.getApexMz() - 5.0, peakel.getApexMz() + 5.0, peakel.getElutionTime() - dialog.getRTTolerance(), peakel.getLastElutionTime() + dialog.getRTTolerance());
            SpectrumData spectrumData = helper.buildSpectrumFromPeakels(coelutingPeakels, peakel);
            Spectrum spectrum = new Spectrum(-1, peakel.getElutionTime(), spectrumData.getMzList(), spectrumData.getIntensityList(), 1, Spectrum.ScanType.CENTROID);
            this.m_viewersController.getRawFileViewer(peakels.get(0).getRawFile(), true).setReferenceSpectrum(spectrum);
        }
    }

    private PeakelsHelper getPeakelsHelper() {
        if (this.m_helper == null) {
            Peakel[] apeakels = (Peakel[])this.m_features.stream().flatMap(f -> Arrays.stream(f.getPeakels())).toArray(Peakel[]::new);
            this.m_helper = new PeakelsHelper(apeakels);
        }
        return this.m_helper;
    }

    @Override
    protected List<IPeakel> getSelectedIPeakels() {
        if (this.m_features != null && !this.m_features.isEmpty() && this.m_table.getSelectedRowCount() > 0) {
            int[] selectedRows = this.m_table.getSelectedRows();
            List<IPeakel> selectedPeakels = Arrays.stream(selectedRows).mapToObj(r -> this.m_features.get(this.getModelRowId(r))).collect(Collectors.toList());
            return selectedPeakels;
        }
        return null;
    }

    @Override
    protected List<Peakel> getSelectedPeakels() {
        if (this.m_features != null && !this.m_features.isEmpty() && this.m_table.getSelectedRowCount() > 0) {
            int[] selectedRows = this.m_table.getSelectedRows();
            List<Peakel> selectedPeakels = Arrays.stream(selectedRows).mapToObj(r -> this.m_features.get(this.getModelRowId(r))).flatMap(f -> Arrays.stream(f.getPeakels())).collect(Collectors.toList());
            return selectedPeakels;
        }
        return null;
    }

    public void addFeatures(List<IFeature> features) {
        ((FeaturesTableModel)this.m_compoundTableModel.getBaseModel()).addFeatures(features);
        this.m_features.addAll(features);
        this.m_markerContainerPanel.setMaxLineNumber(features.size());
    }

    public void setFeatures(List<IFeature> features, boolean displayRawFileColumn) {
        this.m_modelSelectedRowBeforeSort = -1;
        this.m_helper = null;
        this.m_features = features == null ? new ArrayList() : features;
        ((FeaturesTableModel)this.m_compoundTableModel.getBaseModel()).setFeatures(this.m_features);
        this.m_markerContainerPanel.setMaxLineNumber(this.m_features.size());
        this.m_table.getColumnExt(this.m_table.convertColumnIndexToView(FeaturesTableModel.COLTYPE_FEATURE_RAWFILE.getIndex())).setVisible(displayRawFileColumn);
    }

    @Override
    protected void matchIons(List<BaseFeature> ions, ImportedDataTableModel importedTableModel) {
        float moztol = MzScopePreferences.getInstance().getMzPPMTolerance();
        Map featuresByNominalMass = this.m_features.stream().collect(Collectors.groupingBy(f -> (int)f.getMz(), Collectors.toList()));
        int matchingCount = 0;
        ArrayList<ImmutablePair> matchedFeatures = new ArrayList<ImmutablePair>();
        ArrayList<BaseFeature> notFound = new ArrayList<BaseFeature>();
        List duplicateIons = ions.stream().filter(i -> Collections.frequency(ions, i) > 1).collect(Collectors.toList());
        logger.info("ions duplicates summary :: {}", (Object)duplicateIons.size());
        for (int k = 0; k < ions.size(); ++k) {
            BaseFeature ion = ions.get(k);
            double d = ion.getMz();
            double rt = (double)ion.getElutionTime() * 60.0;
            int z = ion.getCharge();
            double i2 = ion.getApexIntensity();
            List features = featuresByNominalMass.get((int)d);
            if (Math.abs((double)Integer.valueOf((int)d).intValue() - d) < 0.01) {
                features.addAll(featuresByNominalMass.get(Integer.valueOf((int)d) - 1));
            } else if (Math.abs((double)Integer.valueOf((int)d).intValue() - d) > 0.99) {
                features.addAll(featuresByNominalMass.get(Integer.valueOf((int)d) + 1));
            }
            if (features != null) {
                IFeature feature = features.stream().filter(f -> {
                    double tolDa = f.getMz() * (double)moztol / 1000000.0;
                    return rt >= (double)f.getFirstElutionTime() - 0.6 && rt <= (double)f.getLastElutionTime() + 0.6 && Math.abs(f.getMz() - mz) < tolDa && (f.getCharge() == 0 || z == 0 || z == f.getCharge());
                }).findFirst().orElse(null);
                if (feature != null) {
                    int j;
                    ++matchingCount;
                    matchedFeatures.add(new ImmutablePair((Object)k, (Object)feature));
                    if (z == 0 || feature.getCharge() == 0) {
                        logger.warn("Charge 0 detected !!!!!!!!!!");
                    }
                    if (!(Math.abs(ion.getApexIntensity() - feature.getApexIntensity()) > 2.0f)) continue;
                    Peakel[] peakels = feature.getPeakels();
                    for (j = 0; j < peakels.length && !(Math.abs(ion.getApexIntensity() - peakels[j].getApexIntensity()) < 2.0f); ++j) {
                    }
                    if (j >= peakels.length) {
                        logger.info("Inconsistent matching : the ion intensity cannot be found: {}; {}; {}; {}; {}+ = {}; {}; {}; {}+; {}", new Object[]{k, d, rt / 60.0, i2, z, feature.getMz(), (double)feature.getElutionTime() / 60.0, Float.valueOf(feature.getApexIntensity()), feature.getCharge(), feature.getPeakelsCount()});
                        continue;
                    }
                    logger.info("The peakel matching the ion has been found at index {}. Feature matching: {}; {}; {}; {}; {}+ = {}; {}; {}; {}+; {}", new Object[]{j, k, d, rt / 60.0, i2, z, feature.getMz(), (double)feature.getElutionTime() / 60.0, Float.valueOf(feature.getApexIntensity()), feature.getCharge(), feature.getPeakelsCount()});
                    continue;
                }
                notFound.add(ion);
                continue;
            }
            notFound.add(ion);
        }
        logger.info("Found {} matches over {} ions among {} features ", new Object[]{matchingCount, ions.size(), this.m_features.size()});
        logger.info("Matched summary :: {}", (Object)matchedFeatures.size());
        logger.info("Not found summary :: {}", (Object)notFound.size());
        logger.info("Found {} matches over {}", (Object)matchingCount, (Object)ions.size());
        logger.info("Distinct features matched :: {}", (Object)matchedFeatures.stream().map(p -> (IFeature)p.getRight()).distinct().count());
        logger.info("Not found summary :: {}", (Object)notFound.size());
        Map result = matchedFeatures.stream().map(p -> (IFeature)p.getRight()).collect(Collectors.groupingBy(IFeature::getPeakelsCount, Collectors.toList()));
        for (Map.Entry entry : result.entrySet()) {
            logger.info("matched Features with {} peakels: {} or {} distinct", new Object[]{entry.getKey(), ((List)entry.getValue()).size(), ((List)entry.getValue()).stream().distinct().count()});
        }
        List monoIsotopicFeatures = matchedFeatures.stream().map(p -> (IFeature)p.getRight()).filter(f -> f.getPeakelsCount() == 1).collect(Collectors.toList());
        logger.info("Mono isotopic features summary :: {}", (Object)monoIsotopicFeatures.size());
    }
}

