/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.gui;

import fr.proline.logparser.gui.LogViewControlPanel;
import fr.proline.logparser.gui.TaskExecutionPanel;
import fr.proline.logparser.gui.TaskListInterface;
import fr.proline.logparser.model.LogTask;
import fr.proline.logparser.model.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class TaskListView
extends JScrollPane
implements TaskListInterface {
    private LogViewControlPanel m_ctrl;
    ArrayList<LogTask> m_taskList;
    TaskTable m_taskTable;
    TaskTableModel m_tableModel;
    private String[] m_columnNames = new String[]{"Task N\u00b0", "Message Id", "Thread Name", "Call Service", "Meta Info", "Status", "Project Id", "Start Time", "Stop Time", "Duration", "Parallel tasks Nb"};

    TaskListView(LogViewControlPanel control) {
        this.m_ctrl = control;
        this.setBorder(BorderFactory.createTitledBorder("List of Task"));
        this.setPreferredSize(new Dimension(1400, 250));
        this.m_taskList = new ArrayList();
        this.m_tableModel = new TaskTableModel();
        this.m_taskTable = new TaskTable(this.m_tableModel);
        this.m_taskTable.init();
        this.getViewport().add((Component)((Object)this.m_taskTable));
    }

    @Override
    public void setData(ArrayList<LogTask> tasks, String fileName) {
        ((TitledBorder)this.getBorder()).setTitle("List of Tasks     " + fileName);
        this.m_taskTable.removeAll();
        if (tasks == null || tasks.isEmpty()) {
            this.m_taskList = new ArrayList();
            this.m_tableModel.fireTableDataChanged();
        } else {
            this.m_taskList = tasks;
            this.m_tableModel.fireTableDataChanged();
            this.m_taskTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.initColumnsize();
    }

    private void initColumnsize() {
        String[] example = new String[]{"198", "853bda4a-10d9-11e8-9a85-d9411af38406", "[pool-2-thread-25]", "proline/dps/msi/ImportValidateGenerateSM", " result_files :  mascot_data/20200113/F136424.dat ", "FINISHED_W", "104", "09:01:27.985 - 09 oct. 2019 ", "09:01:27.985 - 09 oct. 2019 ", "111:59:59.999", "+10                     "};
        for (int i = 0; i < this.m_taskTable.getColumnCount(); ++i) {
            TableColumn column = this.m_taskTable.getColumnModel().getColumn(i);
            int modelIndex = this.m_taskTable.convertColumnIndexToModel(i);
            TableCellRenderer renderer = this.m_taskTable.getDefaultRenderer(column.getClass());
            Component comp = renderer.getTableCellRendererComponent((JTable)((Object)this.m_taskTable), example[modelIndex], false, false, 0, i);
            int cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(cellWidth);
        }
    }

    public class TaskNbCellRenderer
    extends DefaultTableCellRenderer {
        private TaskExecutionPanel m_valuePanel;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.m_valuePanel == null) {
                this.m_valuePanel = new TaskExecutionPanel(1, -1);
            }
            int modelIndex = table.convertRowIndexToModel(row);
            TaskTableModel model = (TaskTableModel)table.getModel();
            LogTask task = model.getTask(modelIndex);
            String toShow = (Integer)value == 0 ? "" : "+" + value;
            this.m_valuePanel.setData(task.getTimeStamp(), task.getNbOtherTaskMoment(), toShow);
            return this.m_valuePanel;
        }
    }

    class TaskTableModel
    extends AbstractTableModel {
        static final int COLTYPE_ORDER_ID = 0;
        static final int COLTYPE_MESSAGE_ID = 1;
        static final int COLTYPE_THREAD_NAME = 2;
        static final int COLTYPE_CALL_SERVICE = 3;
        static final int COLTYPE_META_INFO = 4;
        static final int COLTYPE_STATUS = 5;
        static final int COLTYPE_PROJECT_ID = 6;
        static final int COLTYPE_START_TIME = 7;
        static final int COLTYPE_STOP_TIME = 8;
        static final int COLTYPE_DURATION = 9;
        static final int COLTYPE_NB_TASK_PARALELLE = 10;

        public TaskTableModel() {
            TaskListView.this.m_taskList = new ArrayList();
        }

        @Override
        public int getRowCount() {
            return TaskListView.this.m_taskList.size();
        }

        @Override
        public int getColumnCount() {
            return TaskListView.this.m_columnNames.length;
        }

        public LogTask getTask(int row) {
            return TaskListView.this.m_taskList.get(row);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 6: {
                    return Integer.class;
                }
                case 5: {
                    return LogTask.STATUS.class;
                }
                case 7: {
                    return Date.class;
                }
                case 8: {
                    return Date.class;
                }
                case 2: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 9: {
                    return Long.class;
                }
                case 10: {
                    return Integer.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            return TaskListView.this.m_columnNames[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= TaskListView.this.m_taskList.size()) {
                return null;
            }
            LogTask taskInfo = TaskListView.this.m_taskList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowIndex;
                }
                case 6: {
                    return taskInfo.getProjectId();
                }
                case 5: {
                    return taskInfo.getStatus();
                }
                case 2: {
                    return taskInfo.getThreadName();
                }
                case 1: {
                    return taskInfo.getMessageId();
                }
                case 3: {
                    return taskInfo.getCallService();
                }
                case 4: {
                    return taskInfo.getDataSet();
                }
                case 7: {
                    return taskInfo.getStartTime();
                }
                case 8: {
                    return taskInfo.getStopTime();
                }
                case 9: {
                    return taskInfo.getDuration();
                }
                case 10: {
                    return taskInfo.getNbParallelTask();
                }
            }
            return null;
        }
    }

    class TaskTable
    extends JXTable {
        public TaskTable(TaskTableModel tModel) {
            super((TableModel)tModel);
            this.setColumnControlVisible(true);
            this.setSelectionMode(0);
            this.addHighlighter(HighlighterFactory.createSimpleStriping());
            this.setGridColor(Color.lightGray);
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int sortedIndex = lsm.getMinSelectionIndex();
                int selectedIndex = TaskListView.this.m_taskTable.convertRowIndexToModel(sortedIndex);
                LogTask task = TaskListView.this.m_taskList.get(selectedIndex);
                String taskOrder = task == null ? "" : "" + task.getTaskOrder();
                TaskListView.this.m_ctrl.valueChanged(task);
            }
        }

        public void init() {
            this.setRowSorter(new TableRowSorter<TableModel>(this.getModel()));
            this.setTableHeader(new TooltipsTableHeader(TaskListView.this.m_taskTable.getColumnModel(), TaskListView.this.m_columnNames));
            this.setColumnsVisibility();
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            int columnM = this.convertColumnIndexToModel(column);
            switch (columnM) {
                case 5: {
                    return new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            String toShow = ((LogTask.STATUS)((Object)value)).getLabelTxt();
                            JLabel lb = (JLabel)super.getTableCellRendererComponent(table, toShow, isSelected, hasFocus, row, column);
                            return lb;
                        }
                    };
                }
                case 10: {
                    return new TaskNbCellRenderer();
                }
                case 7: 
                case 8: {
                    return new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            String toShow = Utility.formatTime((Date)value);
                            JLabel lb = (JLabel)super.getTableCellRendererComponent(table, toShow, isSelected, hasFocus, row, column);
                            return lb;
                        }
                    };
                }
                case 9: {
                    return new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            String toShow = Utility.formatDurationInHour((Long)value);
                            JLabel lb = (JLabel)super.getTableCellRendererComponent(table, toShow, isSelected, hasFocus, row, column);
                            return lb;
                        }
                    };
                }
            }
            return super.getCellRenderer(row, columnM);
        }

        private void setColumnsVisibility() {
            List columns = this.getColumns(true);
            TableColumnExt columnExt = (TableColumnExt)columns.get(1);
            if (columnExt != null) {
                columnExt.setVisible(false);
            }
        }

        class TooltipsTableHeader
        extends JTableHeader {
            String[] tooltips;

            TooltipsTableHeader(TableColumnModel columnModel, String[] columnTooltips) {
                super(columnModel);
                this.tooltips = columnTooltips;
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return this.tooltips[realIndex];
            }
        }
    }
}

