/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseConnectionTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AuthenticateUserTask;
import fr.proline.studio.dpm.task.jms.GetDBConnectionTemplateTask;
import fr.proline.studio.dpm.task.util.JMSConnectionManager;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionManager {
    private static final String KEY_SERVER_URL = "serverURL";
    private static final String KEY_PROJECT_USER = "projectUser";
    private static final String KEY_USER_PASSWORD = "databasePassword";
    private static final String KEY_PASSWORD_NEEDED = "passwordNeeded";
    public static final int NOT_CONNECTED = 0;
    public static final int CONNECTION_ASKED = 1;
    public static final int CONNECTION_FAILED = 2;
    public static final int CONNECTION_DONE = 3;
    protected static final Logger m_loggerProline = LoggerFactory.getLogger((String)"ProlineStudio.DPM.Task");
    private int m_connectionState = 0;
    private TaskError m_connectionError = null;
    private String m_serverURL;
    private String m_projectUser;
    private String m_databasePassword;
    private String m_userPassword;
    private boolean m_passwordNeeded;
    private HashMap<Object, Object> m_serverConnectionParam;
    private static ServerConnectionManager m_connectionManager = null;

    public static synchronized ServerConnectionManager getServerConnectionManager() {
        if (m_connectionManager == null) {
            m_connectionManager = new ServerConnectionManager();
        }
        return m_connectionManager;
    }

    public ServerConnectionManager() {
        this.restoreParameters();
    }

    private void restoreParameters() {
        Preferences preferences = NbPreferences.root();
        this.m_serverURL = preferences.get(KEY_SERVER_URL, "");
        this.m_projectUser = preferences.get(KEY_PROJECT_USER, "");
        this.m_userPassword = preferences.get(KEY_USER_PASSWORD, "");
        this.m_passwordNeeded = preferences.getBoolean(KEY_PASSWORD_NEEDED, false);
    }

    public void saveParameters() {
        Preferences preferences = NbPreferences.root();
        preferences.put(KEY_SERVER_URL, this.m_serverURL);
        preferences.put(KEY_PROJECT_USER, this.m_projectUser);
        preferences.put(KEY_USER_PASSWORD, this.m_userPassword);
        preferences.putBoolean(KEY_PASSWORD_NEEDED, this.m_passwordNeeded);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            LoggerFactory.getLogger((String)"ProlineStudio.DPM").error("Saving Server Connection Parameters Failed", (Throwable)e);
        }
        JMSConnectionManager.getJMSConnectionManager().saveParameters();
    }

    public void tryServerConnection(Runnable connectionCallback, String serverURL, String projectUser, String userPassword, boolean changingUser) {
        boolean bl = this.m_passwordNeeded = !userPassword.isEmpty();
        if (serverURL.isEmpty()) {
            this.setConnectionState(2);
            this.m_connectionError = new TaskError("JMS Server Connection", "Empty Server Host");
            return;
        }
        JMSConnectionManager.getJMSConnectionManager().closeConnection();
        this.setConnectionState(1);
        try {
            String[] jmsHostAndPort = this.parseJMSServerURL(serverURL);
            JMSConnectionManager.getJMSConnectionManager().setJMSServerHost(jmsHostAndPort[0]);
            if (jmsHostAndPort[1] != null) {
                JMSConnectionManager.getJMSConnectionManager().setJMSServerPort(Integer.parseInt(jmsHostAndPort[1]));
            }
            JMSConnectionManager.getJMSConnectionManager().getJMSConnection();
        }
        catch (Exception e) {
            this.setConnectionState(2);
            JMSConnectionManager.getJMSConnectionManager().closeConnection();
            this.m_connectionError = new TaskError(e.getMessage());
            if (connectionCallback != null) {
                connectionCallback.run();
            }
            return;
        }
        this.userAuthenticateJMS(connectionCallback, serverURL, projectUser, userPassword, changingUser);
    }

    private String[] parseJMSServerURL(String serverURL) {
        String[] hostAndPort = new String[2];
        String parsedURL = serverURL;
        int portSep = parsedURL.indexOf(":");
        if (portSep > 0) {
            hostAndPort[0] = parsedURL.substring(0, portSep);
            hostAndPort[1] = parsedURL.substring(portSep + 1);
        } else {
            hostAndPort[0] = parsedURL;
        }
        return hostAndPort;
    }

    private void userAuthenticateJMS(final Runnable connectionCallback, final String serverURL, final String projectUser, String userPassword, final boolean changingUser) {
        final String[] databasePassword = new String[1];
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            @Override
            public boolean mustBeCalledInAWT() {
                return true;
            }

            @Override
            public void run(boolean success) {
                if (success) {
                    ServerConnectionManager.this.m_serverURL = serverURL;
                    if (changingUser) {
                        ServerConnectionManager.this.saveParameters();
                        ServerConnectionManager.this.setConnectionState(3);
                        ServerConnectionManager.this.m_serverURL = serverURL;
                        if (connectionCallback != null) {
                            connectionCallback.run();
                        }
                    } else {
                        ServerConnectionManager.this.m_databasePassword = databasePassword[0];
                        ServerConnectionManager.this.getDBConnectionTemplate(connectionCallback, projectUser, ServerConnectionManager.this.m_databasePassword);
                    }
                } else {
                    ServerConnectionManager.this.setConnectionState(2);
                    ServerConnectionManager.this.m_connectionError = this.getTaskError();
                    JMSConnectionManager.getJMSConnectionManager().closeConnection();
                    if (connectionCallback != null) {
                        connectionCallback.run();
                    }
                }
            }
        };
        m_loggerProline.debug(" ---- WILL RUN AuthenticateUserTask ");
        AuthenticateUserTask task = new AuthenticateUserTask(callback, projectUser, userPassword, databasePassword);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask(task);
    }

    private void getDBConnectionTemplate(final Runnable connectionCallback, final String projectUser, String databasePassword) {
        final HashMap<Object, Object> databaseProperties = new HashMap<Object, Object>();
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            @Override
            public boolean mustBeCalledInAWT() {
                return true;
            }

            @Override
            public void run(boolean success) {
                if (success) {
                    ServerConnectionManager.this.tryDatabaseConnection(connectionCallback, databaseProperties, projectUser);
                } else {
                    ServerConnectionManager.this.setConnectionState(2);
                    ServerConnectionManager.this.m_connectionError = this.getTaskError();
                    if (connectionCallback != null) {
                        connectionCallback.run();
                    }
                }
            }
        };
        m_loggerProline.debug(" ---- WILL RUN GetDBConnectionTemplateTask with  " + databasePassword);
        GetDBConnectionTemplateTask task = new GetDBConnectionTemplateTask(callback, databasePassword, databaseProperties);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask(task);
    }

    private void tryDatabaseConnection(final Runnable connectionCallback, final HashMap<Object, Object> databaseProperties, String projectUser) {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    ServerConnectionManager.this.m_serverConnectionParam = databaseProperties;
                    DatabaseDataManager.getDatabaseDataManager().setServerConnectionProperties(ServerConnectionManager.this.m_serverConnectionParam);
                    ServerConnectionManager.this.saveParameters();
                    ServerConnectionManager.this.setConnectionState(3);
                } else {
                    ServerConnectionManager.this.setConnectionState(2);
                    ServerConnectionManager.this.m_connectionError = this.getTaskError();
                }
                if (connectionCallback != null) {
                    connectionCallback.run();
                }
            }
        };
        DatabaseConnectionTask connectionTask = new DatabaseConnectionTask(callback);
        connectionTask.initConnectionToUDS(databaseProperties, projectUser);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)connectionTask);
    }

    public HashMap<Object, Object> getConnectionParams() {
        return this.m_serverConnectionParam;
    }

    public String getServerURL() {
        return this.m_serverURL;
    }

    public String getProjectUser() {
        return this.m_projectUser;
    }

    public String getDatabasePassword() {
        return this.m_databasePassword;
    }

    public String getUserPassword() {
        return this.m_userPassword;
    }

    public void setServerURL(String serverURL) {
        this.m_serverURL = serverURL;
    }

    public void setProjectUser(String projectUser) {
        this.m_projectUser = projectUser;
    }

    public void setUserPassword(String userPassword) {
        this.m_userPassword = userPassword;
    }

    public void setPasswordNeeded(boolean passwordNeeded) {
        this.m_passwordNeeded = passwordNeeded;
    }

    public synchronized boolean isConnectionFailed() {
        return this.m_connectionState == 2;
    }

    public synchronized boolean isConnectionAsked() {
        return this.m_connectionState == 1;
    }

    public synchronized boolean isConnectionDone() {
        return this.m_connectionState == 3;
    }

    public synchronized boolean isNotConnected() {
        return this.m_connectionState == 0;
    }

    public synchronized void setConnectionState(int connectionState) {
        this.m_connectionState = connectionState;
    }

    public TaskError getConnectionError() {
        return this.m_connectionError;
    }
}

