/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class CertifyIdentificationTask
extends AbstractJMSTask {
    private String m_parserId;
    private HashMap<String, String> m_parserArguments;
    private String[] m_pathArray;
    private long m_projectId;
    private String[] m_certifyErrorMessage = null;

    public CertifyIdentificationTask(AbstractJMSCallback callback, String parserId, HashMap<String, String> parserArguments, String[] pathArray, long projectId, String[] certifyErrorMessage) {
        super(callback, new TaskInfo("JMS Check Files to Import : " + pathArray[0] + ", ...", true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_parserId = parserId;
        this.m_parserArguments = parserArguments;
        this.m_pathArray = pathArray;
        this.m_projectId = projectId;
        this.m_certifyErrorMessage = certifyErrorMessage;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/dps/msi/CertifyResultFiles");
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        ArrayList args = new ArrayList();
        for (String m_pathArray1 : this.m_pathArray) {
            HashMap<String, String> resultfile = new HashMap<String, String>();
            resultfile.put("path", m_pathArray1);
            resultfile.put("format", this.m_parserId);
            args.add(resultfile);
        }
        params.put("result_files", args);
        params.put("importer_properties", this.m_parserArguments);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            String returnedResult = (String)jsonResponse.getResult();
            if (returnedResult == null || returnedResult.isEmpty()) {
                m_loggerProline.debug("Invalid result");
                throw new Exception("null or empty result " + returnedResult);
            }
            m_loggerProline.debug("Result :\n" + returnedResult);
            if (returnedResult.equalsIgnoreCase("OK")) {
                this.m_certifyErrorMessage[0] = null;
            } else {
                this.m_certifyErrorMessage[0] = returnedResult;
                String errorMessage = returnedResult;
                this.m_taskError = new TaskError(errorMessage);
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : returnedResult");
                throw new Exception(errorMessage);
            }
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

