/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class GetExportInformationTask
extends AbstractJMSTask {
    private static String m_request = "proline/dps/uds/GetExportInformation";
    private DDataset m_dataset;
    private String m_mode;
    private List<String> m_customizableExport;

    public GetExportInformationTask(AbstractJMSCallback callback, DDataset dataset, List<String> config) {
        super(callback, new TaskInfo("Get Export Information " + (dataset == null ? "null" : dataset.getName()), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_dataset = dataset;
        this.m_customizableExport = config;
    }

    public GetExportInformationTask(AbstractJMSCallback callback, String mode, List<String> config) {
        super(callback, new TaskInfo("Get Export Information " + mode, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_mode = mode;
        this.m_customizableExport = config;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_request);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !String.class.isInstance(result)) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No valid configuration file / information returned :" + result);
                throw new Exception("No valid configuration returned : " + result);
            }
            String configStr = (String)result;
            if (configStr.isEmpty()) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No configuration returned.");
                throw new Exception("No configuration returned. " + result);
            }
            this.m_customizableExport.add(configStr);
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> extraParams = new HashMap<String, String>();
        if (this.m_dataset != null) {
            params.put("project_id", this.m_dataset.getProject().getId());
            params.put("dataset_id", this.m_dataset.getId());
        } else {
            extraParams.put("export_mode", this.m_mode);
        }
        params.put("extra_params", extraParams);
        return params;
    }
}

